/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.scene.server.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.scene.api.po.TemplateRuleLibRelevancyPo;
import com.jxdinfo.idp.scene.server.mapper.TemplateRuleLibRelevancyMapper;
import com.jxdinfo.idp.scene.server.service.TemplateRuleLibRelevancyService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TemplateRuleLibRelevancyServiceImpl
extends ServiceImpl<TemplateRuleLibRelevancyMapper, TemplateRuleLibRelevancyPo>
implements TemplateRuleLibRelevancyService {
    private static final Logger log = LoggerFactory.getLogger(TemplateRuleLibRelevancyServiceImpl.class);
    @Autowired
    private TemplateRuleLibRelevancyMapper templateRuleLibRelevancyMapper;

    @Override
    public List<TemplateRuleLibRelevancyPo> findAllByTemplateId(List<Long> templateIdList) {
        if (ObjectUtil.isNotEmpty(templateIdList)) {
            return this.templateRuleLibRelevancyMapper.findAllByTemplateId(templateIdList);
        }
        return new ArrayList<TemplateRuleLibRelevancyPo>();
    }

    @Override
    public List<TemplateRuleLibRelevancyPo> findAllBySceneId(long sceneId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"scene_id", (Object)sceneId);
        return ((TemplateRuleLibRelevancyMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public void delete(long templateId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"template_id", (Object)templateId);
        this.templateRuleLibRelevancyMapper.delete((Wrapper)queryWrapper);
    }

    @Override
    public void deleteByTemplateId(List<Long> templateIdList) {
        if (ObjectUtil.isNotEmpty(templateIdList)) {
            this.templateRuleLibRelevancyMapper.deleteByTemplateId(templateIdList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdate(long templateId, List<Long> ruleLibIdList) {
        List<TemplateRuleLibRelevancyPo> templateRuleLibRelevancyPoList = this.findAllByTemplateId(Collections.singletonList(templateId));
        ArrayList<TemplateRuleLibRelevancyPo> templateRuleLibRelevancyPos = new ArrayList<TemplateRuleLibRelevancyPo>();
        for (Long ruleLibId2 : ruleLibIdList) {
            if (!templateRuleLibRelevancyPoList.stream().noneMatch(relevancyPo -> relevancyPo.getTemplateId() == templateId && relevancyPo.getRuleLibId() == ruleLibId2.longValue())) continue;
            TemplateRuleLibRelevancyPo po = new TemplateRuleLibRelevancyPo();
            po.setTemplateId(templateId);
            po.setRuleLibId(ruleLibId2.longValue());
            po.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
            templateRuleLibRelevancyPos.add(po);
        }
        this.saveBatch(templateRuleLibRelevancyPos);
        List ruleLibIdsExist = templateRuleLibRelevancyPoList.stream().map(TemplateRuleLibRelevancyPo::getRuleLibId).collect(Collectors.toList());
        List<Long> deleteRuleLibIdList = ruleLibIdsExist.stream().filter(ruleLibId -> !ruleLibIdList.contains(ruleLibId)).collect(Collectors.toList());
        deleteRuleLibIdList.forEach(id -> this.templateRuleLibRelevancyMapper.deleteByTemplateIdAndRuleLibId(templateId, (long)id));
    }
}

