/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.scene.server.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.extract.domain.po.ExtractItem;
import com.jxdinfo.idp.extract.interf.IExtractCore;
import com.jxdinfo.idp.interf.DocTypeService;
import com.jxdinfo.idp.po.DocTypePo;
import com.jxdinfo.idp.rule.api.service.IRuleService;
import com.jxdinfo.idp.rule.api.vo.RuleItemGroupQueryVo;
import com.jxdinfo.idp.rule.api.vo.RuleItemQueryVo;
import com.jxdinfo.idp.rule.api.vo.RuleItemVo;
import com.jxdinfo.idp.rule.api.vo.RuleLibQueryVo;
import com.jxdinfo.idp.rule.api.vo.RuleLibVo;
import com.jxdinfo.idp.scene.api.dto.QueryRuleLibDto;
import com.jxdinfo.idp.scene.api.dto.SceneConfigResult;
import com.jxdinfo.idp.scene.api.dto.SceneConfigResultDto;
import com.jxdinfo.idp.scene.api.po.SceneDocTypeRelevancyPo;
import com.jxdinfo.idp.scene.api.po.SceneExtractItemDocTypeRelevancyPo;
import com.jxdinfo.idp.scene.api.po.SceneRuleExtractRelevancyPo;
import com.jxdinfo.idp.scene.api.po.SceneRuleItemDocTypeRelevancyPo;
import com.jxdinfo.idp.scene.api.po.SceneRuleLibRelevancyPo;
import com.jxdinfo.idp.scene.api.po.SceneRuleReviewItemRelevancyPo;
import com.jxdinfo.idp.scene.api.po.SceneTemplateGroupPo;
import com.jxdinfo.idp.scene.api.po.SceneTemplatePo;
import com.jxdinfo.idp.scene.api.po.SceneTemplateRelevancyPo;
import com.jxdinfo.idp.scene.api.po.TemplateExtractItemDocTypeRelevancyPo;
import com.jxdinfo.idp.scene.api.po.TemplateRuleExtractRelevancyPo;
import com.jxdinfo.idp.scene.api.po.TemplateRuleLibItemRelevancyPo;
import com.jxdinfo.idp.scene.api.po.TemplateRuleLibRelevancyPo;
import com.jxdinfo.idp.scene.api.vo.GroupTemplateVo;
import com.jxdinfo.idp.scene.api.vo.SceneTemplateVo;
import com.jxdinfo.idp.scene.dto.ExtractItemObject;
import com.jxdinfo.idp.scene.dto.RuleItemObject;
import com.jxdinfo.idp.scene.server.mapper.SceneTemplateMapper;
import com.jxdinfo.idp.scene.server.service.SceneDocTypeRelevancyService;
import com.jxdinfo.idp.scene.server.service.SceneExtractItemDocTypeRelevancyService;
import com.jxdinfo.idp.scene.server.service.SceneRuleExtractRelevancyService;
import com.jxdinfo.idp.scene.server.service.SceneRuleItemDocTypeRelevancyService;
import com.jxdinfo.idp.scene.server.service.SceneRuleLibRelevancyService;
import com.jxdinfo.idp.scene.server.service.SceneRuleReviewItemRelevancyService;
import com.jxdinfo.idp.scene.server.service.SceneTemplateGroupService;
import com.jxdinfo.idp.scene.server.service.SceneTemplateRelevancyService;
import com.jxdinfo.idp.scene.server.service.SceneTemplateService;
import com.jxdinfo.idp.scene.server.service.TemplateExtractItemDocTypeRelevancyService;
import com.jxdinfo.idp.scene.server.service.TemplateRuleExtractRelevancyService;
import com.jxdinfo.idp.scene.server.service.TemplateRuleLibItemRelevancyService;
import com.jxdinfo.idp.scene.server.service.TemplateRuleLibRelevancyService;
import com.jxdinfo.idp.vo.DocTypeVo;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SceneTemplateImpl
extends ServiceImpl<SceneTemplateMapper, SceneTemplatePo>
implements SceneTemplateService {
    private static final Logger log = LoggerFactory.getLogger(SceneTemplateImpl.class);
    @Autowired
    private DocTypeService docTypeService;
    @Autowired
    private IRuleService ruleService;
    @Autowired
    private IExtractCore extractCoreService;
    @Autowired
    private TemplateRuleLibRelevancyService templateRuleLibRelevancyService;
    @Autowired
    private TemplateRuleLibItemRelevancyService templateRuleLibItemRelevancyService;
    @Autowired
    private TemplateRuleExtractRelevancyService templateRuleExtractRelevancyService;
    @Autowired
    private TemplateExtractItemDocTypeRelevancyService templateExtractItemDocTypeRelevancyService;
    @Autowired
    private SceneTemplateMapper sceneTemplateMapper;
    @Autowired
    private SceneRuleExtractRelevancyService sceneRuleExtractRelevancyService;
    @Autowired
    private SceneRuleReviewItemRelevancyService sceneRuleReviewItemRelevancyService;
    @Autowired
    private SceneExtractItemDocTypeRelevancyService sceneExtractItemDocTypeRelevancyService;
    @Autowired
    private SceneTemplateRelevancyService sceneTemplateRelevancyService;
    @Autowired
    private SceneRuleItemDocTypeRelevancyService sceneRuleItemDocTypeRelevancyService;
    @Autowired
    private SceneDocTypeRelevancyService sceneDocTypeRelevancyService;
    @Autowired
    private SceneRuleLibRelevancyService sceneRuleLibRelevancyService;
    @Autowired
    private SceneTemplateGroupService templateGroupService;
    @Autowired
    private SceneTemplateMapper templateMapper;

    @Override
    public List<SceneTemplatePo> searchTemplate(String name, String startCreateTime, String endCreateTime) {
        if (name == null && startCreateTime == null && endCreateTime == null) {
            return null;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        if (name != null && !name.isEmpty()) {
            queryWrapper.like((Object)"template_name", (Object)name);
        }
        if (startCreateTime != null && !startCreateTime.isEmpty()) {
            queryWrapper.ge((Object)"create_time", (Object)this.getDateTime(startCreateTime + "000000"));
        }
        if (endCreateTime != null && !endCreateTime.isEmpty()) {
            queryWrapper.le((Object)"create_time", (Object)this.getDateTime(endCreateTime + "235959"));
        }
        return this.templateMapper.selectList((Wrapper)queryWrapper);
    }

    private LocalDateTime getDateTime(String dateString) {
        if (!dateString.isEmpty()) {
            dateString = dateString.replace("-", "");
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
            return LocalDateTime.parse(dateString, formatter);
        }
        return null;
    }

    @Override
    public List<GroupTemplateVo> search(String name, String startTime, String endTime) {
        List<SceneTemplatePo> sceneTemplatePoList = this.searchTemplate(name, startTime, endTime);
        List<SceneTemplateVo> sceneTemplateVoList = this.addDocTypeFormat(sceneTemplatePoList);
        List<SceneTemplateGroupPo> sceneTemplateGroupPoList = this.templateGroupService.findAll();
        ArrayList<GroupTemplateVo> groupTemplateVoList = new ArrayList<GroupTemplateVo>();
        for (SceneTemplateVo sceneTemplateVo : sceneTemplateVoList) {
            Optional<SceneTemplateGroupPo> templateGroupPoOptional = sceneTemplateGroupPoList.stream().filter(item -> item.getId() == sceneTemplateVo.getGroupId()).findFirst();
            if (templateGroupPoOptional.isPresent()) {
                GroupTemplateVo templateVo = new GroupTemplateVo(templateGroupPoOptional.get(), Collections.singletonList(sceneTemplateVo));
                groupTemplateVoList.add(templateVo);
                continue;
            }
            groupTemplateVoList.forEach(dto -> {
                if (dto.getGroupId() == sceneTemplateVo.getGroupId()) {
                    dto.getSceneTemplatePoList().add(sceneTemplateVo);
                }
            });
        }
        return groupTemplateVoList;
    }

    @Override
    public List<SceneTemplatePo> findAllTemplate() {
        QueryWrapper queryWrapper = new QueryWrapper();
        return ((SceneTemplateMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<SceneTemplateVo> findAll() {
        List<SceneTemplatePo> sceneTemplatePoList = this.findAllTemplate();
        return this.addDocTypeFormat(sceneTemplatePoList);
    }

    private List<SceneTemplateVo> addDocTypeFormat(List<SceneTemplatePo> sceneTemplatePoList) {
        ArrayList<SceneTemplateVo> sceneTemplateVoList = new ArrayList<SceneTemplateVo>();
        List docTypeIdList = sceneTemplatePoList.stream().map(SceneTemplatePo::getDocTypeId).collect(Collectors.toList());
        if (!docTypeIdList.isEmpty()) {
            List docTypeVoList = this.docTypeService.getDocTypeListByIds(docTypeIdList);
            sceneTemplatePoList.forEach(po -> {
                SceneTemplateVo sceneTemplateVo = new SceneTemplateVo(po);
                Optional<DocTypePo> docTypeVoOptional = docTypeVoList.stream().filter(docTypeVo -> Objects.equals(docTypeVo.getId(), po.getDocTypeId())).findFirst();
                if (docTypeVoOptional.isPresent()) {
                    List formatList = Arrays.stream(docTypeVoOptional.get().getFormat().split(",")).collect(Collectors.toList());
                    sceneTemplateVo.setDocTypeFormatList(formatList);
                }
                sceneTemplateVoList.add(sceneTemplateVo);
            });
        }
        return sceneTemplateVoList;
    }

    @Override
    public List<GroupTemplateVo> findAllByGroup() {
        List<SceneTemplateGroupPo> templateGroupPos = this.templateGroupService.findAll();
        ArrayList<GroupTemplateVo> groupTemplateVoList = new ArrayList<GroupTemplateVo>();
        List<SceneTemplateVo> sceneTemplateVoList = this.findAll();
        for (SceneTemplateGroupPo groupPo : templateGroupPos) {
            List sceneTemplateVos = sceneTemplateVoList.stream().filter(item -> item.getGroupId() == groupPo.getId()).collect(Collectors.toList());
            GroupTemplateVo groupTemplateVo = new GroupTemplateVo(groupPo, sceneTemplateVos);
            groupTemplateVoList.add(groupTemplateVo);
        }
        return groupTemplateVoList;
    }

    @Override
    public List<SceneTemplateVo> getChosenTemplate(long sceneId) {
        List<SceneTemplateRelevancyPo> sceneTemplateRelevancyPoList = this.sceneTemplateRelevancyService.findAllBySceneId(sceneId);
        List templateIdList = sceneTemplateRelevancyPoList.stream().map(SceneTemplateRelevancyPo::getTemplateId).collect(Collectors.toList());
        List<SceneTemplateVo> sceneTemplateVoList = this.findAll();
        sceneTemplateVoList.forEach(item -> {
            if (templateIdList.contains(item.getId())) {
                item.setChosen(true);
            }
        });
        return sceneTemplateVoList;
    }

    private RuleLibVo getRuleLibVo(long ruleLibId) {
        Optional ruleLibVoOptional;
        RuleLibQueryVo ruleLibQueryVo = new RuleLibQueryVo();
        ruleLibQueryVo.setId(Long.valueOf(ruleLibId));
        Page ruleLibVoPage = this.ruleService.queryRuleLib(ruleLibQueryVo);
        if (ObjectUtil.isNotEmpty((Object)ruleLibVoPage.getRecords()) && (ruleLibVoOptional = ruleLibVoPage.getRecords().stream().findFirst()).isPresent()) {
            return (RuleLibVo)ruleLibVoOptional.get();
        }
        return null;
    }

    @Override
    public List<QueryRuleLibDto> getRuleLibByTemplate(List<Long> templateIdList) {
        List<TemplateRuleLibRelevancyPo> templateRuleLibRelevancyPoList = this.templateRuleLibRelevancyService.findAllByTemplateId(templateIdList);
        ArrayList<QueryRuleLibDto> queryRuleLibDtoList = new ArrayList<QueryRuleLibDto>();
        for (TemplateRuleLibRelevancyPo po : templateRuleLibRelevancyPoList) {
            RuleLibVo ruleLibPo = this.getRuleLibVo(po.getRuleLibId());
            if (ruleLibPo == null) continue;
            RuleLibQueryVo queryVoTemp = new RuleLibQueryVo();
            queryVoTemp.setPid(Long.valueOf(po.getRuleLibId()));
            List ruleLibVoList = this.ruleService.queryRuleLibTree(queryVoTemp);
            for (RuleLibVo ruleLibVo : ruleLibVoList) {
                if (queryRuleLibDtoList.stream().anyMatch(dto -> dto.getRuleLibId() == ruleLibPo.getId().longValue())) {
                    for (QueryRuleLibDto queryRuleLibDto : queryRuleLibDtoList) {
                        if (queryRuleLibDto.getRuleLibId() != ruleLibPo.getId().longValue()) continue;
                        queryRuleLibDto.getRuleLibVoList().add(ruleLibVo);
                    }
                    continue;
                }
                QueryRuleLibDto queryRuleLibDto = new QueryRuleLibDto(ruleLibVo);
                queryRuleLibDto.setRuleLibId(ruleLibPo.getId().longValue());
                queryRuleLibDto.setRuleLibName(ruleLibPo.getLibName());
                queryRuleLibDtoList.add(queryRuleLibDto);
            }
        }
        return queryRuleLibDtoList;
    }

    @Override
    public List<RuleLibVo> getRuleLibByTemplateByGroup(List<Long> templateIdList) {
        List<TemplateRuleLibRelevancyPo> templateRuleLibRelevancyPoList = this.templateRuleLibRelevancyService.findAllByTemplateId(templateIdList);
        ArrayList<RuleLibVo> ruleLibVoListAll = new ArrayList<RuleLibVo>();
        for (TemplateRuleLibRelevancyPo po : templateRuleLibRelevancyPoList) {
            RuleItemGroupQueryVo queryVo = new RuleItemGroupQueryVo();
            queryVo.setRuleLibId(Long.valueOf(po.getRuleLibId()));
            List ruleLibVoList = this.ruleService.queryRuleItemGroup(queryVo);
            if (ruleLibVoList.isEmpty()) continue;
            ruleLibVoListAll.addAll(ruleLibVoList);
        }
        return ruleLibVoListAll;
    }

    @Override
    public List<DocTypePo> getDocTypeByTemplate(List<Long> templateIdList) {
        List<SceneTemplatePo> sceneTemplatePoList = this.getByTemplateId(templateIdList);
        if (ObjectUtil.isNotEmpty(sceneTemplatePoList)) {
            List docTypeIdList = sceneTemplatePoList.stream().map(SceneTemplatePo::getDocTypeId).collect(Collectors.toList());
            return this.docTypeService.getDocTypeListByIds(docTypeIdList);
        }
        return new ArrayList<DocTypePo>();
    }

    @Override
    public List<SceneTemplatePo> getByTemplateId(List<Long> templateIdList) {
        if (ObjectUtil.isNotEmpty(templateIdList)) {
            return this.sceneTemplateMapper.findAllByTemplateId(templateIdList);
        }
        return new ArrayList<SceneTemplatePo>();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveTemplateInfo(List<RuleItemObject> ruleItemObjectList) {
        if (ObjectUtil.isNull(ruleItemObjectList) || ruleItemObjectList.isEmpty()) {
            return;
        }
        long templateId = ruleItemObjectList.get(0).getTemplateId();
        List<TemplateRuleExtractRelevancyPo> templateRuleExtractRelevancyPoListAll = this.templateRuleExtractRelevancyService.findAllByTemplateId(templateId);
        List<TemplateExtractItemDocTypeRelevancyPo> templateExtractItemDocTypeRelevancyPoListAll = this.templateExtractItemDocTypeRelevancyService.findAllByTemplateId(templateId);
        this.templateRuleLibItemRelevancyService.delete(templateId);
        ArrayList<TemplateRuleExtractRelevancyPo> templateRuleExtractRelevancyPoList = new ArrayList<TemplateRuleExtractRelevancyPo>();
        ArrayList<TemplateExtractItemDocTypeRelevancyPo> templateExtractItemDocTypeRelevancyPoList = new ArrayList<TemplateExtractItemDocTypeRelevancyPo>();
        ArrayList<TemplateRuleLibItemRelevancyPo> templateRuleLibItemRelevancyPoList = new ArrayList<TemplateRuleLibItemRelevancyPo>();
        for (RuleItemObject ruleItemObject : ruleItemObjectList) {
            long templateId2 = ruleItemObject.getTemplateId();
            long ruleItemId = ruleItemObject.getRuleItemId();
            long ruleLibId = ruleItemObject.getRuleLibId();
            templateRuleLibItemRelevancyPoList.add(this.getTemplateRuleLibItemRelevancy(ruleItemObject));
            for (ExtractItemObject item : ruleItemObject.getExtractItemList()) {
                Long extractItemId = item.getId();
                if (extractItemId == null) {
                    ExtractItem extractItem = new ExtractItem();
                    extractItem.setName(item.getName());
                    extractItem.setDescription(item.getDescription());
                    extractItem.setReturnType(item.getReturnType());
                    extractItemId = this.extractCoreService.save(extractItem);
                }
                this.addTemplateRuleExtractRelevancyPo(templateRuleExtractRelevancyPoListAll, templateRuleExtractRelevancyPoList, templateId2, extractItemId, ruleItemId, ruleLibId);
                Iterator iterator = item.getDocTypeIdList().iterator();
                while (iterator.hasNext()) {
                    long docTypeId = (Long)iterator.next();
                    this.addTemplateExtractDocRelevancyPo(templateExtractItemDocTypeRelevancyPoListAll, templateExtractItemDocTypeRelevancyPoList, templateId2, ruleItemId, extractItemId, docTypeId, ruleLibId);
                }
            }
        }
        this.templateRuleLibItemRelevancyService.saveBatch(templateRuleLibItemRelevancyPoList);
        this.templateRuleExtractRelevancyService.saveBatch(templateRuleExtractRelevancyPoList);
        this.templateExtractItemDocTypeRelevancyService.saveBatch(templateExtractItemDocTypeRelevancyPoList);
    }

    private TemplateRuleLibItemRelevancyPo getTemplateRuleLibItemRelevancy(RuleItemObject ruleItemObject) {
        long templateId = ruleItemObject.getTemplateId();
        long ruleLibId = ruleItemObject.getRuleLibId();
        long ruleItemId = ruleItemObject.getRuleItemId();
        TemplateRuleLibItemRelevancyPo po = new TemplateRuleLibItemRelevancyPo();
        po.setTemplateId(templateId);
        po.setRuleLibId(ruleLibId);
        po.setRuleItemId(ruleItemId);
        po.setEnabled(ruleItemObject.getEnabled().intValue());
        po.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
        return po;
    }

    private TemplateRuleLibRelevancyPo getTemplateRuleLibRelevancyPo(RuleItemObject ruleItemObject) {
        TemplateRuleLibRelevancyPo templateRuleLibRelevancyPo = new TemplateRuleLibRelevancyPo();
        templateRuleLibRelevancyPo.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
        templateRuleLibRelevancyPo.setTemplateId(ruleItemObject.getTemplateId());
        templateRuleLibRelevancyPo.setRuleLibId(ruleItemObject.getRuleLibId());
        return templateRuleLibRelevancyPo;
    }

    private void addTemplateRuleExtractRelevancyPo(List<TemplateRuleExtractRelevancyPo> templateRuleExtractRelevancyPoListAll, List<TemplateRuleExtractRelevancyPo> templateRuleExtractRelevancyPoList, long templateId, long extractItemId, long ruleItemId, long ruleLibId) {
        if (templateRuleExtractRelevancyPoListAll.stream().noneMatch(relevancyPo -> relevancyPo.getTemplateId() == templateId && relevancyPo.getRuleItemId() == ruleItemId && relevancyPo.getExtractItemId() == extractItemId)) {
            TemplateRuleExtractRelevancyPo po = new TemplateRuleExtractRelevancyPo();
            po.setExtractItemId(extractItemId);
            po.setRuleItemId(ruleItemId);
            po.setTemplateId(templateId);
            po.setRuleLibId(ruleLibId);
            po.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
            templateRuleExtractRelevancyPoList.add(po);
        }
    }

    private void addTemplateExtractDocRelevancyPo(List<TemplateExtractItemDocTypeRelevancyPo> templateExtractItemDocTypeRelevancyPoListAll, List<TemplateExtractItemDocTypeRelevancyPo> templateExtractItemDocTypeRelevancyPoList, long templateId, long ruleItemId, long extractItemId, long docTypeId, long ruleLibId) {
        if (templateExtractItemDocTypeRelevancyPoListAll.stream().noneMatch(relevancyPo -> relevancyPo.getTemplateId() == templateId && relevancyPo.getRuleItemId() == ruleItemId && relevancyPo.getExtractItemId() == extractItemId && relevancyPo.getDocTypeId() == docTypeId)) {
            TemplateExtractItemDocTypeRelevancyPo po = new TemplateExtractItemDocTypeRelevancyPo();
            po.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
            po.setTemplateId(templateId);
            po.setRuleItemId(ruleItemId);
            po.setExtractItemId(extractItemId);
            po.setDocTypeId(docTypeId);
            po.setRuleLibId(ruleLibId);
            templateExtractItemDocTypeRelevancyPoList.add(po);
        }
    }

    @Override
    public List<RuleItemObject> queryTemplateConfigInfoList(Long templateId, Long[] ruleIdList) {
        ArrayList<RuleItemObject> ruleItemObjectList = new ArrayList<RuleItemObject>();
        RuleItemQueryVo itemQueryVo = new RuleItemQueryVo();
        itemQueryVo.setSize(999);
        itemQueryVo.setCurrent(1);
        itemQueryVo.setEnabled(Integer.valueOf(1));
        itemQueryVo.setRuleLibIds(ruleIdList);
        Page ruleItemVoPage = this.ruleService.queryRuleItem(itemQueryVo);
        ArrayList<DocTypeVo> docTypeVoList = new ArrayList<DocTypeVo>();
        ArrayList<Long> docTypeIdList = new ArrayList<Long>();
        SceneTemplatePo sceneTemplatePo = (SceneTemplatePo)this.sceneTemplateMapper.selectById(templateId);
        DocTypeVo docTypeVo = this.docTypeService.queryDocTypeById(Long.valueOf(sceneTemplatePo.getDocTypeId()));
        if (ObjectUtil.isNotNull((Object)docTypeVo)) {
            docTypeVoList.add(docTypeVo);
            docTypeIdList.add(docTypeVo.getId());
        }
        List<TemplateRuleExtractRelevancyPo> templateRuleExtractRelevancyPoList = this.templateRuleExtractRelevancyService.findAllByTemplateId(templateId);
        List<TemplateRuleLibItemRelevancyPo> templateRuleLibItemRelevancyPoList = this.templateRuleLibItemRelevancyService.findAllByTemplateId(templateId);
        for (RuleItemVo ruleItemVo : ruleItemVoPage.getRecords()) {
            RuleItemObject ruleItemObject = new RuleItemObject(ruleItemVo);
            ruleItemObject.setTemplateId(templateId.longValue());
            Optional<TemplateRuleLibItemRelevancyPo> sceneRuleReviewItemRelevancyPoOptional = templateRuleLibItemRelevancyPoList.stream().filter(po -> po.getRuleLibId() == ruleItemVo.getRuleLibId().longValue() && po.getRuleItemId() == ruleItemVo.getId().longValue()).findFirst();
            sceneRuleReviewItemRelevancyPoOptional.ifPresent(sceneRuleReviewItemRelevancyPo -> ruleItemObject.setEnabled(Integer.valueOf(sceneRuleReviewItemRelevancyPo.getEnabled())));
            ArrayList<ExtractItemObject> extractItemList = new ArrayList<ExtractItemObject>();
            List sceneRuleExtractRelevancyPoList = templateRuleExtractRelevancyPoList.parallelStream().filter(po -> po.getTemplateId() == templateId.longValue() && po.getRuleItemId() == ruleItemVo.getId().longValue()).collect(Collectors.toList());
            for (TemplateRuleExtractRelevancyPo po2 : sceneRuleExtractRelevancyPoList) {
                ExtractItem extractItem = this.extractCoreService.findById(po2.getExtractItemId());
                if (extractItem == null) continue;
                ExtractItemObject extractItemObject = new ExtractItemObject(extractItem);
                extractItemObject.setDocTypeVoList(docTypeVoList);
                extractItemObject.setDocTypeIdList(docTypeIdList);
                extractItemList.add(extractItemObject);
                ruleItemObject.setExtractItemList(extractItemList);
            }
            ruleItemObjectList.add(ruleItemObject);
        }
        return ruleItemObjectList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void sceneSaveAsTemplate(SceneConfigResultDto configResult) {
        long sceneId = configResult.getSceneId();
        List<SceneTemplatePo> sceneTemplates = this.sceneTemplateMapper.findAllBySceneId(sceneId);
        List<Long> templateIdList = sceneTemplates.stream().map(SceneTemplatePo::getId).collect(Collectors.toList());
        this.templateRuleLibRelevancyService.deleteByTemplateId(templateIdList);
        this.templateRuleLibItemRelevancyService.deleteByTemplateId(templateIdList);
        this.templateRuleExtractRelevancyService.deleteByTemplateId(templateIdList);
        this.templateExtractItemDocTypeRelevancyService.deleteByTemplateId(templateIdList);
        this.sceneTemplateMapper.deleteBySceneId(sceneId);
        ArrayList<SceneTemplatePo> sceneTemplatePoList = new ArrayList<SceneTemplatePo>();
        ArrayList<TemplateRuleLibRelevancyPo> templateRuleLibRelevancyPoList = new ArrayList<TemplateRuleLibRelevancyPo>();
        for (SceneConfigResult result : configResult.getConfigResultList()) {
            for (Long ruleLibId : result.getRuleLibIdList()) {
                this.addSceneTemplatePo(sceneId, sceneTemplatePoList, result, ruleLibId, templateRuleLibRelevancyPoList);
            }
        }
        this.saveBatch(sceneTemplatePoList);
        this.templateRuleLibRelevancyService.saveBatch(templateRuleLibRelevancyPoList);
    }

    private void transformRuleItemAndExtractItemData(long sceneId, long templateId, long ruleLibId, long docTypeId) {
        ArrayList<TemplateRuleLibItemRelevancyPo> templateRuleLibItemRelevancyPoList = new ArrayList<TemplateRuleLibItemRelevancyPo>();
        ArrayList<TemplateRuleExtractRelevancyPo> templateRuleExtractRelevancyPoList = new ArrayList<TemplateRuleExtractRelevancyPo>();
        ArrayList<TemplateExtractItemDocTypeRelevancyPo> templateExtractItemDocTypeRelevancyPoList = new ArrayList<TemplateExtractItemDocTypeRelevancyPo>();
        List<SceneRuleReviewItemRelevancyPo> sceneRuleReviewItemRelevancyPoList = this.sceneRuleReviewItemRelevancyService.findAllBySceneId(sceneId);
        List<SceneRuleExtractRelevancyPo> sceneRuleExtractRelevancyPoList = this.sceneRuleExtractRelevancyService.findAllBySceneId(sceneId);
        List<SceneExtractItemDocTypeRelevancyPo> sceneExtractItemDocTypeRelevancyPoList = this.sceneExtractItemDocTypeRelevancyService.findAllBySceneId(sceneId);
        for (SceneRuleReviewItemRelevancyPo ruleItem : sceneRuleReviewItemRelevancyPoList) {
            TemplateRuleLibItemRelevancyPo ruleLibItemRelevancyPo = new TemplateRuleLibItemRelevancyPo();
            ruleLibItemRelevancyPo.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
            ruleLibItemRelevancyPo.setTemplateId(templateId);
            ruleLibItemRelevancyPo.setRuleLibId(ruleItem.getRuleLibId());
            ruleLibItemRelevancyPo.setRuleItemId(ruleItem.getRuleItemId());
            ruleLibItemRelevancyPo.setEnabled(ruleItem.getEnabled());
            templateRuleLibItemRelevancyPoList.add(ruleLibItemRelevancyPo);
        }
        for (SceneRuleExtractRelevancyPo ruleExtract : sceneRuleExtractRelevancyPoList) {
            TemplateRuleExtractRelevancyPo ruleExtractRelevancyPo = new TemplateRuleExtractRelevancyPo();
            ruleExtractRelevancyPo.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
            ruleExtractRelevancyPo.setRuleLibId(ruleLibId);
            ruleExtractRelevancyPo.setTemplateId(templateId);
            ruleExtractRelevancyPo.setRuleItemId(ruleExtract.getRuleItemId());
            ruleExtractRelevancyPo.setExtractItemId(ruleExtract.getExtractItemId());
            templateRuleExtractRelevancyPoList.add(ruleExtractRelevancyPo);
        }
        for (SceneExtractItemDocTypeRelevancyPo extractItemDocType : sceneExtractItemDocTypeRelevancyPoList) {
            TemplateExtractItemDocTypeRelevancyPo extractItemDocTypeRelevancyPo = new TemplateExtractItemDocTypeRelevancyPo();
            extractItemDocTypeRelevancyPo.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
            extractItemDocTypeRelevancyPo.setTemplateId(templateId);
            extractItemDocTypeRelevancyPo.setRuleLibId(ruleLibId);
            extractItemDocTypeRelevancyPo.setRuleItemId(extractItemDocType.getRuleItemId());
            extractItemDocTypeRelevancyPo.setExtractItemId(extractItemDocType.getExtractItemId());
            if (extractItemDocType.getDocTypeId() != docTypeId) {
                log.error("\u573a\u666f\u4e2d\u7684docTypeId\u4e0e\u6a21\u677f\u4e2d\u7684docTypeId\u4e0d\u540c\uff0cscene docTypeId:{}, template docTypeId:{}", (Object)docTypeId, (Object)extractItemDocType.getDocTypeId());
            }
            extractItemDocTypeRelevancyPo.setDocTypeId(docTypeId);
            templateExtractItemDocTypeRelevancyPoList.add(extractItemDocTypeRelevancyPo);
        }
        this.templateRuleLibItemRelevancyService.saveBatch(templateRuleLibItemRelevancyPoList);
        this.templateRuleExtractRelevancyService.saveBatch(templateRuleExtractRelevancyPoList);
        this.templateExtractItemDocTypeRelevancyService.saveBatch(templateExtractItemDocTypeRelevancyPoList);
    }

    private void addTemplateRuleLibRelevancyPo(long templateId, long ruleLibId, List<TemplateRuleLibRelevancyPo> templateRuleLibRelevancyPoList) {
        TemplateRuleLibRelevancyPo relevancyPo = new TemplateRuleLibRelevancyPo();
        relevancyPo.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
        relevancyPo.setTemplateId(templateId);
        relevancyPo.setRuleLibId(ruleLibId);
        templateRuleLibRelevancyPoList.add(relevancyPo);
    }

    private void addSceneTemplatePo(long sceneId, List<SceneTemplatePo> sceneTemplatePoList, SceneConfigResult configResult, long ruleLibId, List<TemplateRuleLibRelevancyPo> templateRuleLibRelevancyPoList) {
        if (sceneTemplatePoList.stream().noneMatch(item -> item.getDocTypeId() == configResult.getDocTypeId())) {
            SceneTemplatePo templatePo = new SceneTemplatePo();
            long templateId = SnowFlakeUtil.getFlowIdInstance().nextId();
            templatePo.setId(templateId);
            templatePo.setSceneId(sceneId);
            templatePo.setDocTypeId(configResult.getDocTypeId());
            templatePo.setTemplateName(configResult.getTemplateName());
            sceneTemplatePoList.add(templatePo);
            this.addTemplateRuleLibRelevancyPo(templateId, ruleLibId, templateRuleLibRelevancyPoList);
            this.transformRuleItemAndExtractItemData(sceneId, templateId, ruleLibId, configResult.getDocTypeId());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void templateSaveAsScene(long sceneId, List<Long> templateIdList) {
        List<SceneTemplateRelevancyPo> sceneTemplateRelevancyPoListExist2;
        List templateIdListAll;
        List<Long> deleteTemplateIdList;
        List<SceneTemplateRelevancyPo> sceneTemplateRelevancyPoListExist = this.sceneTemplateRelevancyService.findAllBySceneId(sceneId);
        List templateIdListRelevancyExist = sceneTemplateRelevancyPoListExist.stream().map(SceneTemplateRelevancyPo::getTemplateId).collect(Collectors.toList());
        List<Long> templateIds = templateIdList.stream().filter(item -> !templateIdListRelevancyExist.contains(item)).collect(Collectors.toList());
        if (ObjectUtil.isNotEmpty(templateIds)) {
            ArrayList sceneTemplateRelevancyPoList = new ArrayList();
            templateIds.forEach(tid -> {
                SceneTemplateRelevancyPo po = new SceneTemplateRelevancyPo();
                po.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
                po.setTemplateId(tid.longValue());
                po.setSceneId(sceneId);
                sceneTemplateRelevancyPoList.add(po);
            });
            this.sceneTemplateRelevancyService.saveBatch(sceneTemplateRelevancyPoList);
        }
        if (ObjectUtil.isNotEmpty(templateIds)) {
            List<SceneTemplatePo> sceneTemplatePoList = this.sceneTemplateMapper.findAllByTemplateId(templateIds);
            List<Long> docTypeIdList = sceneTemplatePoList.stream().map(SceneTemplatePo::getDocTypeId).collect(Collectors.toList());
            List<TemplateRuleLibRelevancyPo> templateRuleLibRelevancyPoList = this.templateRuleLibRelevancyService.findAllByTemplateId(templateIds);
            List<TemplateRuleLibItemRelevancyPo> templateRuleLibItemRelevancyPoList = this.templateRuleLibItemRelevancyService.findAllByTemplateId(templateIds);
            List<TemplateRuleExtractRelevancyPo> templateRuleExtractRelevancyPoList = this.templateRuleExtractRelevancyService.findAllByTemplateId(templateIds);
            List<TemplateExtractItemDocTypeRelevancyPo> templateExtractItemDocTypeRelevancyPoList = this.templateExtractItemDocTypeRelevancyService.findAllByTemplateId(templateIds);
            List<SceneDocTypeRelevancyPo> sceneDocTypeRelevancyPoList = this.getSceneDocTypeRelevancyPo(sceneId, sceneTemplatePoList);
            List<SceneRuleLibRelevancyPo> sceneRuleLibRelevancyPoList = this.getSceneRuleLibRelevancyPo(sceneId, templateRuleLibRelevancyPoList);
            List<SceneRuleReviewItemRelevancyPo> sceneRuleReviewItemRelevancyPoList = this.getSceneRuleReviewItemRelevancyPo(sceneId, templateRuleLibItemRelevancyPoList);
            List<SceneRuleExtractRelevancyPo> sceneRuleExtractRelevancyPoList = this.getSceneRuleExtractRelevancyPo(sceneId, templateRuleExtractRelevancyPoList);
            List<SceneExtractItemDocTypeRelevancyPo> sceneExtractItemDocTypeRelevancyPoList = this.getRuleExtractDocTypeRelevancyPo(sceneId, templateExtractItemDocTypeRelevancyPoList);
            List<SceneRuleItemDocTypeRelevancyPo> sceneRuleItemDocTypeRelevancyPoList = this.getSceneRuleItemDocTypeRelevancyPo(sceneId, templateRuleLibItemRelevancyPoList, docTypeIdList);
            this.sceneDocTypeRelevancyService.saveBatch(sceneDocTypeRelevancyPoList);
            this.sceneRuleLibRelevancyService.saveBatch(sceneRuleLibRelevancyPoList);
            this.sceneRuleReviewItemRelevancyService.saveBatch(sceneRuleReviewItemRelevancyPoList);
            this.sceneRuleExtractRelevancyService.saveBatch(sceneRuleExtractRelevancyPoList);
            this.sceneExtractItemDocTypeRelevancyService.saveBatch(sceneExtractItemDocTypeRelevancyPoList);
            this.sceneRuleItemDocTypeRelevancyService.saveBatch(sceneRuleItemDocTypeRelevancyPoList);
        }
        if (ObjectUtil.isNotEmpty(deleteTemplateIdList = (templateIdListAll = (sceneTemplateRelevancyPoListExist2 = this.sceneTemplateRelevancyService.findAllBySceneId(sceneId)).stream().map(SceneTemplateRelevancyPo::getTemplateId).collect(Collectors.toList())).stream().filter(id -> !templateIdList.contains(id)).collect(Collectors.toList()))) {
            this.sceneDocTypeRelevancyService.delete(sceneId, deleteTemplateIdList);
            this.sceneRuleLibRelevancyService.delete(sceneId, deleteTemplateIdList);
            this.sceneRuleReviewItemRelevancyService.delete(sceneId, deleteTemplateIdList);
            this.sceneRuleExtractRelevancyService.delete(sceneId, deleteTemplateIdList);
            this.sceneExtractItemDocTypeRelevancyService.delete(sceneId, deleteTemplateIdList);
            this.sceneRuleItemDocTypeRelevancyService.delete(sceneId, deleteTemplateIdList);
            this.sceneTemplateRelevancyService.deleteBySceneIdAndTemplateId(sceneId, deleteTemplateIdList);
        }
    }

    private List<SceneRuleItemDocTypeRelevancyPo> getSceneRuleItemDocTypeRelevancyPo(long sceneId, List<TemplateRuleLibItemRelevancyPo> templateRuleLibItemRelevancyPoList, List<Long> docTypeIdList) {
        ArrayList<SceneRuleItemDocTypeRelevancyPo> sceneRuleItemDocTypeRelevancyPoList = new ArrayList<SceneRuleItemDocTypeRelevancyPo>();
        for (TemplateRuleLibItemRelevancyPo relevancyPo : templateRuleLibItemRelevancyPoList) {
            for (Long docTypeId : docTypeIdList) {
                SceneRuleItemDocTypeRelevancyPo po = new SceneRuleItemDocTypeRelevancyPo();
                po.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
                po.setSceneId(sceneId);
                po.setRuleItemId(relevancyPo.getRuleItemId());
                po.setDocTypeId(docTypeId.longValue());
                po.setTemplateId(relevancyPo.getTemplateId());
                sceneRuleItemDocTypeRelevancyPoList.add(po);
            }
        }
        return sceneRuleItemDocTypeRelevancyPoList;
    }

    private List<SceneExtractItemDocTypeRelevancyPo> getRuleExtractDocTypeRelevancyPo(long sceneId, List<TemplateExtractItemDocTypeRelevancyPo> templateExtractItemDocTypeRelevancyPoList) {
        ArrayList<SceneExtractItemDocTypeRelevancyPo> sceneExtractItemDocTypeRelevancyPoList = new ArrayList<SceneExtractItemDocTypeRelevancyPo>();
        for (TemplateExtractItemDocTypeRelevancyPo relevancyPo : templateExtractItemDocTypeRelevancyPoList) {
            SceneExtractItemDocTypeRelevancyPo po = new SceneExtractItemDocTypeRelevancyPo();
            po.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
            po.setSceneId(sceneId);
            po.setRuleItemId(relevancyPo.getRuleItemId());
            po.setExtractItemId(relevancyPo.getExtractItemId());
            po.setDocTypeId(relevancyPo.getDocTypeId());
            po.setTemplateId(relevancyPo.getTemplateId());
            sceneExtractItemDocTypeRelevancyPoList.add(po);
        }
        return sceneExtractItemDocTypeRelevancyPoList;
    }

    private List<SceneRuleExtractRelevancyPo> getSceneRuleExtractRelevancyPo(long sceneId, List<TemplateRuleExtractRelevancyPo> templateRuleExtractRelevancyPoList) {
        ArrayList<SceneRuleExtractRelevancyPo> sceneRuleExtractRelevancyPoList = new ArrayList<SceneRuleExtractRelevancyPo>();
        for (TemplateRuleExtractRelevancyPo relevancyPo : templateRuleExtractRelevancyPoList) {
            SceneRuleExtractRelevancyPo po = new SceneRuleExtractRelevancyPo();
            po.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
            po.setSceneId(sceneId);
            po.setRuleItemId(relevancyPo.getRuleItemId());
            po.setExtractItemId(relevancyPo.getExtractItemId());
            po.setTemplateId(relevancyPo.getTemplateId());
            sceneRuleExtractRelevancyPoList.add(po);
        }
        return sceneRuleExtractRelevancyPoList;
    }

    private List<SceneDocTypeRelevancyPo> getSceneDocTypeRelevancyPo(long sceneId, List<SceneTemplatePo> sceneTemplatePoList) {
        ArrayList<SceneDocTypeRelevancyPo> sceneDocTypeRelevancyPoList = new ArrayList<SceneDocTypeRelevancyPo>();
        for (SceneTemplatePo sceneTemplatePo : sceneTemplatePoList) {
            SceneDocTypeRelevancyPo sceneDocTypeRelevancyPo = new SceneDocTypeRelevancyPo();
            sceneDocTypeRelevancyPo.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
            sceneDocTypeRelevancyPo.setSceneId(sceneId);
            sceneDocTypeRelevancyPo.setTemplateId(sceneTemplatePo.getId());
            sceneDocTypeRelevancyPo.setDocTypeId(sceneTemplatePo.getDocTypeId());
            sceneDocTypeRelevancyPoList.add(sceneDocTypeRelevancyPo);
        }
        return sceneDocTypeRelevancyPoList;
    }

    private List<SceneRuleLibRelevancyPo> getSceneRuleLibRelevancyPo(long sceneId, List<TemplateRuleLibRelevancyPo> templateRuleLibRelevancyPoList) {
        ArrayList<SceneRuleLibRelevancyPo> sceneRuleLibRelevancyPoList = new ArrayList<SceneRuleLibRelevancyPo>();
        for (TemplateRuleLibRelevancyPo relevancyPo : templateRuleLibRelevancyPoList) {
            SceneRuleLibRelevancyPo ruleLibRelevancyPo = new SceneRuleLibRelevancyPo();
            ruleLibRelevancyPo.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
            ruleLibRelevancyPo.setSceneId(sceneId);
            ruleLibRelevancyPo.setTemplateId(relevancyPo.getTemplateId());
            ruleLibRelevancyPo.setRuleLibId(relevancyPo.getRuleLibId());
            sceneRuleLibRelevancyPoList.add(ruleLibRelevancyPo);
        }
        return sceneRuleLibRelevancyPoList;
    }

    private List<SceneRuleReviewItemRelevancyPo> getSceneRuleReviewItemRelevancyPo(long sceneId, List<TemplateRuleLibItemRelevancyPo> templateRuleLibItemRelevancyPoList) {
        ArrayList<SceneRuleReviewItemRelevancyPo> sceneRuleReviewItemRelevancyPoList = new ArrayList<SceneRuleReviewItemRelevancyPo>();
        for (TemplateRuleLibItemRelevancyPo ruleLibItemRelevancyPo : templateRuleLibItemRelevancyPoList) {
            SceneRuleReviewItemRelevancyPo po = new SceneRuleReviewItemRelevancyPo();
            po.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
            po.setSceneId(sceneId);
            po.setTemplateId(ruleLibItemRelevancyPo.getTemplateId());
            po.setRuleLibId(ruleLibItemRelevancyPo.getRuleLibId());
            po.setRuleItemId(ruleLibItemRelevancyPo.getRuleItemId());
            po.setEnabled(ruleLibItemRelevancyPo.getEnabled());
            sceneRuleReviewItemRelevancyPoList.add(po);
        }
        return sceneRuleReviewItemRelevancyPoList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBySceneId(long sceneId) {
        List<SceneTemplatePo> sceneTemplatePoList = this.sceneTemplateMapper.findAllBySceneId(sceneId);
        List<Long> templateIdList = sceneTemplatePoList.stream().map(SceneTemplatePo::getId).collect(Collectors.toList());
        if (ObjectUtil.isNotEmpty(templateIdList)) {
            this.sceneTemplateRelevancyService.deleteByTemplateId(templateIdList);
            this.templateRuleLibRelevancyService.deleteByTemplateId(templateIdList);
            this.templateRuleLibItemRelevancyService.deleteByTemplateId(templateIdList);
            this.templateExtractItemDocTypeRelevancyService.deleteByTemplateId(templateIdList);
            this.templateRuleExtractRelevancyService.deleteByTemplateId(templateIdList);
            this.sceneTemplateMapper.deleteByTemplateId(templateIdList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByTemplateId(long templateId) {
        this.sceneTemplateRelevancyService.deleteByTemplateId(Collections.singletonList(templateId));
        this.templateRuleLibRelevancyService.deleteByTemplateId(Collections.singletonList(templateId));
        this.templateRuleLibItemRelevancyService.deleteByTemplateId(Collections.singletonList(templateId));
        this.templateExtractItemDocTypeRelevancyService.deleteByTemplateId(Collections.singletonList(templateId));
        this.templateRuleExtractRelevancyService.deleteByTemplateId(Collections.singletonList(templateId));
        this.sceneTemplateMapper.deleteByTemplateId(Collections.singletonList(templateId));
    }
}

