/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.scene.server.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.scene.api.po.SceneRuleReviewItemRelevancyPo;
import com.jxdinfo.idp.scene.server.mapper.SceneRuleReviewItemRelevancyMapper;
import com.jxdinfo.idp.scene.server.service.SceneRuleReviewItemRelevancyService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SceneRuleReviewItemRelevancyServiceImpl
extends ServiceImpl<SceneRuleReviewItemRelevancyMapper, SceneRuleReviewItemRelevancyPo>
implements SceneRuleReviewItemRelevancyService {
    private static final Logger log = LoggerFactory.getLogger(SceneRuleReviewItemRelevancyServiceImpl.class);
    @Resource
    private SceneRuleReviewItemRelevancyMapper sceneRuleReviewItemRelevancyMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(SceneRuleReviewItemRelevancyPo obj) {
        obj.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
        this.sceneRuleReviewItemRelevancyMapper.insert(obj);
    }

    @Override
    public List<SceneRuleReviewItemRelevancyPo> findAllBySceneId(long sceneId) {
        return this.sceneRuleReviewItemRelevancyMapper.findAllBySceneId(sceneId);
    }

    @Override
    public List<SceneRuleReviewItemRelevancyPo> findAllByRuleLibId(long ruleLibId) {
        return this.sceneRuleReviewItemRelevancyMapper.findAllByRuleLibId(ruleLibId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(long sceneId) {
        this.sceneRuleReviewItemRelevancyMapper.deleteBySceneId(sceneId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(long sceneId, List<Long> templateIdList) {
        if (ObjectUtil.isNotEmpty(templateIdList)) {
            this.sceneRuleReviewItemRelevancyMapper.deleteBySceneIdAndTemplateId(sceneId, templateIdList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(long sceneId, long ruleLibId, List<Long> ruleItemIdList) {
        if (ObjectUtil.isNotEmpty(ruleItemIdList)) {
            this.sceneRuleReviewItemRelevancyMapper.delete(sceneId, ruleLibId, ruleItemIdList);
        }
    }
}

