/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.scene.server.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.scene.api.po.SceneRuleExtractRelevancyPo;
import com.jxdinfo.idp.scene.server.mapper.SceneRuleExtractRelevancyMapper;
import com.jxdinfo.idp.scene.server.service.SceneRuleExtractRelevancyService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SceneRuleExtractRelevancyServiceImpl
extends ServiceImpl<SceneRuleExtractRelevancyMapper, SceneRuleExtractRelevancyPo>
implements SceneRuleExtractRelevancyService {
    private static final Logger log = LoggerFactory.getLogger(SceneRuleExtractRelevancyServiceImpl.class);
    @Resource
    private SceneRuleExtractRelevancyMapper sceneRuleExtractRelevancyMapper;

    @Override
    public List<SceneRuleExtractRelevancyPo> findAllBySceneId(long sceneId) {
        return this.sceneRuleExtractRelevancyMapper.findAllBySceneId(sceneId);
    }

    @Override
    public List<SceneRuleExtractRelevancyPo> findBySceneIdAndRuleItemId(long sceneId, long ruleItemId) {
        return this.sceneRuleExtractRelevancyMapper.findBySceneIdAndRuleItemId(sceneId, ruleItemId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(long sceneId) {
        this.sceneRuleExtractRelevancyMapper.deleteBySceneId(sceneId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(long sceneId, long ruleItemId, List<Long> extractIdList) {
        if (ObjectUtil.isNotEmpty(extractIdList)) {
            this.sceneRuleExtractRelevancyMapper.delete(sceneId, ruleItemId, extractIdList);
        }
    }

    @Override
    public void delete(long sceneId, List<Long> templateIdList) {
        if (ObjectUtil.isNotEmpty(templateIdList)) {
            this.sceneRuleExtractRelevancyMapper.deleteBySceneIdAndTemplateId(sceneId, templateIdList);
        }
    }
}

