/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.scene.server.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.dm.server.service.impl.DocTypeServiceImpl;
import com.jxdinfo.idp.scene.api.po.SceneDocTypeRelevancyPo;
import com.jxdinfo.idp.scene.server.mapper.SceneDocTypeRelevancyMapper;
import com.jxdinfo.idp.scene.server.service.SceneDocTypeRelevancyService;
import com.jxdinfo.idp.vo.DocTypeVo;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SceneDocTypeRelevancyServiceImpl
extends ServiceImpl<SceneDocTypeRelevancyMapper, SceneDocTypeRelevancyPo>
implements SceneDocTypeRelevancyService {
    @Autowired
    private DocTypeServiceImpl docTypeService;
    @Autowired
    private SceneDocTypeRelevancyMapper sceneDocTypeRelevancyMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void insertOrUpdate(Long sceneId, List<Long> docTypeIdList) {
        if (ObjectUtil.isNull(docTypeIdList) || docTypeIdList.isEmpty()) {
            return;
        }
        List<SceneDocTypeRelevancyPo> sceneDocTypeRelevancyPoList = this.findBySceneId(sceneId);
        for (SceneDocTypeRelevancyPo po : sceneDocTypeRelevancyPoList) {
            if (docTypeIdList.contains(po.getDocTypeId())) continue;
            ((SceneDocTypeRelevancyMapper)this.baseMapper).deleteById(Long.valueOf(po.getId()));
        }
        List docTypeIds = sceneDocTypeRelevancyPoList.stream().map(SceneDocTypeRelevancyPo::getDocTypeId).collect(Collectors.toList());
        for (Long docTypeId : docTypeIdList) {
            if (docTypeIds.contains(docTypeId)) continue;
            SceneDocTypeRelevancyPo entity = new SceneDocTypeRelevancyPo();
            entity.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
            entity.setDocTypeId(docTypeId.longValue());
            entity.setSceneId(sceneId.longValue());
            this.save(entity);
        }
    }

    @Override
    public List<SceneDocTypeRelevancyPo> findBySceneId(long sceneId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"scene_id", (Object)sceneId);
        return ((SceneDocTypeRelevancyMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<DocTypeVo> getDocTypeObjectList(long sceneId) {
        List<SceneDocTypeRelevancyPo> sceneDocTypeRelevancyPoList = this.findBySceneId(sceneId);
        ArrayList<DocTypeVo> docTypeVoList = new ArrayList<DocTypeVo>();
        List docTypeVos = this.docTypeService.getDocTypeList();
        for (SceneDocTypeRelevancyPo po : sceneDocTypeRelevancyPoList) {
            Optional<DocTypeVo> docTypeVoOptional = docTypeVos.stream().filter(doc -> doc.getId().longValue() == po.getDocTypeId()).findFirst();
            docTypeVoOptional.ifPresent(docTypeVoList::add);
        }
        return docTypeVoList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBySceneIdAndDocTypeId(long sceneId, List<Long> docTypeIdList) {
        if (ObjectUtil.isNotEmpty(docTypeIdList)) {
            this.sceneDocTypeRelevancyMapper.deleteBySceneIdAndDocTypeIdList(sceneId, docTypeIdList);
        }
    }

    @Override
    public void delete(long sceneId, List<Long> templateIdList) {
        if (ObjectUtil.isNotEmpty(templateIdList)) {
            this.sceneDocTypeRelevancyMapper.delete(sceneId, templateIdList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByTemplateId(long sceneId, List<Long> templateIdList) {
        if (ObjectUtil.isNotEmpty(templateIdList)) {
            this.sceneDocTypeRelevancyMapper.delete(sceneId, templateIdList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBySceneId(long sceneId) {
        this.sceneDocTypeRelevancyMapper.deleteBySceneId(sceneId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByDocTypeId(long docTypeId) {
        this.sceneDocTypeRelevancyMapper.deleteByDocTypeId(docTypeId);
    }

    @Override
    public List<SceneDocTypeRelevancyPo> findByDocTypeId(long docTypeId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"doc_type_id", (Object)docTypeId);
        return ((SceneDocTypeRelevancyMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }
}

