/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unify.authentication.server.controller;

import com.jxdinfo.hussar.platform.core.BooleanUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.unify.authentication.core.dto.CheckTokenDTO;
import com.jxdinfo.hussar.unify.authentication.core.dto.RefreshTokenDTO;
import com.jxdinfo.hussar.unify.authentication.core.entity.HussarCasUserInfo;
import com.jxdinfo.hussar.unify.authentication.core.vo.AutoRefreshConfigVO;
import com.jxdinfo.hussar.unify.authentication.core.vo.CheckTokenVO;
import com.jxdinfo.hussar.unify.authentication.server.properties.AuthenticationServerProperties;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/token"})
public class OauthTokenController {
    private static Logger logger = LoggerFactory.getLogger(OauthTokenController.class);
    @Resource
    private AuthenticationServerProperties properties;
    @Resource
    private RedisTemplate<String, Object> redisTemplate;

    @GetMapping(value={"/refresh/getAutoConfig"})
    public ApiResponse<AutoRefreshConfigVO> getAutoConfig() {
        AutoRefreshConfigVO configVO = new AutoRefreshConfigVO();
        configVO.setEnableAutoRefresh(this.properties.getEnableAutoRefresh());
        configVO.setRefreshTokenThreshold(this.properties.getRefreshTokenThreshold());
        return ApiResponse.success((Object)configVO);
    }

    @PostMapping(value={"/refresh"})
    public ApiResponse<HussarCasUserInfo> refresh(@RequestBody RefreshTokenDTO refreshTokenDTO) {
        if (refreshTokenDTO.getAutoRefresh().booleanValue() && !BooleanUtil.isTrue((Boolean)this.properties.getEnableAutoRefresh())) {
            return ApiResponse.fail((String)"token\u81ea\u52a8\u5237\u65b0\u7eed\u671f\u5931\u8d25\uff0c\u670d\u52a1\u7aef\u81ea\u52a8\u5237\u65b0\u7eed\u671f\u672a\u5f00\u542f");
        }
        if (HussarUtils.isEmpty((Object)refreshTokenDTO.getToken())) {
            return ApiResponse.fail((String)"token\u7eed\u671f\u5931\u8d25\uff0c\u5f85\u7eed\u671ftoken\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String key = "hussar_uas_user::" + refreshTokenDTO.getToken();
        if (!this.redisTemplate.hasKey((Object)key).booleanValue()) {
            return ApiResponse.fail((String)"token\u7eed\u671f\u5931\u8d25\uff0c\u5f85\u7eed\u671ftoken\u4e0d\u5408\u6cd5");
        }
        String jsonStr = (String)this.redisTemplate.opsForValue().get((Object)key);
        HussarCasUserInfo casUserInfo = (HussarCasUserInfo)JsonUtil.parse((String)jsonStr, HussarCasUserInfo.class);
        if (casUserInfo.getExpireTime() == -1L) {
            return ApiResponse.fail((String)"token\u4e3a\u6c38\u4e0d\u8fc7\u671f\uff0c\u65e0\u9700\u8fdb\u884c\u7eed\u671f");
        }
        if (refreshTokenDTO.getAutoRefresh().booleanValue() && casUserInfo.getExpireTime() - System.currentTimeMillis() > (long)(this.properties.getRefreshTokenThreshold() * 1000)) {
            return ApiResponse.fail((String)"token\u81ea\u52a8\u5237\u65b0\u7eed\u671f\u5931\u8d25\uff0ctoken\u5269\u4f59\u6709\u6548\u65f6\u95f4\u5927\u4e8e\u53ef\u5237\u65b0\u65f6\u95f4\u95f4\u9694");
        }
        casUserInfo.setExpireTime(Long.valueOf(System.currentTimeMillis() + (long)(this.properties.getTokenTimeout() * 1000)));
        this.redisTemplate.opsForValue().set((Object)key, (Object)JsonUtil.toJson((Object)casUserInfo), (long)this.properties.getTokenTimeout().intValue(), TimeUnit.SECONDS);
        return ApiResponse.success((Object)casUserInfo);
    }

    @PostMapping(value={"/check"})
    public ApiResponse<CheckTokenVO> check(@RequestBody CheckTokenDTO checkTokenDTO) {
        if (HussarUtils.isEmpty((Object)checkTokenDTO.getToken())) {
            return ApiResponse.fail((String)"token\u6821\u9a8c\u5931\u8d25\uff0ctoken\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String clientUrl = checkTokenDTO.getClientUrl();
        if (HussarUtils.isEmpty((Object)clientUrl)) {
            return ApiResponse.fail((String)"token\u6821\u9a8c\u5931\u8d25\uff0c\u5ba2\u6237\u7aef\u8bf7\u6c42\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String tokenKey = "hussar_uas_user::" + checkTokenDTO.getToken();
        if (!this.redisTemplate.hasKey((Object)tokenKey).booleanValue()) {
            return ApiResponse.success((Object)CheckTokenVO.errorToken());
        }
        String jsonStr = (String)this.redisTemplate.opsForValue().get((Object)tokenKey);
        HussarCasUserInfo userInfo = (HussarCasUserInfo)JsonUtil.parse((String)jsonStr, HussarCasUserInfo.class);
        CheckTokenVO checkTokenVO = CheckTokenVO.correctToken((HussarCasUserInfo)userInfo);
        String tokenToClientKey = "hussar_uas_token_client::" + checkTokenDTO.getToken();
        HashSet<String> clientUrls = this.redisTemplate.hasKey((Object)tokenToClientKey) != false ? (Set)this.redisTemplate.opsForValue().get((Object)tokenToClientKey) : new HashSet<String>();
        clientUrls.add(clientUrl);
        if (userInfo.getExpireTime() > 0L) {
            this.redisTemplate.opsForValue().set((Object)tokenToClientKey, clientUrls, userInfo.getExpireTime() - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        } else {
            this.redisTemplate.opsForValue().set((Object)tokenToClientKey, clientUrls);
        }
        return ApiResponse.success((Object)checkTokenVO);
    }

    @GetMapping(value={"/getUserInfo"})
    public ApiResponse<HussarCasUserInfo> getUserInfo(String token) {
        if (HussarUtils.isEmpty((Object)token)) {
            return ApiResponse.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0ctoken\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String tokenKey = "hussar_uas_user::" + token;
        String jsonStr = (String)this.redisTemplate.opsForValue().get((Object)tokenKey);
        return HussarUtils.isEmpty((Object)jsonStr) ? ApiResponse.success() : ApiResponse.success((Object)JsonUtil.parse((String)jsonStr, HussarCasUserInfo.class));
    }
}

