/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unify.authentication.server.controller;

import com.google.code.kaptcha.Producer;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.platform.core.annotation.Inner;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.unify.authentication.core.enums.AliyunPhoneMessage;
import com.jxdinfo.hussar.unify.authentication.core.enums.ExceptionCodeEnum;
import com.jxdinfo.hussar.unify.authentication.server.controller.dto.EmailCaptchaDTO;
import com.jxdinfo.hussar.unify.authentication.server.controller.dto.PhoneCaptchaDTO;
import com.jxdinfo.hussar.unify.authentication.server.controller.dto.PhoneMsgDetail;
import com.jxdinfo.hussar.unify.authentication.server.properties.AuthenticationServerProperties;
import com.jxdinfo.hussar.unify.authentication.server.properties.aliyun.AliyunPhoneMessageProperties;
import com.jxdinfo.hussar.unify.authentication.server.service.PhoneMessageService;
import com.jxdinfo.hussar.unify.authentication.server.utils.RegexUtils;
import com.jxdinfo.hussar.unify.authentication.server.utils.SendMailUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CaptchaController {
    private static Logger logger = LoggerFactory.getLogger(CaptchaController.class);
    private static final Random RANDOM = new Random();
    @Resource
    private PhoneMessageService phoneCaptchaService;
    @Resource
    private AliyunPhoneMessageProperties aliyunProperties;
    @Resource
    private AuthenticationServerProperties properties;
    @Resource
    private Producer producer;
    @Resource
    private RedisTemplate<String, Object> redisTemplate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/captcha"})
    @Inner
    public ApiResponse index(HttpServletRequest request, HttpServletResponse response) {
        response.setDateHeader("Expires", 0L);
        response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        response.setHeader("Pragma", "no-cache");
        response.setContentType("image/jpeg");
        String capText = this.producer.createText();
        String captchaUniqueTag = request.getParameter("captchaUniqueTag");
        if (StringUtils.isBlank((CharSequence)captchaUniqueTag)) {
            return ApiResponse.fail((int)ExceptionCodeEnum.PICTURE_CAPTCHA_ERROR.getCode(), (String)ExceptionCodeEnum.PICTURE_CAPTCHA_ERROR.getMessage());
        }
        Long seconds = (long)this.properties.getCaptchaExpire().intValue() * 60L;
        this.redisTemplate.opsForValue().set((Object)("hussar_uas_picture_captcha::" + captchaUniqueTag), (Object)capText, seconds.longValue(), TimeUnit.SECONDS);
        BufferedImage bi = this.producer.createImage(capText);
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        try {
            ImageIO.write((RenderedImage)bi, "jpg", (OutputStream)out);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        try {
            try {
                if (out != null) {
                    out.flush();
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
        }
        return ApiResponse.success();
    }

    @PostMapping(value={"/phone/captcha"})
    public ApiResponse sendPhoneCaptcha(@RequestBody PhoneCaptchaDTO phoneCaptchaDTO) {
        if (HussarUtils.isEmpty((Object)phoneCaptchaDTO.getPhone())) {
            return ApiResponse.fail((int)ExceptionCodeEnum.PHONE_IS_NULL.getCode(), (String)ExceptionCodeEnum.PHONE_IS_NULL.getMessage());
        }
        if (!RegexUtils.phoneCheck((String)phoneCaptchaDTO.getPhone())) {
            return ApiResponse.fail((int)ExceptionCodeEnum.PHONE_REGEX_ERROR.getCode(), (String)ExceptionCodeEnum.PHONE_REGEX_ERROR.getMessage());
        }
        String captcha = String.valueOf(RANDOM.nextInt(900000) + 100000);
        HashMap<String, String> messageParams = new HashMap<String, String>();
        messageParams.put("content", captcha);
        messageParams.put("title", "\u9ed8\u8ba4\u6807\u9898");
        PhoneMsgDetail msgDetail = new PhoneMsgDetail((List)Lists.newArrayList((Object[])new String[]{phoneCaptchaDTO.getPhone()}), messageParams, AliyunPhoneMessage.LOGIN_CAPTCHA.getTemplateSignName(), AliyunPhoneMessage.LOGIN_CAPTCHA.getTemplateCode());
        boolean result = this.phoneCaptchaService.send(msgDetail);
        if (result) {
            Long seconds = (long)this.properties.getPhoneCaptchaExpire().intValue() * 60L;
            this.redisTemplate.opsForValue().set((Object)("hussar_uas_phone_captcha::" + phoneCaptchaDTO.getPhone()), (Object)captcha, seconds.longValue(), TimeUnit.SECONDS);
        }
        return result ? ApiResponse.success() : ApiResponse.fail((String)"\u767b\u5f55\u9a8c\u8bc1\u7801\u53d1\u9001\u5931\u8d25");
    }

    @PostMapping(value={"/email/captcha"})
    public ApiResponse sendEmailCaptcha(@RequestBody EmailCaptchaDTO emailCaptchaDTO) {
        if (HussarUtils.isEmpty((Object)emailCaptchaDTO.getEmail())) {
            return ApiResponse.fail((int)ExceptionCodeEnum.EMAIL_IS_NULL.getCode(), (String)ExceptionCodeEnum.EMAIL_IS_NULL.getMessage());
        }
        if (!RegexUtils.emailCheck((String)emailCaptchaDTO.getEmail())) {
            return ApiResponse.fail((int)ExceptionCodeEnum.EMAIL_REGEX_ERROR.getCode(), (String)ExceptionCodeEnum.EMAIL_REGEX_ERROR.getMessage());
        }
        String captcha = String.valueOf(RANDOM.nextInt(900000) + 100000);
        String content = String.format(this.properties.getEmailCaptchaMessage(), captcha, this.properties.getEmailCaptchaExpire());
        Long seconds = (long)this.properties.getEmailCaptchaExpire().intValue() * 60L;
        this.redisTemplate.opsForValue().set((Object)("hussar_uas_email_captcha::" + emailCaptchaDTO.getEmail()), (Object)captcha, seconds.longValue(), TimeUnit.SECONDS);
        SendMailUtils.send(Arrays.asList(emailCaptchaDTO.getEmail()), (String)"\u767b\u5f55\u90ae\u7bb1\u9a8c\u8bc1\u7801", (String)content, (boolean)true, (File[])new File[0]);
        return ApiResponse.success();
    }
}

