/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.validation;

import java.io.Serializable;
import java.util.List;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.validation.Assertion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutableAssertion
implements Assertion,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmutableAssertion.class);
    private static final long serialVersionUID = -3348826049921010423L;
    private final Authentication primaryAuthentication;
    private final List<Authentication> chainedAuthentications;
    private final boolean fromNewLogin;
    private final Service service;

    public String toString() {
        return "ImmutableAssertion(primaryAuthentication=" + this.primaryAuthentication + ", chainedAuthentications=" + this.chainedAuthentications + ", fromNewLogin=" + this.fromNewLogin + ", service=" + this.service + ")";
    }

    public ImmutableAssertion(Authentication primaryAuthentication, List<Authentication> chainedAuthentications, boolean fromNewLogin, Service service) {
        if (primaryAuthentication == null) {
            throw new NullPointerException("primaryAuthentication is marked @NonNull but is null");
        }
        if (chainedAuthentications == null) {
            throw new NullPointerException("chainedAuthentications is marked @NonNull but is null");
        }
        if (service == null) {
            throw new NullPointerException("service is marked @NonNull but is null");
        }
        this.primaryAuthentication = primaryAuthentication;
        this.chainedAuthentications = chainedAuthentications;
        this.fromNewLogin = fromNewLogin;
        this.service = service;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImmutableAssertion)) {
            return false;
        }
        ImmutableAssertion other = (ImmutableAssertion)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Authentication this$primaryAuthentication = this.primaryAuthentication;
        Authentication other$primaryAuthentication = other.primaryAuthentication;
        if (this$primaryAuthentication == null ? other$primaryAuthentication != null : !this$primaryAuthentication.equals(other$primaryAuthentication)) {
            return false;
        }
        List this$chainedAuthentications = this.chainedAuthentications;
        List other$chainedAuthentications = other.chainedAuthentications;
        if (this$chainedAuthentications == null ? other$chainedAuthentications != null : !((Object)this$chainedAuthentications).equals(other$chainedAuthentications)) {
            return false;
        }
        if (this.fromNewLogin != other.fromNewLogin) {
            return false;
        }
        Service this$service = this.service;
        Service other$service = other.service;
        return !(this$service == null ? other$service != null : !this$service.equals(other$service));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImmutableAssertion;
    }

    public int hashCode() {
        boolean PRIME = true;
        int result = 1;
        Authentication $primaryAuthentication = this.primaryAuthentication;
        result = result * 59 + ($primaryAuthentication == null ? 43 : $primaryAuthentication.hashCode());
        List $chainedAuthentications = this.chainedAuthentications;
        result = result * 59 + ($chainedAuthentications == null ? 43 : ((Object)$chainedAuthentications).hashCode());
        result = result * 59 + (this.fromNewLogin ? 79 : 97);
        Service $service = this.service;
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        return result;
    }

    public Authentication getPrimaryAuthentication() {
        return this.primaryAuthentication;
    }

    public List<Authentication> getChainedAuthentications() {
        return this.chainedAuthentications;
    }

    public boolean isFromNewLogin() {
        return this.fromNewLogin;
    }

    public Service getService() {
        return this.service;
    }
}

