/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unify.authentication.server.utils;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.unify.authentication.core.enums.AuthProtocolType;
import com.jxdinfo.hussar.unify.authentication.server.utils.UasCacheUtils;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UasServerOperateUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(UasServerOperateUtil.class);
    private static final OkHttpClient client = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();
    private static ExecutorService executorService = Executors.newFixedThreadPool(10);

    public static void notifyClientLogout(String token) {
        Set clientUrls;
        if (HussarUtils.isNotEmpty((Object)token) && HussarUtils.isNotEmpty((Object)(clientUrls = UasCacheUtils.getClientUrls((String)token)))) {
            clientUrls.forEach(clientUrl -> executorService.execute(() -> {
                try {
                    Request request = new Request.Builder().url(clientUrl).addHeader("hussar-unify-token", token).addHeader("unify-auth-type", AuthProtocolType.OAUTH2.getName()).addHeader("uasLogoutRequest", Boolean.TRUE.toString()).post(RequestBody.create(null, (String)"")).build();
                    client.newCall(request).execute();
                }
                catch (Exception e) {
                    LOGGER.error("\u901a\u77e5\u5ba2\u6237\u7aef\u767b\u51fa\u5f02\u5e38, clientUrl = {}, token = {}", new Object[]{clientUrl, token, e});
                }
            }));
            UasCacheUtils.deleteClientUrls((String)token);
        }
    }
}

