/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unify.authentication.server.utils;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.PrincipalException;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.services.UnauthorizedServiceForPrincipalException;
import org.apereo.cas.services.UnauthorizedSsoServiceException;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class HussarRegisteredServiceAccessStrategyUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HussarRegisteredServiceAccessStrategyUtils.class);

    public static void ensureServiceAccessIsAllowed(RegisteredService registeredService) {
        HussarRegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((String)(registeredService != null ? registeredService.getName() : ""), (RegisteredService)registeredService);
    }

    public static void ensureServiceAccessIsAllowed(String service, RegisteredService registeredService) {
        if (registeredService == null) {
            String msg = String.format("Unauthorized Service Access. Service [%s] is not found in service registry.", service);
            LOGGER.warn(msg);
            throw new UnauthorizedServiceException("screen.service.error.message", msg);
        }
        if (!registeredService.getAccessStrategy().isServiceAccessAllowed()) {
            String msg = String.format("Unauthorized Service Access. Service [%s] is not enabled in service registry.", service);
            LOGGER.warn(msg);
            throw new UnauthorizedServiceException("screen.service.error.message", msg);
        }
    }

    public static void ensureServiceAccessIsAllowed(Service service, RegisteredService registeredService) {
        HussarRegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((String)service.getId(), (RegisteredService)registeredService);
    }

    static void ensurePrincipalAccessIsAllowedForService(Service service, RegisteredService registeredService, String principalId, Map<String, Object> attributes) {
        HussarRegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)service, (RegisteredService)registeredService);
        if (!registeredService.getAccessStrategy().doPrincipalAttributesAllowServiceAccess(principalId, attributes)) {
            LOGGER.warn("Cannot grant access to service [{}] because it is not authorized for use by [{}].", (Object)service.getId(), (Object)principalId);
            HashMap<String, UnauthorizedServiceForPrincipalException> handlerErrors = new HashMap<String, UnauthorizedServiceForPrincipalException>();
            String message = String.format("Cannot grant service access to %s", principalId);
            UnauthorizedServiceForPrincipalException exception = new UnauthorizedServiceForPrincipalException(message, registeredService, principalId, attributes);
            handlerErrors.put(UnauthorizedServiceForPrincipalException.class.getSimpleName(), exception);
            throw new PrincipalException("screen.service.error.message", handlerErrors, new HashMap());
        }
    }

    static void ensurePrincipalAccessIsAllowedForService(Service service, RegisteredService registeredService, Authentication authentication) {
        HussarRegisteredServiceAccessStrategyUtils.ensurePrincipalAccessIsAllowedForService((Service)service, (RegisteredService)registeredService, (Authentication)authentication, (boolean)true);
    }

    static void ensurePrincipalAccessIsAllowedForService(Service service, RegisteredService registeredService, Authentication authentication, boolean retrievePrincipalAttributesFromReleasePolicy) throws UnauthorizedServiceException, PrincipalException {
        HussarRegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)service, (RegisteredService)registeredService);
        Principal principal = authentication.getPrincipal();
        Map principalAttrs = retrievePrincipalAttributesFromReleasePolicy && registeredService != null && registeredService.getAttributeReleasePolicy() != null ? registeredService.getAttributeReleasePolicy().getAttributes(principal, service, registeredService) : authentication.getPrincipal().getAttributes();
        LinkedHashMap attributes = new LinkedHashMap(principalAttrs);
        attributes.putAll(authentication.getAttributes());
        HussarRegisteredServiceAccessStrategyUtils.ensurePrincipalAccessIsAllowedForService((Service)service, (RegisteredService)registeredService, (String)principal.getId(), attributes);
    }

    static void ensurePrincipalAccessIsAllowedForService(ServiceTicket serviceTicket, RegisteredService registeredService, TicketGrantingTicket ticketGrantingTicket, boolean retrievePrincipalAttributesFromReleasePolicy) throws UnauthorizedServiceException, PrincipalException {
        HussarRegisteredServiceAccessStrategyUtils.ensurePrincipalAccessIsAllowedForService((Service)serviceTicket.getService(), (RegisteredService)registeredService, (Authentication)ticketGrantingTicket.getAuthentication(), (boolean)retrievePrincipalAttributesFromReleasePolicy);
    }

    static void ensurePrincipalAccessIsAllowedForService(Service service, RegisteredService registeredService, TicketGrantingTicket ticketGrantingTicket, boolean retrievePrincipalAttributesFromReleasePolicy) throws UnauthorizedServiceException, PrincipalException {
        HussarRegisteredServiceAccessStrategyUtils.ensurePrincipalAccessIsAllowedForService((Service)service, (RegisteredService)registeredService, (Authentication)ticketGrantingTicket.getRoot().getAuthentication(), (boolean)retrievePrincipalAttributesFromReleasePolicy);
    }

    static void ensurePrincipalAccessIsAllowedForService(ServiceTicket serviceTicket, AuthenticationResult context, RegisteredService registeredService) throws UnauthorizedServiceException, PrincipalException {
        HussarRegisteredServiceAccessStrategyUtils.ensurePrincipalAccessIsAllowedForService((Service)serviceTicket.getService(), (RegisteredService)registeredService, (Authentication)context.getAuthentication());
    }

    public static void ensureServiceSsoAccessIsAllowed(RegisteredService registeredService, Service service, TicketGrantingTicket ticketGrantingTicket) {
        HussarRegisteredServiceAccessStrategyUtils.ensureServiceSsoAccessIsAllowed((RegisteredService)registeredService, (Service)service, (TicketGrantingTicket)ticketGrantingTicket, (boolean)false);
    }

    public static void ensureServiceSsoAccessIsAllowed(RegisteredService registeredService, Service service, TicketGrantingTicket ticketGrantingTicket, boolean credentialsProvided) {
        if (!registeredService.getAccessStrategy().isServiceAccessAllowedForSso()) {
            LOGGER.debug("Service [{}] is configured to not use SSO", (Object)service.getId());
            if (ticketGrantingTicket.getProxiedBy() != null) {
                LOGGER.warn("Service [{}] is not allowed to use SSO for proxying.", (Object)service.getId());
                throw new UnauthorizedSsoServiceException();
            }
            if (ticketGrantingTicket.getProxiedBy() == null && ticketGrantingTicket.getCountOfUses() > 0 && !credentialsProvided) {
                LOGGER.warn("Service [{}] is not allowed to use SSO. The ticket-granting ticket [{}] is not proxied and it's been used at least once. The authentication request must provide credentials before access can be granted", (Object)ticketGrantingTicket.getId(), (Object)service.getId());
                throw new UnauthorizedSsoServiceException();
            }
        }
        LOGGER.debug("Current authentication via ticket [{}] allows service [{}] to participate in the existing SSO session", (Object)ticketGrantingTicket.getId(), (Object)service.getId());
    }

    private HussarRegisteredServiceAccessStrategyUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

