/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unify.authentication.server.properties;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="hussar.uas")
public class AuthenticationServerProperties {
    public static final String PREFIX = "hussar.uas";
    private String authenticationTypes = "1";
    private Integer maxSameAccountRule = 2;
    private String adminIds;
    private Integer captchaExpire = 3;
    private Integer phoneCaptchaExpire = 5;
    private String phoneMessageType = "default";
    private String selectUserByPhoneSql = "SELECT * FROM SYS_USERS WHERE MOBILE=?";
    private Integer emailCaptchaExpire = 3;
    private String emailCaptchaMessage = "\u9a8c\u8bc1\u7801\uff1a%s\uff0c%s\u5206\u949f\u5185\u6709\u6548\uff0c\u8bf7\u52ff\u6cc4\u9732";
    private String selectUserByEmailSql = "SELECT * FROM SYS_USERS WHERE E_MAIL=?";
    private Integer tokenTimeout = 1800;
    private Boolean enableAutoRefresh = true;
    private Integer refreshTokenThreshold = 600;
    private String iamUrl;
    private List<Long> adminIdList;

    public Integer getMaxSameAccountRule() {
        return this.maxSameAccountRule;
    }

    public void setMaxSameAccountRule(Integer maxSameAccountRule) {
        this.maxSameAccountRule = maxSameAccountRule;
    }

    public List<Long> getAdminIdList() {
        if (this.adminIdList == null) {
            this.adminIdList = HussarUtils.isNotEmpty((Object)this.adminIds) ? Arrays.stream(this.adminIds.split(",")).map(Long::valueOf).collect(Collectors.toList()) : new ArrayList();
        }
        return this.adminIdList;
    }

    public void setAdminIds(String adminIds) {
        this.adminIds = adminIds;
    }

    public String getAuthenticationTypes() {
        return this.authenticationTypes;
    }

    public void setAuthenticationTypes(String authenticationTypes) {
        this.authenticationTypes = authenticationTypes;
    }

    public Integer getCaptchaExpire() {
        return this.captchaExpire;
    }

    public void setCaptchaExpire(Integer captchaExpire) {
        this.captchaExpire = captchaExpire;
    }

    public Integer getPhoneCaptchaExpire() {
        return this.phoneCaptchaExpire;
    }

    public void setPhoneCaptchaExpire(Integer phoneCaptchaExpire) {
        this.phoneCaptchaExpire = phoneCaptchaExpire;
    }

    public String getPhoneMessageType() {
        return this.phoneMessageType;
    }

    public void setPhoneMessageType(String phoneMessageType) {
        this.phoneMessageType = phoneMessageType;
    }

    public String getSelectUserByPhoneSql() {
        return this.selectUserByPhoneSql;
    }

    public void setSelectUserByPhoneSql(String selectUserByPhoneSql) {
        this.selectUserByPhoneSql = selectUserByPhoneSql;
    }

    public Integer getEmailCaptchaExpire() {
        return this.emailCaptchaExpire;
    }

    public void setEmailCaptchaExpire(Integer emailCaptchaExpire) {
        this.emailCaptchaExpire = emailCaptchaExpire;
    }

    public String getEmailCaptchaMessage() {
        return this.emailCaptchaMessage;
    }

    public void setEmailCaptchaMessage(String emailCaptchaMessage) {
        this.emailCaptchaMessage = emailCaptchaMessage;
    }

    public String getSelectUserByEmailSql() {
        return this.selectUserByEmailSql;
    }

    public void setSelectUserByEmailSql(String selectUserByEmailSql) {
        this.selectUserByEmailSql = selectUserByEmailSql;
    }

    public Integer getTokenTimeout() {
        return this.tokenTimeout;
    }

    public void setTokenTimeout(Integer tokenTimeout) {
        this.tokenTimeout = tokenTimeout;
    }

    public Boolean getEnableAutoRefresh() {
        return this.enableAutoRefresh;
    }

    public void setEnableAutoRefresh(Boolean enableAutoRefresh) {
        this.enableAutoRefresh = enableAutoRefresh;
    }

    public Integer getRefreshTokenThreshold() {
        return this.refreshTokenThreshold;
    }

    public void setRefreshTokenThreshold(Integer refreshTokenThreshold) {
        this.refreshTokenThreshold = refreshTokenThreshold;
    }

    public String getIamUrl() {
        return this.iamUrl;
    }

    public void setIamUrl(String iamUrl) {
        this.iamUrl = iamUrl;
    }
}

