/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unify.authentication.server.lock.impl;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.unify.authentication.server.lock.LoginLock;
import com.jxdinfo.hussar.unify.authentication.server.lock.SecureErr;
import com.jxdinfo.hussar.unify.authentication.server.lock.UserLockModel;
import com.jxdinfo.hussar.unify.authentication.server.utils.UasParseUtils;
import java.time.LocalDateTime;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class RedisLoginLock
implements LoginLock {
    private static final String LOGIN_LOCK = "hussar_cas_login_lock::";
    @Resource
    private RedisTemplate<String, Object> redisTemplate;

    public boolean userIsLock(String tenantCode, String userId) {
        return this.userLockState(this.parseCacheKey(tenantCode, userId));
    }

    private boolean userLockState(String key) {
        boolean flag = false;
        UserLockModel model = (UserLockModel)JsonUtil.parse((String)String.valueOf(this.redisTemplate.opsForValue().get((Object)(LOGIN_LOCK + key))), UserLockModel.class);
        if (HussarUtils.isNotEmpty((Object)model) && HussarUtils.isNotEmpty((Object)model.getExpireTime()) && model.getExpireTime().compareTo(LocalDateTime.now()) > 0) {
            flag = true;
        }
        return flag;
    }

    public int userLockNum(String tenantCode, String userId) {
        int num = 0;
        UserLockModel model = (UserLockModel)JsonUtil.parse((String)String.valueOf(this.redisTemplate.opsForValue().get((Object)(LOGIN_LOCK + this.parseCacheKey(tenantCode, userId)))), UserLockModel.class);
        if (HussarUtils.isNotEmpty((Object)model)) {
            num = model.getFailNum();
        }
        return num;
    }

    public void removeUserCache(String tenantCode, String userId) {
        this.redisTemplate.delete((Object)(LOGIN_LOCK + this.parseCacheKey(tenantCode, userId)));
    }

    public void addUserCache(String tenantCode, String userId, String userName, int maxFailLoginTimes, int continuousMinutes, int failLockMinutes) {
        this.addNewUserCache(this.parseCacheKey(tenantCode, userId), userId, userName, maxFailLoginTimes, continuousMinutes, failLockMinutes);
    }

    private void addNewUserCache(String key, String userId, String userName, int maxFailLoginTimes, int continuousMinutes, int failLockMinutes) {
        UserLockModel model = (UserLockModel)JsonUtil.parse((String)String.valueOf(this.redisTemplate.opsForValue().get((Object)(LOGIN_LOCK + key))), UserLockModel.class);
        SecureErr errMode = new SecureErr();
        errMode.setInputTime(LocalDateTime.now());
        errMode.setExpireTime(errMode.getInputTime().plusMinutes(failLockMinutes));
        if (HussarUtils.isNotEmpty((Object)model)) {
            model.setUserName(userName);
            List historyPwdErr = model.getSecureErrList();
            for (SecureErr err : historyPwdErr) {
                if (err.getExpireTime().compareTo(LocalDateTime.now()) > 0) continue;
                historyPwdErr.remove(err);
            }
            historyPwdErr.add(errMode);
            model.setFailNum(historyPwdErr.size());
            model.setSecureErrList(historyPwdErr);
        } else {
            model = new UserLockModel();
            model.setUserId(userId);
            model.setUserName(userName);
            model.getSecureErrList().add(errMode);
            model.setFailNum(1);
        }
        this.lockOrContinue(model, maxFailLoginTimes, failLockMinutes, continuousMinutes * 60, key);
    }

    private void lockOrContinue(UserLockModel lockModel, int maxFailLoginTimes, int failLockMinutes, int seconds, String key) {
        if (lockModel.getFailNum() >= maxFailLoginTimes) {
            lockModel.setLockTime(LocalDateTime.now());
            lockModel.setExpireTime(lockModel.getLockTime().plusMinutes(failLockMinutes));
            this.redisTemplate.opsForValue().set((Object)(LOGIN_LOCK + key), (Object)JsonUtil.toJson((Object)lockModel), (long)(failLockMinutes * 60), TimeUnit.SECONDS);
        } else {
            this.redisTemplate.opsForValue().set((Object)(LOGIN_LOCK + key), (Object)JsonUtil.toJson((Object)lockModel), (long)seconds, TimeUnit.SECONDS);
        }
    }

    private String parseCacheKey(String tenantCode, String userId) {
        tenantCode = UasParseUtils.parseTenantCode((String)tenantCode);
        return tenantCode + "@" + userId;
    }
}

