/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unify.authentication.server.config;

import com.aliyun.dysmsapi20170525.Client;
import com.aliyun.teaopenapi.models.Config;
import com.jxdinfo.hussar.unify.authentication.server.properties.aliyun.AliyunPhoneMessageProperties;
import com.jxdinfo.hussar.unify.authentication.server.service.PhoneMessageService;
import com.jxdinfo.hussar.unify.authentication.server.service.impl.AliyunPhoneMessageService;
import com.jxdinfo.hussar.unify.authentication.server.service.impl.DefaultPhoneMessageService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(value={"com.jxdinfo.hussar.unify.authentication.server"})
public class AuthenticationServerConfig {
    @Bean
    @ConditionalOnProperty(prefix="hussar.uas", name={"phone-message-type"}, havingValue="default", matchIfMissing=true)
    public PhoneMessageService defaultPhoneMessageService() {
        return new DefaultPhoneMessageService();
    }

    @Bean
    @ConditionalOnProperty(prefix="hussar.uas", name={"phone-message-type"}, havingValue="aliyun")
    public PhoneMessageService aliyunPhoneMessageService() {
        return new AliyunPhoneMessageService();
    }

    @Bean
    @ConditionalOnProperty(prefix="hussar.uas", name={"phone-message-type"}, havingValue="aliyun")
    public Client aliyunClient(AliyunPhoneMessageProperties properties) throws Exception {
        Config config = new Config().setAccessKeyId(properties.getAccessKeyId()).setAccessKeySecret(properties.getAccessKeySecret());
        config.endpoint = "dysmsapi.aliyuncs.com";
        return new Client(config);
    }
}

