/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.handler.support;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.unify.authentication.core.enums.AuthenticationType;
import com.jxdinfo.hussar.unify.authentication.server.exception.CaptchaErrorException;
import com.jxdinfo.hussar.unify.authentication.server.exception.CaptchaExpireException;
import com.jxdinfo.hussar.unify.authentication.server.exception.PhoneCaptchaErrorException;
import com.jxdinfo.hussar.unify.authentication.server.exception.PhoneCaptchaExpireException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.AuthenticationPasswordPolicyHandlingStrategy;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.authentication.handler.PrincipalNameTransformer;
import org.apereo.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.support.password.PasswordPolicyConfiguration;
import org.apereo.cas.services.ServicesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.security.crypto.password.NoOpPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

public abstract class AbstractUsernamePasswordAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractUsernamePasswordAuthenticationHandler.class);
    private RedisTemplate<String, Object> redisTemplate;
    protected AuthenticationPasswordPolicyHandlingStrategy passwordPolicyHandlingStrategy = (o, o2) -> new ArrayList(0);
    private PasswordEncoder passwordEncoder = NoOpPasswordEncoder.getInstance();
    private PrincipalNameTransformer principalNameTransformer = formUserId -> formUserId;
    private PasswordPolicyConfiguration passwordPolicyConfiguration;

    public AbstractUsernamePasswordAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, Integer order) {
        super(name, servicesManager, principalFactory, order);
    }

    protected AuthenticationHandlerExecutionResult doAuthentication(Credential credential) throws GeneralSecurityException, PreventedException {
        UsernamePasswordCredential originalUserPass = (UsernamePasswordCredential)credential;
        if (HussarUtils.isEmpty((Object)originalUserPass.getAuthenticationTypeCode())) {
            originalUserPass.setAuthenticationTypeCode(AuthenticationType.DEFAULT.getCode());
        }
        if (this.redisTemplate == null) {
            this.redisTemplate = (RedisTemplate)SpringContextUtil.getBean(RedisTemplate.class);
        }
        if (AuthenticationType.MOBILE_VERIFICATION_CODE.getCode().equals(originalUserPass.getAuthenticationTypeCode())) {
            if (StringUtils.isBlank((CharSequence)originalUserPass.getPhoneNumber())) {
                throw new FailedLoginException("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u624b\u673a\u53f7");
            }
            if (StringUtils.isBlank((CharSequence)originalUserPass.getPhoneCaptcha())) {
                throw new FailedLoginException("\u624b\u673a\u53f7\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u9a8c\u8bc1\u7801");
            }
            String phoneCaptcha = (String)this.redisTemplate.opsForValue().get((Object)("hussar_cas_phone_captcha::" + originalUserPass.getPhoneNumber()));
            if (HussarUtils.isEmpty((Object)phoneCaptcha)) {
                throw new PhoneCaptchaExpireException("\u624b\u673a\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f");
            }
            if (!HussarUtils.equals((Object)phoneCaptcha, (Object)originalUserPass.getPhoneCaptcha())) {
                throw new PhoneCaptchaErrorException("\u9a8c\u8bc1\u7801\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u9a8c\u8bc1\u7801");
            }
            this.redisTemplate.delete((Object)("hussar_cas_phone_captcha::" + originalUserPass.getPhoneNumber()));
            return this.authenticateUsernamePasswordInternal(originalUserPass, null);
        }
        UsernamePasswordCredential userPass = new UsernamePasswordCredential(originalUserPass.getUsername(), originalUserPass.getPassword());
        if (StringUtils.isBlank((CharSequence)userPass.getUsername())) {
            throw new AccountNotFoundException("\u767b\u5f55\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u8d26\u53f7");
        }
        if (StringUtils.isBlank((CharSequence)userPass.getPassword())) {
            throw new FailedLoginException("\u767b\u5f55\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String encodePassword = this.passwordEncoder.encode((CharSequence)userPass.getPassword());
        if (StringUtils.isBlank((CharSequence)encodePassword)) {
            throw new FailedLoginException("\u5bc6\u7801\u7f16\u7801\u5931\u8d25");
        }
        userPass.setPassword(encodePassword);
        userPass.setAuthenticationTypeCode(originalUserPass.getAuthenticationTypeCode());
        userPass.setTenantConnName(originalUserPass.getTenantConnName());
        userPass.setTenantCode(originalUserPass.getTenantCode());
        if (AuthenticationType.CAPTCHA.getCode().equals(originalUserPass.getAuthenticationTypeCode())) {
            if (StringUtils.isBlank((CharSequence)originalUserPass.getCaptcha())) {
                throw new FailedLoginException("\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u9a8c\u8bc1\u7801");
            }
            if (StringUtils.isBlank((CharSequence)originalUserPass.getCaptchaUniqueTag())) {
                throw new CaptchaErrorException("\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5");
            }
            String captcha = (String)this.redisTemplate.opsForValue().get((Object)("hussar_cas_picture_captcha::" + originalUserPass.getCaptchaUniqueTag()));
            if (HussarUtils.isEmpty((Object)captcha)) {
                throw new CaptchaExpireException("\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f");
            }
            if (!HussarUtils.equals((Object)captcha, (Object)originalUserPass.getCaptcha())) {
                throw new CaptchaErrorException("\u9a8c\u8bc1\u7801\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u9a8c\u8bc1\u7801");
            }
            this.redisTemplate.delete((Object)("hussar_cas_picture_captcha::" + originalUserPass.getCaptchaUniqueTag()));
        }
        return this.authenticateUsernamePasswordInternal(userPass, originalUserPass.getPassword());
    }

    protected abstract AuthenticationHandlerExecutionResult authenticateUsernamePasswordInternal(UsernamePasswordCredential var1, String var2) throws GeneralSecurityException, PreventedException;

    public boolean supports(Credential credential) {
        if (!UsernamePasswordCredential.class.isInstance(credential)) {
            LOGGER.debug("Credential is not one of username/password and is not accepted by handler [{}]", (Object)this.getName());
            return false;
        }
        if (this.credentialSelectionPredicate == null) {
            LOGGER.debug("No credential selection criteria is defined for handler [{}]. Credential is accepted for further processing", (Object)this.getName());
            return true;
        }
        LOGGER.debug("Examining credential [{}] eligibility for authentication handler [{}]", (Object)credential, (Object)this.getName());
        boolean result = this.credentialSelectionPredicate.test(credential);
        LOGGER.debug("Credential [{}] eligibility is [{}] for authentication handler [{}]", new Object[]{credential, this.getName(), BooleanUtils.toStringTrueFalse((boolean)result)});
        return result;
    }

    protected boolean matches(CharSequence charSequence, String password) {
        return this.passwordEncoder.matches(charSequence, password);
    }

    public void setPasswordPolicyHandlingStrategy(AuthenticationPasswordPolicyHandlingStrategy passwordPolicyHandlingStrategy) {
        this.passwordPolicyHandlingStrategy = passwordPolicyHandlingStrategy;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public void setPrincipalNameTransformer(PrincipalNameTransformer principalNameTransformer) {
        this.principalNameTransformer = principalNameTransformer;
    }

    public void setPasswordPolicyConfiguration(PasswordPolicyConfiguration passwordPolicyConfiguration) {
        this.passwordPolicyConfiguration = passwordPolicyConfiguration;
    }

    public AuthenticationPasswordPolicyHandlingStrategy getPasswordPolicyHandlingStrategy() {
        return this.passwordPolicyHandlingStrategy;
    }

    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public PrincipalNameTransformer getPrincipalNameTransformer() {
        return this.principalNameTransformer;
    }

    public PasswordPolicyConfiguration getPasswordPolicyConfiguration() {
        return this.passwordPolicyConfiguration;
    }
}

