/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.jdbc;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IpUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.platform.core.utils.id.UUID;
import com.jxdinfo.hussar.unify.authentication.core.dto.HussarCasUserInfo;
import com.jxdinfo.hussar.unify.authentication.core.enums.AccountStatusType;
import com.jxdinfo.hussar.unify.authentication.core.enums.AuthenticationType;
import com.jxdinfo.hussar.unify.authentication.server.exception.AccountStatusException;
import com.jxdinfo.hussar.unify.authentication.server.exception.CreateTenantJdbcTemplateException;
import com.jxdinfo.hussar.unify.authentication.server.exception.LoginAccessTimeException;
import com.jxdinfo.hussar.unify.authentication.server.exception.LoginIpException;
import com.jxdinfo.hussar.unify.authentication.server.exception.MaxSameAccountException;
import com.jxdinfo.hussar.unify.authentication.server.exception.PasswordErrorException;
import com.jxdinfo.hussar.unify.authentication.server.exception.PasswordErrorReachMaxNumException;
import com.jxdinfo.hussar.unify.authentication.server.lock.LoginLock;
import com.jxdinfo.hussar.unify.authentication.server.properties.AuthenticationServerProperties;
import com.jxdinfo.hussar.unify.authentication.server.utils.CollectionUtils;
import com.jxdinfo.hussar.unify.authentication.server.utils.ParseConnNameUtils;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.security.GeneralSecurityException;
import java.sql.Time;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.jdbc.AbstractJdbcUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.services.ServicesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;

public class QueryDatabaseAuthenticationHandler
extends AbstractJdbcUsernamePasswordAuthenticationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryDatabaseAuthenticationHandler.class);
    private final String sql;
    private final String fieldPassword;
    private final String fieldExpired;
    private final String fieldDisabled;
    private final Map<String, Object> principalAttributeMap;
    private static final String TIME_FORMATTER = "HH:mm:ss";
    private static final String MAX_SESSIONS = "max_sessions";
    private static final String LOGIN_TIME_LIMIT = "login_time_limit";
    private static final String ACCESS_LOGIN_START_TIME = "access_login_start_time";
    private static final String ACCESS_LOGIN_END_TIME = "access_login_end_time";
    private static final String LOGIN_IP_LIMIT = "login_ip_limit";
    private static final String USER_ID = "user_id";
    private static final String GET_USER_PERMIT_LOGIN_IP = "SELECT USER_IP FROM SYS_USER_IP WHERE USER_ID=?";
    private static final String ACCOUNT_STATUS = "account_status";
    private static final String USER_NAME = "user_name";
    private static final String USER_ACCOUNT = "user_account";
    private static final String MOBILE = "mobile";
    private static final String GET_BASE_CONFIG = "SELECT CONFIG_VALUE FROM SYS_BASE_CONFIG WHERE CONFIG_KEY =?";
    private static final String GET_USE_BY_MOBILE_PHONE = "SELECT * FROM SYS_USERS WHERE MOBILE=?";
    private static final String MASTER_CONN_NAME = "master";
    private Map<String, JdbcTemplate> jdbcTemplateMap = new HashMap();
    private static final String GET_DATASOURCE = "SELECT * FROM SYS_DATASOURCE WHERE CONN_NAME=?";
    private static final String DRIVER_CLASS = "driver_class";
    private static final String JDBC_URL = "jdbc_url";
    private static final String PASSWORD = "password";
    private RedisTemplate<String, Object> redisTemplate;
    private AuthenticationServerProperties properties;
    private LoginLock loginLock;

    public QueryDatabaseAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, Integer order, DataSource dataSource, String sql, String fieldPassword, String fieldExpired, String fieldDisabled, Map<String, Object> attributes) {
        super(name, servicesManager, principalFactory, order, dataSource);
        this.sql = sql;
        this.fieldPassword = fieldPassword;
        this.fieldExpired = fieldExpired;
        this.fieldDisabled = fieldDisabled;
        this.principalAttributeMap = attributes;
        if (StringUtils.isBlank((CharSequence)this.fieldPassword)) {
            LOGGER.warn("When the password field is left undefined, CAS will skip comparing database and user passwords for equality , (specially if the query results do not contain the password field),and will instead only rely on a successful query execution with returned results in order to verify credentials");
        }
    }

    protected AuthenticationHandlerExecutionResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential, String originalPassword) throws GeneralSecurityException, PreventedException {
        if (!StringUtils.isBlank((CharSequence)this.sql) && this.getJdbcTemplate() != null) {
            HussarCasUserInfo userInfo;
            LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>(this.principalAttributeMap.size());
            String username = credential.getUsername();
            String phoneNumber = credential.getPhoneNumber();
            if (this.redisTemplate == null) {
                this.redisTemplate = (RedisTemplate)SpringContextUtil.getBean(RedisTemplate.class);
            }
            if (this.properties == null) {
                this.properties = (AuthenticationServerProperties)SpringContextUtil.getBean(AuthenticationServerProperties.class);
            }
            Boolean usePhoneNumber = AuthenticationType.MOBILE_VERIFICATION_CODE.getCode().equals(credential.getAuthenticationTypeCode());
            Boolean needCheckMaxSession = false;
            String connName = credential.getTenantConnName();
            try {
                String dbPasswordValue;
                Long userId;
                Map dbFields;
                JdbcTemplate jdbcTemplate = this.getAuthJdbcTemplate(connName);
                switch (credential.getAuthenticationTypeCode()) {
                    case "3": {
                        dbFields = this.query(credential, GET_USE_BY_MOBILE_PHONE, jdbcTemplate, new Object[]{credential.getPhoneNumber()});
                        break;
                    }
                    default: {
                        dbFields = this.query(credential, this.sql, jdbcTemplate, new Object[]{credential.getUsername()});
                    }
                }
                if (HussarUtils.isEmpty((Object)dbFields)) {
                    LOGGER.error("\u8ba4\u8bc1\u5931\u8d25\uff0c{}\u672a\u6ce8\u518c", (Object)(usePhoneNumber != false ? phoneNumber : username));
                    throw new FailedLoginException("\u8ba4\u8bc1\u5931\u8d25\uff0c" + (usePhoneNumber != false ? phoneNumber : username) + "\u672a\u6ce8\u518c");
                }
                if (this.loginLock == null) {
                    this.loginLock = (LoginLock)SpringContextUtil.getBean(LoginLock.class);
                }
                if (this.loginLock.userIsLock(connName, (userId = (Long)dbFields.get(USER_ID)).toString())) {
                    LOGGER.error("{}\u5bc6\u7801\u8f93\u5165\u9519\u8bef\u6b21\u6570\u8d85\u8fc7\u9650\u5236\uff0c\u5e10\u53f7\u5df2\u7981\u6b62\u767b\u5f55\uff01", (Object)(usePhoneNumber != false ? phoneNumber : username));
                    throw new PasswordErrorReachMaxNumException("\u5bc6\u7801\u8f93\u5165\u9519\u8bef\u6b21\u6570\u8d85\u8fc7\u9650\u5236\uff0c\u8d26\u53f7\u5df2\u7981\u6b62\u767b\u5f55\uff01");
                }
                if (!usePhoneNumber.booleanValue() && !this.matches((CharSequence)originalPassword, dbPasswordValue = (String)dbFields.get(this.fieldPassword))) {
                    this.addPasswordErrorInfo(jdbcTemplate, connName, userId.toString(), (String)dbFields.get(USER_NAME));
                    LOGGER.error("\u7528\u6237{}\u767b\u5f55\u5bc6\u7801\u9519\u8bef", (Object)(usePhoneNumber != false ? phoneNumber : username));
                    throw new PasswordErrorException("\u767b\u5f55\u5bc6\u7801\u9519\u8bef");
                }
                if (!HussarUtils.equals((Object)AccountStatusType.ACTIVE.getCode(), dbFields.get(ACCOUNT_STATUS))) {
                    LOGGER.error("\u7528\u6237{}\u8d26\u53f7\u72b6\u6001\u5f02\u5e38", (Object)(usePhoneNumber != false ? phoneNumber : username));
                    throw new AccountStatusException(username + "\u8d26\u53f7\u72b6\u6001\u5f02\u5e38");
                }
                this.checkLoginAccessTime(jdbcTemplate, dbFields);
                this.checkLoginIp(jdbcTemplate, dbFields);
                Integer maxSessions = (Integer)dbFields.get(MAX_SESSIONS);
                if (maxSessions != null && maxSessions > 0) {
                    needCheckMaxSession = true;
                    this.checkMaxSession(connName, maxSessions, (String)dbFields.get(USER_ACCOUNT));
                }
                userInfo = new HussarCasUserInfo((String)dbFields.get(USER_ACCOUNT), (String)dbFields.get(USER_NAME), (String)dbFields.get(MOBILE), connName, credential.getTenantCode());
                this.collectPrincipalAttributes(attributes, dbFields);
            }
            catch (IncorrectResultSizeDataAccessException var9) {
                if (var9.getActualSize() == 0) {
                    LOGGER.error("{}\u5bf9\u5e94\u7684\u8d26\u53f7\u4e0d\u5b58\u5728", (Object)(usePhoneNumber != false ? phoneNumber : username));
                    throw new AccountNotFoundException(username + "\u5bf9\u5e94\u7684\u8d26\u53f7\u4e0d\u5b58\u5728");
                }
                throw new FailedLoginException("Multiple records found for " + username);
            }
            catch (DataAccessException var10) {
                throw new PreventedException("SQL exception while executing query for " + username, (Throwable)var10);
            }
            String token = UUID.fastUUID().toString();
            userInfo.setToken(token);
            Long expireTime = this.properties.getTokenTimeout() < 0 ? -1L : System.currentTimeMillis() + (long)(this.properties.getTokenTimeout() * 1000);
            userInfo.setExpireTime(expireTime);
            if (this.properties.getTokenTimeout() < 0) {
                this.redisTemplate.opsForValue().set((Object)("hussar_cas_user::" + token), (Object)JsonUtil.toJson((Object)userInfo));
            } else {
                this.redisTemplate.opsForValue().set((Object)("hussar_cas_user::" + token), (Object)JsonUtil.toJson((Object)userInfo), (long)this.properties.getTokenTimeout().intValue(), TimeUnit.SECONDS);
            }
            if (needCheckMaxSession.booleanValue()) {
                connName = ParseConnNameUtils.parse((String)connName);
                this.redisTemplate.opsForSet().add((Object)("hussar_cas_user_max_sessions::" + connName + "@" + userInfo.getAccountName()), new Object[]{token});
            }
            attributes.put("hussar_cas_server_token_key", token);
            attributes.put("userName", userInfo.getUserName());
            attributes.put("tenantCode", userInfo.getTenantCode());
            Principal principal = this.principalFactory.createPrincipal(username, attributes);
            return this.createHandlerResult((Credential)credential, principal, new ArrayList(0));
        }
        throw new GeneralSecurityException("Authentication handler is not configured correctly. No SQL statement or JDBC template is found.");
    }

    private JdbcTemplate getAuthJdbcTemplate(String connName) throws CreateTenantJdbcTemplateException {
        try {
            if (HussarUtils.isEmpty((Object)connName) || MASTER_CONN_NAME.equals(connName)) {
                return this.getJdbcTemplate();
            }
            if (this.jdbcTemplateMap.containsKey(connName)) {
                return (JdbcTemplate)this.jdbcTemplateMap.get(connName);
            }
            Map dbFields = this.getJdbcTemplate().queryForMap(GET_DATASOURCE, new Object[]{connName});
            String userName = (String)dbFields.get(USER_NAME);
            String password = (String)dbFields.get(PASSWORD);
            String driverClass = (String)dbFields.get(DRIVER_CLASS);
            String jdbcUrl = (String)dbFields.get(JDBC_URL);
            HikariConfig config = new HikariConfig();
            config.setDriverClassName(driverClass);
            config.setJdbcUrl(jdbcUrl);
            config.setUsername(userName);
            config.setPassword(password);
            HikariDataSource dataSource = new HikariDataSource(config);
            JdbcTemplate jdbcTemplate = new JdbcTemplate((DataSource)dataSource);
            LOGGER.info("\u521b\u5efajdbcTemplate\u6210\u529f\uff0cconnName = {}, jdbcUrl = {}", (Object)connName, (Object)jdbcUrl);
            this.jdbcTemplateMap.put(connName, jdbcTemplate);
            return jdbcTemplate;
        }
        catch (EmptyResultDataAccessException e) {
            LOGGER.error("connName = {} \u5bf9\u5e94\u7684\u6570\u636e\u6e90\u4e0d\u5b58\u5728", (Object)connName);
            throw new CreateTenantJdbcTemplateException("connName = " + connName + "\u5bf9\u5e94\u7684\u6570\u636e\u6e90\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        catch (Exception e) {
            LOGGER.error("\u4f7f\u7528connName = {}\u5bf9\u5e94\u6570\u636e\u6e90\u521b\u5efaJdbcTemplate\u5931\u8d25", (Object)connName, (Object)e);
            throw new CreateTenantJdbcTemplateException("\u4f7f\u7528connName = " + connName + "\u5bf9\u5e94\u6570\u636e\u6e90\u521b\u5efaJdbcTemplate\u5931\u8d25", (Throwable)e);
        }
    }

    private Map<String, Object> query(UsernamePasswordCredential credential, String querySql, JdbcTemplate jdbcTemplate, Object ... args) {
        if (querySql.contains("?")) {
            if (jdbcTemplate == null) {
                jdbcTemplate = this.getJdbcTemplate();
            }
            return jdbcTemplate.queryForMap(querySql, args);
        }
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("username", credential.getUsername());
        parameters.put(PASSWORD, credential.getPassword());
        return this.getNamedJdbcTemplate().queryForMap(this.sql, parameters);
    }

    private void collectPrincipalAttributes(Map<String, Object> attributes, Map<String, Object> dbFields) {
        this.principalAttributeMap.forEach((key, names) -> {
            Object attribute = dbFields.get(key);
            if (attribute != null) {
                LOGGER.debug("Found attribute [{}] from the query results", key);
                Collection attributeNames = (Collection)names;
                attributeNames.forEach(s -> {
                    LOGGER.debug("Principal attribute [{}] is virtually remapped/renamed to [{}]", key, s);
                    attributes.put((String)s, CollectionUtils.wrap((Object)attribute.toString()));
                });
            } else {
                LOGGER.warn("Requested attribute [{}] could not be found in the query results", key);
            }
        });
    }

    private void checkMaxSession(String connName, Integer maxSessions, String userAccount) throws MaxSameAccountException {
        connName = ParseConnNameUtils.parse((String)connName);
        String sameAccountKey = "hussar_cas_user_max_sessions::" + connName + "@" + userAccount;
        Set sameAccountTokenSet = this.redisTemplate.opsForSet().members((Object)sameAccountKey);
        HashSet expireTokenSet = new HashSet();
        for (Object token : sameAccountTokenSet) {
            String redisKey = "hussar_cas_user::" + token;
            if (this.redisTemplate.hasKey((Object)redisKey).booleanValue()) continue;
            expireTokenSet.add(token);
        }
        sameAccountTokenSet.removeAll(expireTokenSet);
        if (expireTokenSet.size() > 0) {
            this.redisTemplate.opsForSet().remove((Object)sameAccountKey, expireTokenSet.toArray());
        }
        if (sameAccountTokenSet.size() >= maxSessions) {
            LOGGER.error("\u8d26\u53f7{}\u5df2\u7ecf\u8d85\u8fc7\u6700\u5927\u53ef\u767b\u5f55\u6570", (Object)userAccount);
            throw new MaxSameAccountException("\u8d26\u53f7\u5df2\u7ecf\u8d85\u8fc7\u6700\u5927\u53ef\u767b\u5f55\u6570");
        }
    }

    private void checkLoginAccessTime(JdbcTemplate jdbcTemplate, Map<String, Object> dbFields) throws LoginAccessTimeException {
        LocalTime now = LocalTime.now();
        if ("1".equals(dbFields.get(LOGIN_TIME_LIMIT))) {
            boolean result;
            Time startTime = (Time)dbFields.get(ACCESS_LOGIN_START_TIME);
            Time endTime = (Time)dbFields.get(ACCESS_LOGIN_END_TIME);
            if (HussarUtils.isEmpty((Object)startTime) || HussarUtils.isEmpty((Object)endTime)) {
                LOGGER.error("\u5f00\u542f\u7528\u6237\u767b\u5f55\u65f6\u95f4\u9650\u5236\u540e\uff0c\u7528\u6237\u53ef\u767b\u5f55\u5f00\u59cb\u3001\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
                throw new LoginAccessTimeException("\u5f00\u542f\u7528\u6237\u767b\u5f55\u65f6\u95f4\u9650\u5236\u540e\uff0c\u7528\u6237\u53ef\u767b\u5f55\u5f00\u59cb\u3001\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            }
            LocalTime loginStart = startTime.toLocalTime();
            LocalTime loginEnd = endTime.toLocalTime();
            boolean bl = result = loginStart.compareTo(now) <= 0 && loginEnd.compareTo(now) >= 0;
            if (!result) {
                LOGGER.error("\u7528\u6237\u5f53\u524d\u65f6\u95f4\u7981\u6b62\u767b\u5f55\uff01");
                throw new LoginAccessTimeException("\u7528\u6237\u5f53\u524d\u65f6\u95f4\u7981\u6b62\u767b\u5f55\uff01");
            }
        } else if ("0".equals(this.getBaseConfigValue(jdbcTemplate, LOGIN_TIME_LIMIT))) {
            boolean result;
            LocalTime loginStart = LocalTime.parse(this.getBaseConfigValue(jdbcTemplate, "login_start_time"), DateTimeFormatter.ofPattern(TIME_FORMATTER));
            LocalTime loginEnd = LocalTime.parse(this.getBaseConfigValue(jdbcTemplate, "login_end_time"), DateTimeFormatter.ofPattern(TIME_FORMATTER));
            boolean bl = result = loginStart.compareTo(now) <= 0 && loginEnd.compareTo(now) >= 0;
            if (!result) {
                LOGGER.error("\u7528\u6237\u5f53\u524d\u65f6\u95f4\u7981\u6b62\u767b\u5f55\uff01");
                throw new LoginAccessTimeException("\u7528\u6237\u5f53\u524d\u65f6\u95f4\u7981\u6b62\u767b\u5f55\uff01");
            }
        }
    }

    private void checkLoginIp(JdbcTemplate jdbcTemplate, Map<String, Object> dbFields) throws LoginIpException {
        String ip = IpUtils.getIp();
        if ("1".equals(dbFields.get(LOGIN_IP_LIMIT))) {
            List allowIps = jdbcTemplate.queryForList(GET_USER_PERMIT_LOGIN_IP, String.class, new Object[]{dbFields.get(USER_ID)});
            allowIps.add("127.0.0.1");
            if (!allowIps.contains(ip)) {
                LOGGER.error("\u5f53\u524dIP\u7981\u6b62\u767b\u5f55\uff01");
                throw new LoginIpException("\u5f53\u524dIP\u7981\u6b62\u767b\u5f55!");
            }
        } else if ("0".equals(this.getBaseConfigValue(jdbcTemplate, LOGIN_IP_LIMIT))) {
            List<String> forbidIpList;
            List<String> allowIpList;
            Boolean flag = false;
            String allowIp = this.getBaseConfigValue(jdbcTemplate, "allow_login_ip");
            String forbidIp = this.getBaseConfigValue(jdbcTemplate, "forbid_login_ip");
            if (HussarUtils.isNotEmpty((Object)allowIp) && ((allowIpList = Arrays.asList(allowIp.split(","))).contains(ip) || "127.0.0.1".equals(ip))) {
                flag = true;
            }
            if (HussarUtils.isNotEmpty((Object)forbidIp) && !flag.booleanValue() && (!(forbidIpList = Arrays.asList(forbidIp.split(","))).contains(ip) || "127.0.0.1".equals(ip))) {
                flag = true;
            }
            if (!flag.booleanValue()) {
                LOGGER.error("\u5f53\u524dIP\u7981\u6b62\u767b\u5f55\uff01");
                throw new LoginIpException("\u5f53\u524dIP\u7981\u6b62\u767b\u5f55!");
            }
        }
    }

    private void addPasswordErrorInfo(JdbcTemplate jdbcTemplate, String connName, String userId, String userName) {
        String failNumber = this.getBaseConfigValue(jdbcTemplate, "fail_number");
        String failLockTime = this.getBaseConfigValue(jdbcTemplate, "fail_lock_time");
        String failTime = this.getBaseConfigValue(jdbcTemplate, "fail_time");
        this.loginLock.addUserCache(connName, userId, userName, Integer.parseInt(failNumber), Integer.parseInt(failTime), Integer.parseInt(failLockTime));
    }

    private String getBaseConfigValue(JdbcTemplate jdbcTemplate, String param) {
        List loginTimeLimit = jdbcTemplate.queryForList(GET_BASE_CONFIG, String.class, new Object[]{param});
        if (HussarUtils.isEmpty((Object)loginTimeLimit)) {
            return "";
        }
        return (String)loginTimeLimit.get(0);
    }
}

