/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.rest.factory;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.unify.authentication.core.enums.AuthenticationType;
import com.jxdinfo.hussar.unify.authentication.server.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.rest.factory.RestHttpRequestCredentialFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;

public class UsernamePasswordRestHttpRequestCredentialFactory
implements RestHttpRequestCredentialFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(UsernamePasswordRestHttpRequestCredentialFactory.class);
    private int order;

    public List<Credential> fromRequest(HttpServletRequest request, MultiValueMap<String, String> requestBody) {
        if (requestBody != null && !requestBody.isEmpty()) {
            String authenticationTypeCode = (String)requestBody.getFirst((Object)"authenticationTypeCode");
            if (HussarUtils.isEmpty((Object)authenticationTypeCode)) {
                authenticationTypeCode = AuthenticationType.DEFAULT.getCode();
            }
            String tenantConnName = (String)requestBody.getFirst((Object)"tenantConnName");
            String tenantCode = (String)requestBody.getFirst((Object)"tenantCode");
            UsernamePasswordCredential credential = null;
            switch (authenticationTypeCode) {
                case "3": {
                    String phoneNumber = (String)requestBody.getFirst((Object)"phoneNumber");
                    String phoneCaptcha = (String)requestBody.getFirst((Object)"phoneCaptcha");
                    if (!HussarUtils.isNotEmpty((Object)phoneCaptcha) || !HussarUtils.isNotEmpty((Object)phoneNumber)) break;
                    credential = new UsernamePasswordCredential(phoneNumber, phoneCaptcha, authenticationTypeCode, tenantConnName, tenantCode);
                    break;
                }
                case "2": {
                    String captchaUniqueTag = (String)requestBody.getFirst((Object)"captchaUniqueTag");
                    String captcha = (String)requestBody.getFirst((Object)"captcha");
                    String username = (String)requestBody.getFirst((Object)"username");
                    String password = (String)requestBody.getFirst((Object)"password");
                    if (!HussarUtils.isNotEmpty((Object)captchaUniqueTag) || !HussarUtils.isNotEmpty((Object)captcha) || !HussarUtils.isNotEmpty((Object)username) || !HussarUtils.isNotEmpty((Object)password)) break;
                    credential = new UsernamePasswordCredential(username, password, captchaUniqueTag, captcha, authenticationTypeCode, tenantConnName, tenantCode);
                    break;
                }
                default: {
                    String username = (String)requestBody.getFirst((Object)"username");
                    String password = (String)requestBody.getFirst((Object)"password");
                    if (!HussarUtils.isNotEmpty((Object)username) || !HussarUtils.isNotEmpty((Object)password)) break;
                    UsernamePasswordCredential usernamePasswordCredential = new UsernamePasswordCredential(username, password);
                    usernamePasswordCredential.setAuthenticationTypeCode(AuthenticationType.DEFAULT.getCode());
                    usernamePasswordCredential.setTenantConnName(tenantConnName);
                    usernamePasswordCredential.setTenantCode(tenantCode);
                    credential = usernamePasswordCredential;
                }
            }
            if (HussarUtils.isNotEmpty(credential)) {
                return CollectionUtils.wrap(credential);
            }
            LOGGER.debug("Invalid payload. param in requestBody is null.");
            return new ArrayList<Credential>(0);
        }
        LOGGER.debug("Skipping {} because the requestBody is null or empty", (Object)this.getClass().getSimpleName());
        return new ArrayList<Credential>(0);
    }

    public int getOrder() {
        return this.order;
    }
}

