/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.rest.factory;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.unify.authentication.core.dto.HussarCasUserInfo;
import com.jxdinfo.hussar.unify.authentication.server.properties.AuthenticationServerProperties;
import java.net.URI;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.rest.factory.TicketGrantingTicketResourceEntityResponseFactory;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.inspektr.audit.annotation.Audit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public class DefaultTicketGrantingTicketResourceEntityResponseFactory
implements TicketGrantingTicketResourceEntityResponseFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTicketGrantingTicketResourceEntityResponseFactory.class);
    private static final String DOCTYPE_AND_TITLE = "<!DOCTYPE HTML PUBLIC \\\"-//IETF//DTD HTML 2.0//EN\\\"><html><head><title>";
    private static final String CLOSE_TITLE_AND_OPEN_FORM = "</title></head><body><h1>TGT Created</h1><form action=\"";
    private static final String TGT_CREATED_TITLE_CONTENT = HttpStatus.CREATED.toString() + ' ' + HttpStatus.CREATED.getReasonPhrase();
    private static final String DOCTYPE_AND_OPENING_FORM = "<!DOCTYPE HTML PUBLIC \\\"-//IETF//DTD HTML 2.0//EN\\\"><html><head><title>" + TGT_CREATED_TITLE_CONTENT + "</title></head><body><h1>TGT Created</h1><form action=\"";
    private static final String REST_OF_THE_FORM_AND_CLOSING_TAGS = "\" method=\"POST\">Service:<input type=\"text\" name=\"service\" value=\"\"><br><input type=\"submit\" value=\"Submit\"></form></body></html>";
    private static final int SUCCESSFUL_TGT_CREATED_INITIAL_LENGTH = DOCTYPE_AND_OPENING_FORM.length() + "\" method=\"POST\">Service:<input type=\"text\" name=\"service\" value=\"\"><br><input type=\"submit\" value=\"Submit\"></form></body></html>".length();
    private RedisTemplate<String, Object> redisTemplate;
    private AuthenticationServerProperties properties;

    @Audit(action="REST_API_TICKET_GRANTING_TICKET", actionResolverName="REST_API_TICKET_GRANTING_TICKET_ACTION_RESOLVER", resourceResolverName="REST_API_TICKET_GRANTING_TICKET_RESOURCE_RESOLVER")
    public ResponseEntity<String> build(TicketGrantingTicket ticketGrantingTicket, HttpServletRequest request) throws Exception {
        String response;
        URI ticketReference = new URI(request.getRequestURL().toString() + '/' + ticketGrantingTicket.getId());
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(ticketReference);
        Principal principal = ticketGrantingTicket.getAuthentication().getPrincipal();
        Object tokenObj = principal.getAttributes().get("hussar_cas_server_token_key");
        String token = null;
        if (HussarUtils.isNotEmpty(tokenObj)) {
            if (tokenObj instanceof String) {
                token = (String)tokenObj;
            } else if (tokenObj instanceof List && ((List)tokenObj).size() > 0) {
                token = (String)((List)tokenObj).get(0);
            }
        }
        headers.add("hussar-unify-token", token);
        if (this.redisTemplate == null) {
            this.redisTemplate = (RedisTemplate)SpringContextUtil.getBean(RedisTemplate.class);
        }
        if (this.properties == null) {
            this.properties = (AuthenticationServerProperties)SpringContextUtil.getBean(AuthenticationServerProperties.class);
        }
        String userInfoJson = (String)this.redisTemplate.opsForValue().get((Object)("hussar_cas_user::" + token));
        HussarCasUserInfo userInfo = (HussarCasUserInfo)JsonUtil.parse((String)userInfoJson, HussarCasUserInfo.class);
        userInfo.setRestTgt(ticketReference.toASCIIString());
        if (this.properties.getTokenTimeout() < 0) {
            this.redisTemplate.opsForValue().set((Object)("hussar_cas_user::" + token), (Object)JsonUtil.toJson((Object)userInfo));
        } else {
            this.redisTemplate.opsForValue().set((Object)("hussar_cas_user::" + token), (Object)JsonUtil.toJson((Object)userInfo), (long)this.properties.getTokenTimeout().intValue(), TimeUnit.SECONDS);
        }
        if (this.isDefaultContentType(request)) {
            headers.setContentType(MediaType.TEXT_HTML);
            String tgtUrl = ticketReference.toString();
            response = new StringBuilder(SUCCESSFUL_TGT_CREATED_INITIAL_LENGTH + tgtUrl.length()).append(DOCTYPE_AND_OPENING_FORM).append(tgtUrl).append(REST_OF_THE_FORM_AND_CLOSING_TAGS).toString();
        } else {
            response = ticketGrantingTicket.getId();
        }
        ResponseEntity entity = new ResponseEntity((Object)response, (MultiValueMap)headers, HttpStatus.CREATED);
        LOGGER.debug("Created response entity [{}]", (Object)entity);
        return entity;
    }

    private boolean isDefaultContentType(HttpServletRequest request) {
        String accept = request.getHeader("Accept") == null ? null : request.getHeader("Accept").trim();
        return StringUtils.isBlank((CharSequence)accept) || accept.startsWith("*/*") || accept.startsWith("text/html");
    }
}

