/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unify.authentication.server.controller;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.unify.authentication.core.enums.ExceptionCodeEnum;
import com.jxdinfo.hussar.unify.authentication.server.controller.dto.PhoneCaptchaDTO;
import com.jxdinfo.hussar.unify.authentication.server.properties.AuthenticationServerProperties;
import com.jxdinfo.hussar.unify.authentication.server.service.PhoneCaptchaService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PhoneCaptchaController {
    @Resource
    private PhoneCaptchaService phoneCaptchaService;
    @Resource
    private AuthenticationServerProperties properties;
    @Resource
    private RedisTemplate<String, Object> redisTemplate;

    @PostMapping(value={"/phone/captcha"})
    public ApiResponse sendPhoneCaptcha(@RequestBody PhoneCaptchaDTO phoneCaptchaDTO) {
        if (HussarUtils.isEmpty((Object)phoneCaptchaDTO.getPhone())) {
            return ApiResponse.fail((int)ExceptionCodeEnum.PHONE_IS_NULL.getCode(), (String)ExceptionCodeEnum.PHONE_IS_NULL.getMessage());
        }
        String captcha = this.phoneCaptchaService.sendCaptcha(phoneCaptchaDTO.getPhone());
        Long seconds = (long)this.properties.getPhoneCaptchaExpire().intValue() * 60L;
        this.redisTemplate.opsForValue().set((Object)("hussar_cas_phone_captcha::" + phoneCaptchaDTO.getPhone()), (Object)captcha, seconds.longValue(), TimeUnit.SECONDS);
        return ApiResponse.success();
    }
}

