/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unify.authentication.server.controller;

import com.google.code.kaptcha.Producer;
import com.jxdinfo.hussar.platform.core.annotation.Inner;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.unify.authentication.core.enums.ExceptionCodeEnum;
import com.jxdinfo.hussar.unify.authentication.server.properties.AuthenticationServerProperties;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CaptchaController {
    private static Logger logger = LoggerFactory.getLogger(CaptchaController.class);
    @Resource
    private AuthenticationServerProperties properties;
    @Resource
    private Producer producer;
    @Resource
    private RedisTemplate<String, Object> redisTemplate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/captcha"})
    @Inner
    public ApiResponse index(HttpServletRequest request, HttpServletResponse response) {
        response.setDateHeader("Expires", 0L);
        response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        response.setHeader("Pragma", "no-cache");
        response.setContentType("image/jpeg");
        String capText = this.producer.createText();
        String captchaUniqueTag = request.getParameter("captchaUniqueTag");
        if (StringUtils.isBlank((CharSequence)captchaUniqueTag)) {
            return ApiResponse.fail((int)ExceptionCodeEnum.PICTURE_CAPTCHA_ERROR.getCode(), (String)ExceptionCodeEnum.PICTURE_CAPTCHA_ERROR.getMessage());
        }
        Long seconds = (long)this.properties.getCaptchaExpire().intValue() * 60L;
        this.redisTemplate.opsForValue().set((Object)("hussar_cas_picture_captcha::" + captchaUniqueTag), (Object)capText, seconds.longValue(), TimeUnit.SECONDS);
        BufferedImage bi = this.producer.createImage(capText);
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        try {
            ImageIO.write((RenderedImage)bi, "jpg", (OutputStream)out);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        try {
            try {
                if (out != null) {
                    out.flush();
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
        }
        return ApiResponse.success();
    }
}

