/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unify.authentication.client.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.unify.authentication.client.dto.RestLoginDTO;
import com.jxdinfo.hussar.unify.authentication.client.exception.ClientLoginException;
import com.jxdinfo.hussar.unify.authentication.client.exception.ClientLoginParamException;
import com.jxdinfo.hussar.unify.authentication.client.exception.ClientLogoutException;
import com.jxdinfo.hussar.unify.authentication.client.properties.UnifyAuthenticationClientProperties;
import com.jxdinfo.hussar.unify.authentication.client.utils.GetLoginUserUtil;
import com.jxdinfo.hussar.unify.authentication.core.dto.CheckTokenDTO;
import com.jxdinfo.hussar.unify.authentication.core.dto.RefreshTokenDTO;
import com.jxdinfo.hussar.unify.authentication.core.entity.HussarCasUserInfo;
import com.jxdinfo.hussar.unify.authentication.core.enums.AuthenticationType;
import com.jxdinfo.hussar.unify.authentication.core.vo.AutoRefreshConfigVO;
import com.jxdinfo.hussar.unify.authentication.core.vo.CheckTokenVO;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpRequestUtil {
    protected static Logger logger = LoggerFactory.getLogger(OkHttpRequestUtil.class);
    private static final Pattern pattern = Pattern.compile("(?<=java.util.ArrayList,\\[)[\\s\\S]*(?=\\]\\]})");
    private static final OkHttpClient client = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();
    private static UnifyAuthenticationClientProperties properties;

    public static Response getTgt(RestLoginDTO loginDTO) {
        try {
            Response response = client.newCall(OkHttpRequestUtil.createGetTgtRequest(loginDTO)).execute();
            if (201 == response.code()) {
                return response;
            }
            String errorMessage = new String(response.body().bytes());
            String username = loginDTO.getAuthenticationTypeCode().equals(AuthenticationType.MOBILE_VERIFICATION_CODE.getCode()) ? loginDTO.getPhoneNumber() : loginDTO.getUsername();
            logger.error("\u7528\u6237{}\u8ba4\u8bc1\u5931\u8d25{}", (Object)username, (Object)errorMessage);
            throw new ClientLoginException("\u8ba4\u8bc1\u5931\u8d25 " + OkHttpRequestUtil.parseErrorMessage(errorMessage));
        }
        catch (IOException e) {
            logger.error("\u7528\u6237\u8ba4\u8bc1\u5931\u8d25", (Throwable)e);
            throw new ClientLoginException();
        }
    }

    private static String parseErrorMessage(String errorMessage) {
        Matcher matcher = pattern.matcher(errorMessage = errorMessage.replaceAll("\\s*", "").replaceAll("\"", ""));
        if (matcher.find()) {
            return matcher.group().split(":")[1];
        }
        return errorMessage;
    }

    public static void logout(String token) {
        String tgt = GetLoginUserUtil.getTgt(token);
        if (HussarUtils.isEmpty((Object)tgt)) {
            throw new ClientLogoutException("\u5ba2\u6237\u7aef\u767b\u51fa\u5931\u8d25\uff0c\u65e0\u6cd5\u83b7\u53d6\u670d\u52a1\u7aefTGT\u6570\u636e");
        }
        FormBody formBody = new FormBody.Builder().build();
        Request.Builder builder = new Request.Builder().url(tgt).delete((RequestBody)formBody);
        try {
            Response response = client.newCall(builder.build()).execute();
            if (!response.isSuccessful()) {
                throw new ClientLogoutException("\u670d\u52a1\u7aef\u767b\u51fa\u5f02\u5e38" + response.message());
            }
        }
        catch (IOException e) {
            logger.error("\u670d\u52a1\u7aef\u767b\u51fa\u5931\u8d25", (Throwable)e);
            throw new ClientLogoutException("\u670d\u52a1\u7aef\u767b\u51fa\u5931\u8d25");
        }
    }

    public static AutoRefreshConfigVO getAutoRefreshTokenConfig() {
        Request request = new Request.Builder().url(OkHttpRequestUtil.clientProperties().getServerHostUrl() + "/uas/token/refresh/getAutoConfig").build();
        try {
            Response response = client.newCall(request).execute();
            if (!response.isSuccessful()) {
                logger.error("\u83b7\u53d6token\u81ea\u52a8\u5237\u65b0\u89c4\u5219\u8bf7\u6c42\u5931\u8d25" + response.message());
                return null;
            }
            String resultStr = response.body().string();
            ApiResponse apiResponse = (ApiResponse)JsonUtil.parse((String)resultStr, (TypeReference)new TypeReference<ApiResponse<AutoRefreshConfigVO>>(){});
            if (apiResponse != null && apiResponse.isSuccess()) {
                return (AutoRefreshConfigVO)apiResponse.getData();
            }
            logger.error("\u83b7\u53d6token\u81ea\u52a8\u5237\u65b0\u89c4\u5219\u5931\u8d25" + resultStr);
            return null;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6token\u81ea\u52a8\u5237\u65b0\u89c4\u5219\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static HussarCasUserInfo refreshToken(Boolean isAutoRefresh, String token) {
        RefreshTokenDTO refreshTokenDTO = new RefreshTokenDTO();
        refreshTokenDTO.setToken(token);
        refreshTokenDTO.setAutoRefresh(isAutoRefresh);
        Request request = OkHttpRequestUtil.postRequest(JsonUtil.toJson((Object)refreshTokenDTO), OkHttpRequestUtil.clientProperties().getServerHostUrl() + "/uas/token/refresh");
        try {
            Response response = client.newCall(request).execute();
            if (!response.isSuccessful()) {
                logger.error("\u5237\u65b0token\u6709\u6548\u671f\u8bf7\u6c42\u5931\u8d25" + response.message());
            } else {
                String resultStr = response.body().string();
                ApiResponse apiResponse = (ApiResponse)JsonUtil.parse((String)resultStr, (TypeReference)new TypeReference<ApiResponse<HussarCasUserInfo>>(){});
                if (apiResponse != null && apiResponse.isSuccess()) {
                    return (HussarCasUserInfo)apiResponse.getData();
                }
                logger.error("\u5237\u65b0token\u6709\u6548\u671f\u5931\u8d25" + resultStr);
            }
        }
        catch (Exception e) {
            logger.error("\u5237\u65b0token\u6709\u6548\u671f\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }

    public static CheckTokenVO checkToken(String clientUrl, String token) {
        CheckTokenDTO checkTokenDTO = new CheckTokenDTO();
        checkTokenDTO.setToken(token);
        checkTokenDTO.setClientUrl(clientUrl);
        Request request = OkHttpRequestUtil.postRequest(JsonUtil.toJson((Object)checkTokenDTO), OkHttpRequestUtil.clientProperties().getServerHostUrl() + "/uas/token/check");
        try {
            Response response = client.newCall(request).execute();
            if (response.isSuccessful()) {
                String resultStr = response.body().string();
                ApiResponse apiResponse = (ApiResponse)JsonUtil.parse((String)resultStr, (TypeReference)new TypeReference<ApiResponse<CheckTokenVO>>(){});
                if (apiResponse != null && apiResponse.isSuccess()) {
                    return (CheckTokenVO)apiResponse.getData();
                }
                logger.error("\u6821\u9a8ctoken\u662f\u5426\u6709\u6548\u5931\u8d25" + resultStr);
                return null;
            }
            logger.error("\u6821\u9a8ctoken\u662f\u5426\u6709\u6548\u8bf7\u6c42\u5931\u8d25" + response.message());
        }
        catch (Exception e) {
            logger.error("\u6821\u9a8ctoken\u662f\u5426\u6709\u6548\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }

    public static HussarCasUserInfo getUser(String token) {
        Request request = new Request.Builder().url(OkHttpRequestUtil.clientProperties().getServerHostUrl() + "/uas/token/getUserInfo" + "?token=" + token).build();
        try {
            Response response = client.newCall(request).execute();
            if (response.isSuccessful()) {
                String resultStr = response.body().string();
                ApiResponse apiResponse = (ApiResponse)JsonUtil.parse((String)resultStr, (TypeReference)new TypeReference<ApiResponse<HussarCasUserInfo>>(){});
                if (apiResponse != null && apiResponse.isSuccess()) {
                    return (HussarCasUserInfo)apiResponse.getData();
                }
                logger.error("\u901a\u8fc7token\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25" + resultStr);
                return null;
            }
            logger.error("\u901a\u8fc7token\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u8bf7\u6c42\u5931\u8d25" + response.message());
        }
        catch (Exception e) {
            logger.error("\u901a\u8fc7token\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String refreshTgt(Map<String, Object> params) {
        String url = "/uas/token/refreshTgt";
        logger.info("\u7edf\u4e00\u8ba4\u8bc1 http\u8bf7\u6c42\u63a5\u53e3\u540d:{}, url:{}, \u5165\u53c2\u4e3a:{}", new Object[]{"TGT\u7eed\u671f", url, JsonUtil.toJson(params)});
        try (Response response = null;){
            String httpUrl = OkHttpRequestUtil.clientProperties().getServerHostUrl() + url;
            response = client.newCall(OkHttpRequestUtil.postRequest(JsonUtil.toJson(params), httpUrl)).execute();
            if (!response.isSuccessful()) {
                logger.error("\u7edf\u4e00\u8ba4\u8bc1\u63a5\u53e3http\u8bf7\u6c42\u5931\u8d25, \u63a5\u53e3\u540d:{}, url:{}, message:{}", new Object[]{"TGT\u7eed\u671f", url, response.message()});
            }
            String string = Objects.requireNonNull(response.body()).string();
            return string;
        }
        return null;
    }

    private static Request postRequest(String paramJson, String url) {
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)paramJson);
        return new Request.Builder().url(url).post(body).build();
    }

    private static UnifyAuthenticationClientProperties clientProperties() {
        if (properties == null) {
            properties = (UnifyAuthenticationClientProperties)SpringContextUtil.getBean(UnifyAuthenticationClientProperties.class);
        }
        return properties;
    }

    private static Request createGetTgtRequest(RestLoginDTO loginDTO) {
        String authenticationTypeCode = loginDTO.getAuthenticationTypeCode();
        if (HussarUtils.isEmpty((Object)authenticationTypeCode)) {
            throw new ClientLoginParamException("\u8ba4\u8bc1\u7c7b\u578b\u7f16\u7801\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FormBody.Builder builder = new FormBody.Builder();
        if (HussarUtils.isNotEmpty((Object)loginDTO.getTenantConnName())) {
            builder.add("tenantConnName", loginDTO.getTenantConnName());
        }
        if (HussarUtils.isNotEmpty((Object)loginDTO.getTenantCode())) {
            builder.add("tenantCode", loginDTO.getTenantCode());
        }
        switch (authenticationTypeCode) {
            case "4": {
                String email = loginDTO.getEmail();
                if (HussarUtils.isEmpty((Object)email)) {
                    throw new ClientLoginParamException("\u767b\u5f55\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a");
                }
                String emailCaptcha = loginDTO.getEmailCaptcha();
                if (HussarUtils.isEmpty((Object)emailCaptcha)) {
                    throw new ClientLoginParamException("\u90ae\u7bb1\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
                builder.add("email", email).add("emailCaptcha", emailCaptcha).add("authenticationTypeCode", authenticationTypeCode);
                break;
            }
            case "3": {
                String phoneNumber = loginDTO.getPhoneNumber();
                if (HussarUtils.isEmpty((Object)phoneNumber)) {
                    throw new ClientLoginParamException("\u767b\u5f55\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                }
                String phoneCaptcha = loginDTO.getPhoneCaptcha();
                if (HussarUtils.isEmpty((Object)phoneCaptcha)) {
                    throw new ClientLoginParamException("\u624b\u673a\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
                builder.add("phoneNumber", phoneNumber).add("phoneCaptcha", phoneCaptcha).add("authenticationTypeCode", authenticationTypeCode);
                break;
            }
            case "2": {
                String userName = loginDTO.getUsername();
                if (HussarUtils.isEmpty((Object)userName)) {
                    throw new ClientLoginParamException("\u767b\u5f55\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                }
                String password = loginDTO.getPassword();
                if (HussarUtils.isEmpty((Object)password)) {
                    throw new ClientLoginParamException("\u767b\u5f55\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
                String captchaUniqueTag = loginDTO.getCaptchaUniqueTag();
                String captcha = loginDTO.getCaptcha();
                if (HussarUtils.isEmpty((Object)captchaUniqueTag) && HussarUtils.isEmpty((Object)captcha)) {
                    throw new ClientLoginParamException("\u767b\u5f55\u9a8c\u8bc1\u7801\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
                }
                builder.add("username", userName).add("password", password).add("captchaUniqueTag", captchaUniqueTag).add("captcha", captcha).add("authenticationTypeCode", authenticationTypeCode);
                break;
            }
            default: {
                String userName = loginDTO.getUsername();
                if (HussarUtils.isEmpty((Object)userName)) {
                    throw new ClientLoginParamException("\u767b\u5f55\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                }
                String password = loginDTO.getPassword();
                if (HussarUtils.isEmpty((Object)password)) {
                    throw new ClientLoginParamException("\u767b\u5f55\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
                builder.add("username", userName).add("password", password).add("authenticationTypeCode", AuthenticationType.DEFAULT.getCode());
            }
        }
        return new Request.Builder().url(OkHttpRequestUtil.clientProperties().getServerHostUrl() + "/uas/v1/tickets").post((RequestBody)builder.build()).build();
    }
}

