/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unify.authentication.client.session;

import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.unify.authentication.client.service.SpringSessionService;
import javax.servlet.http.HttpSession;
import org.jasig.cas.client.session.SessionMappingStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RedisBackedSessionMappingStorage
implements SessionMappingStorage {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String NAMESPACE = "CAS_CLIENT";
    private static final String ID_TO_SESSION_KEY_MAPPING = "CAS_CLIENT:SESSION_KEY:";
    private static final String MANAGED_SESSIONS = "CAS_CLIENT:MAPPING_ID:";
    private SpringSessionService springSessionService;

    public RedisBackedSessionMappingStorage() {
    }

    public RedisBackedSessionMappingStorage(SpringSessionService springSessionService) {
        this.springSessionService = springSessionService;
    }

    public synchronized void addSessionById(String mappingId, HttpSession session) {
        try {
            HussarCacheUtil.put((String)NAMESPACE, (Object)(ID_TO_SESSION_KEY_MAPPING + session.getId()), (Object)mappingId);
            HussarCacheUtil.put((String)NAMESPACE, (Object)(MANAGED_SESSIONS + mappingId), (Object)session.getId());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void removeBySessionById(String sessionId) {
        this.logger.debug("Attempting to remove Session=[{}]", (Object)sessionId);
        try {
            String mappingId = (String)HussarCacheUtil.get((String)NAMESPACE, (Object)(ID_TO_SESSION_KEY_MAPPING + sessionId), String.class);
            if (this.logger.isDebugEnabled()) {
                if (mappingId != null) {
                    this.logger.debug("Found mapping for session.  Session Removed.");
                } else {
                    this.logger.debug("No mapping for session found.  Ignoring.");
                }
            }
            if (mappingId != null) {
                HussarCacheUtil.evict((String)NAMESPACE, (Object)(MANAGED_SESSIONS + mappingId));
                HussarCacheUtil.evict((String)NAMESPACE, (Object)(ID_TO_SESSION_KEY_MAPPING + sessionId));
                this.springSessionService.deleteSessionBySessionId(sessionId);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized HttpSession removeSessionByMappingId(String mappingId) {
        try {
            String sessionId = (String)HussarCacheUtil.get((String)NAMESPACE, (Object)(MANAGED_SESSIONS + mappingId), String.class);
            if (sessionId != null) {
                this.removeBySessionById(sessionId);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

