/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unify.authentication.client.controller.cas;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.unify.authentication.client.properties.UnifyAuthenticationClientProperties;
import com.jxdinfo.hussar.unify.authentication.client.service.AbstractServiceUrlProcessor;
import com.jxdinfo.hussar.unify.authentication.client.service.TenantProcessor;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jasig.cas.client.validation.Assertion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/unify/cas"})
public class CasUnifyAuthenticationController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private UnifyAuthenticationClientProperties properties;
    @Resource
    private AbstractServiceUrlProcessor serviceUrlProcessor;
    @Resource
    private TenantProcessor tenantProcessor;

    @GetMapping(value={"/login"})
    public String login(HttpServletRequest request) {
        String connName = this.tenantProcessor.parseConnName(request);
        String tenantCode = this.tenantProcessor.parseTenantCode(request);
        String casLoginUrl = this.properties.getServerHostUrl() + "/uas/login" + "?service=" + this.serviceUrlProcessor.loginSuccessServiceUrl(request, this.properties);
        if (HussarUtils.isNotEmpty((Object)connName)) {
            casLoginUrl = casLoginUrl + "&" + "tenantConnName" + "=" + connName;
        }
        if (HussarUtils.isNotEmpty((Object)tenantCode)) {
            casLoginUrl = casLoginUrl + "&" + "tenantCode" + "=" + tenantCode;
        }
        return "redirect:" + casLoginUrl;
    }

    @ResponseBody
    @GetMapping(value={"/loginSuccess"})
    public void loginSuccess(HttpServletRequest request) {
        Assertion assertion = (Assertion)request.getSession().getAttribute("_const_cas_assertion_");
        String accountName = assertion.getPrincipal().getName();
        this.logger.info("\u8d26\u53f7{}\u767b\u5f55\u6210\u529f\uff01", (Object)accountName);
    }

    @GetMapping(value={"/logout"})
    public String logout(HttpServletRequest request, HttpSession session) {
        String casLogoutUrl = this.properties.getServerHostUrl() + "/uas/logout" + "?service=" + this.serviceUrlProcessor.logoutSuccessServiceUrl(request, this.properties);
        session.invalidate();
        return "redirect:" + casLogoutUrl;
    }

    @ResponseBody
    @GetMapping(value={"logoutSuccess"})
    public void logoutSuccess(String accountName) {
        this.logger.info("\u8d26\u53f7{}\u767b\u51fa\u6210\u529f\uff01", (Object)(HussarUtils.isNotEmpty((Object)accountName) ? accountName : ""));
    }
}

