/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unify.authentication.client.service;

import com.jxdinfo.hussar.unify.authentication.client.dto.RestLoginDTO;
import com.jxdinfo.hussar.unify.authentication.client.properties.UnifyAuthenticationClientProperties;
import com.jxdinfo.hussar.unify.authentication.client.service.AbstractSendMailService;
import com.jxdinfo.hussar.unify.authentication.client.service.TenantProcessor;
import com.jxdinfo.hussar.unify.authentication.client.service.UnifyAuthenticationPostProcessor;
import com.jxdinfo.hussar.unify.authentication.client.vo.LoginTokenVO;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUnifyAuthenticationService {
    protected final Logger logger = LoggerFactory.getLogger(AbstractUnifyAuthenticationService.class);
    @Resource
    private UnifyAuthenticationPostProcessor unifyAuthenticationPostProcessor;
    @Resource
    private UnifyAuthenticationClientProperties properties;
    @Resource
    private AbstractSendMailService abstractSendMailService;
    @Resource
    private TenantProcessor tenantProcessor;

    public LoginTokenVO login(RestLoginDTO loginDTO, HttpServletRequest request) {
        LoginTokenVO tokenVO;
        try {
            loginDTO.setTenantConnName(this.tenantProcessor.parseConnName(request));
            loginDTO.setTenantCode(this.tenantProcessor.parseTenantCode(request));
            tokenVO = this.doLogin(loginDTO);
        }
        catch (Exception e) {
            if (this.properties.getLoginErrorSendMail().booleanValue()) {
                this.abstractSendMailService.sendLoginErrorMail(loginDTO.getUsername(), e);
            }
            throw e;
        }
        try {
            this.unifyAuthenticationPostProcessor.loginSuccess(tokenVO.getAccountName());
        }
        catch (Exception e) {
            this.logger.error("\u767b\u5f55\u6210\u529f\u56de\u8c03\u65b9\u6cd5\u6267\u884c\u5931\u8d25\uff0caccountName = {}", (Object)tokenVO.getAccountName(), (Object)e);
        }
        return tokenVO;
    }

    protected abstract LoginTokenVO doLogin(RestLoginDTO var1);

    public void logout(HttpServletRequest request) {
        String accountName = this.doLogout(request);
        try {
            this.unifyAuthenticationPostProcessor.logoutSuccess(accountName);
        }
        catch (Exception e) {
            this.logger.error("\u767b\u51fa\u6210\u529f\u56de\u8c03\u65b9\u6cd5\u6267\u884c\u5931\u8d25\uff0caccountName = {}", (Object)accountName, (Object)e);
        }
    }

    protected abstract String doLogout(HttpServletRequest var1);
}

