/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unify.authentication.client.interceptor;

import com.jxdinfo.hussar.platform.core.BooleanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.unify.authentication.client.config.oauth2.AutoRefreshTokenConfig;
import com.jxdinfo.hussar.unify.authentication.client.exception.ClientUnLoginException;
import com.jxdinfo.hussar.unify.authentication.client.properties.UnifyAuthenticationClientProperties;
import com.jxdinfo.hussar.unify.authentication.client.utils.GetLoginUserUtil;
import com.jxdinfo.hussar.unify.authentication.client.utils.OkHttpRequestUtil;
import com.jxdinfo.hussar.unify.authentication.client.utils.UnifyAuthSecurityUtil;
import com.jxdinfo.hussar.unify.authentication.core.entity.HussarCasUserInfo;
import com.jxdinfo.hussar.unify.authentication.core.enums.AuthProtocolType;
import com.jxdinfo.hussar.unify.authentication.core.vo.CheckTokenVO;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class Oauth2HandlerInterceptor
implements HandlerInterceptor {
    @Resource
    private AutoRefreshTokenConfig autoRefreshConfig;
    @Resource
    private UnifyAuthenticationClientProperties properties;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        AuthProtocolType authProtocolType = AuthProtocolType.match((String)request.getHeader("unify-auth-type"));
        if (AuthProtocolType.OAUTH2.equals((Object)authProtocolType)) {
            if (UnifyAuthSecurityUtil.isRequestUrlExcluded(request, handler, this.properties.getIgnorePatterns())) {
                return true;
            }
            if (this.validate(request)) {
                return true;
            }
            throw new ClientUnLoginException();
        }
        return true;
    }

    private boolean validate(HttpServletRequest request) {
        String token = request.getHeader("hussar-unify-token");
        if (HussarUtils.isEmpty((Object)token)) {
            return false;
        }
        Boolean result = false;
        if (HussarCacheUtil.containKey((String)"hussar_uas_client_user", (Object)token)) {
            result = true;
            if (this.autoRefreshConfig != null && BooleanUtil.isTrue((Boolean)this.autoRefreshConfig.getEnableAutoRefresh())) {
                long expireTime = GetLoginUserUtil.getExpireTime(token);
                int threshold = this.autoRefreshConfig.getRefreshTokenThreshold();
                if (expireTime > 0L && expireTime - System.currentTimeMillis() <= (long)(threshold * 1000)) {
                    HussarCasUserInfo userInfo = OkHttpRequestUtil.refreshToken(true, token);
                    this.saveUserInfo(userInfo, token);
                }
            }
        } else {
            CheckTokenVO checkTokenVO = OkHttpRequestUtil.checkToken(request.getRequestURL().toString(), token);
            if (checkTokenVO != null && checkTokenVO.getValid().booleanValue()) {
                this.saveUserInfo(checkTokenVO.getUserInfo(), token);
                result = true;
            }
        }
        return result;
    }

    private void saveUserInfo(HussarCasUserInfo userInfo, String token) {
        if (HussarUtils.isNotEmpty((Object)userInfo)) {
            if (userInfo.getExpireTime() > 0L) {
                HussarCacheUtil.put((String)"hussar_uas_client_user", (Object)token, (Object)userInfo, (long)((userInfo.getExpireTime() - System.currentTimeMillis()) / 1000L));
            } else {
                HussarCacheUtil.put((String)"hussar_uas_client_user", (Object)token, (Object)userInfo);
            }
        }
    }
}

