/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unify.authentication.client.config.cas;

import com.jxdinfo.hussar.unify.authentication.client.controller.cas.CasUnifyAuthenticationController;
import com.jxdinfo.hussar.unify.authentication.client.filter.CasClientAuthenticationFilter;
import com.jxdinfo.hussar.unify.authentication.client.properties.UnifyAuthenticationClientProperties;
import com.jxdinfo.hussar.unify.authentication.client.properties.cas.CasProperties;
import com.jxdinfo.hussar.unify.authentication.client.service.AbstractServiceUrlProcessor;
import com.jxdinfo.hussar.unify.authentication.client.service.ClientModelPermissionService;
import com.jxdinfo.hussar.unify.authentication.client.service.TenantProcessor;
import com.jxdinfo.hussar.unify.authentication.client.service.impl.DefaultClientModelPermissionServiceImpl;
import com.jxdinfo.hussar.unify.authentication.client.service.impl.DefaultServiceUrlProcessor;
import java.util.EventListener;
import java.util.HashMap;
import javax.servlet.Filter;
import org.jasig.cas.client.session.SingleSignOutFilter;
import org.jasig.cas.client.session.SingleSignOutHttpSessionListener;
import org.jasig.cas.client.validation.Cas30ProxyReceivingTicketValidationFilter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Configuration
public class CasClientConfig {
    @Bean
    public CasProperties casProperties() {
        return new CasProperties();
    }

    @Bean
    public CasUnifyAuthenticationController casUnifyAuthenticationController() {
        return new CasUnifyAuthenticationController();
    }

    @Bean
    @ConditionalOnMissingBean(value={AbstractServiceUrlProcessor.class})
    public AbstractServiceUrlProcessor abstractCallbackUrlService() {
        return new DefaultServiceUrlProcessor();
    }

    @Bean
    @ConditionalOnMissingBean(value={ClientModelPermissionService.class})
    public ClientModelPermissionService clientModelPermissionService() {
        return new DefaultClientModelPermissionServiceImpl();
    }

    @Bean
    public ServletListenerRegistrationBean<EventListener> singleSignOutListenerRegistration() {
        ServletListenerRegistrationBean registrationBean = new ServletListenerRegistrationBean();
        registrationBean.setListener((EventListener)new SingleSignOutHttpSessionListener());
        registrationBean.setOrder(1);
        return registrationBean;
    }

    @Bean
    public FilterRegistrationBean<SingleSignOutFilter> filterSignOutRegistration(UnifyAuthenticationClientProperties properties) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new SingleSignOutFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        HashMap<String, String> initParameters = new HashMap<String, String>();
        initParameters.put("casServerUrlPrefix", properties.getServerHostUrl() + "/uas");
        registration.setInitParameters(initParameters);
        registration.setOrder(1);
        return registration;
    }

    @Bean
    public FilterRegistrationBean<Cas30ProxyReceivingTicketValidationFilter> filterValidationRegistration(UnifyAuthenticationClientProperties properties) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new Cas30ProxyReceivingTicketValidationFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        HashMap<String, String> initParameters = new HashMap<String, String>();
        initParameters.put("casServerUrlPrefix", properties.getServerHostUrl() + "/uas");
        initParameters.put("serverName", properties.getClientHostUrl());
        initParameters.put("redirectAfterValidation", "true");
        initParameters.put("useSession", "true");
        initParameters.put("authn_method", "mfa-duo");
        registration.setInitParameters(initParameters);
        registration.setOrder(2);
        return registration;
    }

    @Bean
    public FilterRegistrationBean filterRegistrationBean(RequestMappingHandlerMapping requestMappingHandlerMapping, AbstractServiceUrlProcessor serviceUrlProcessor, UnifyAuthenticationClientProperties properties, TenantProcessor tenantProcessor, ClientModelPermissionService clientModelPermissionService) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new CasClientAuthenticationFilter(properties, requestMappingHandlerMapping, serviceUrlProcessor, tenantProcessor, this.casProperties(), clientModelPermissionService));
        registration.addUrlPatterns(new String[]{"/*"});
        HashMap<String, String> initParameters = new HashMap<String, String>();
        initParameters.put("casServerLoginUrl", properties.getServerHostUrl() + "/uas/login");
        initParameters.put("serverName", properties.getClientHostUrl() + "/");
        registration.setInitParameters(initParameters);
        registration.setOrder(2);
        return registration;
    }
}

