/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unify.authentication.client.service.impl.oauth2;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.unify.authentication.client.dto.RestLoginDTO;
import com.jxdinfo.hussar.unify.authentication.client.exception.ClientLoginException;
import com.jxdinfo.hussar.unify.authentication.client.service.AbstractUnifyAuthenticationService;
import com.jxdinfo.hussar.unify.authentication.client.utils.GetLoginUserUtil;
import com.jxdinfo.hussar.unify.authentication.client.utils.OkHttpRequestUtil;
import com.jxdinfo.hussar.unify.authentication.client.vo.LoginTokenVO;
import javax.servlet.http.HttpServletRequest;
import okhttp3.Response;

public class Oauth2UnifyAuthenticationServiceImpl
extends AbstractUnifyAuthenticationService {
    @Override
    protected LoginTokenVO doLogin(RestLoginDTO loginDTO) {
        Response response = OkHttpRequestUtil.getTgt(loginDTO);
        String tgt = response.header("Location");
        if (HussarUtils.isEmpty((Object)tgt)) {
            throw new ClientLoginException("\u83b7\u53d6\u8ba4\u8bc1tgt\u5931\u8d25");
        }
        String token = response.header("hussar-unify-token");
        if (HussarUtils.isEmpty((Object)token)) {
            throw new ClientLoginException("\u83b7\u53d6\u8ba4\u8bc1token\u5931\u8d25");
        }
        LoginTokenVO tokenVO = new LoginTokenVO();
        tokenVO.setToken(token);
        tokenVO.setAccountName(GetLoginUserUtil.getAccountName(token));
        return tokenVO;
    }

    @Override
    protected String doLogout(HttpServletRequest request) {
        String token = request.getHeader("hussar-unify-token");
        String accountName = GetLoginUserUtil.getAccountName(token);
        OkHttpRequestUtil.logout(token);
        if (HussarCacheUtil.containKey((String)"hussar_cas_user", (Object)token)) {
            HussarCacheUtil.evict((String)"hussar_cas_user", (Object)token);
        }
        return accountName;
    }
}

