/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unify.authentication.client.properties;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="hussar.unify.authentication")
public class UnifyAuthenticationClientProperties {
    public static final String UNIFY_AUTHENTICATION_CLIENT_PREFIX = "hussar.unify.authentication";
    private boolean enable = false;
    private String serverHostUrl = "http://127.0.0.1:8888";
    private String clientHostUrl = "http://127.0.0.1:8011";
    private List<String> ignorePatterns = new ArrayList<String>();
    private Boolean loginErrorSendMail = false;
    private List<String> errorMailReceiver = new ArrayList<String>();
    private static List<String> ignoreDefaultPatterns = new ArrayList<String>();

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public String getServerHostUrl() {
        return this.serverHostUrl;
    }

    public void setServerHostUrl(String serverHostUrl) {
        this.serverHostUrl = serverHostUrl;
    }

    public String getClientHostUrl() {
        return this.clientHostUrl;
    }

    public void setClientHostUrl(String clientHostUrl) {
        this.clientHostUrl = clientHostUrl;
    }

    public List<String> getIgnorePatterns() {
        ArrayList<String> allIgnoreUrls = new ArrayList<String>();
        if (HussarUtils.isEmpty(this.ignorePatterns)) {
            allIgnoreUrls.addAll(ignoreDefaultPatterns);
            return allIgnoreUrls;
        }
        allIgnoreUrls.addAll(this.ignorePatterns);
        allIgnoreUrls.addAll(ignoreDefaultPatterns);
        return allIgnoreUrls.stream().distinct().collect(Collectors.toList());
    }

    public void setIgnorePatterns(List<String> ignorePatterns) {
        this.ignorePatterns = ignorePatterns;
    }

    public Boolean getLoginErrorSendMail() {
        return this.loginErrorSendMail;
    }

    public void setLoginErrorSendMail(Boolean loginErrorSendMail) {
        this.loginErrorSendMail = loginErrorSendMail;
    }

    public List<String> getErrorMailReceiver() {
        return this.errorMailReceiver;
    }

    public void setErrorMailReceiver(List<String> errorMailReceiver) {
        this.errorMailReceiver = errorMailReceiver;
    }

    static {
        ignoreDefaultPatterns.add("/unify/oauth2/login");
        ignoreDefaultPatterns.add("/unify/cas/login");
        ignoreDefaultPatterns.add("/unify/cas/logout");
        ignoreDefaultPatterns.add("/unify/cas/logoutSuccess");
    }
}

