/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unify.authentication.client.filter;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.unify.authentication.client.properties.UnifyAuthenticationClientProperties;
import com.jxdinfo.hussar.unify.authentication.client.properties.cas.CasProperties;
import com.jxdinfo.hussar.unify.authentication.client.service.AbstractServiceUrlProcessor;
import com.jxdinfo.hussar.unify.authentication.client.service.TenantProcessor;
import com.jxdinfo.hussar.unify.authentication.client.utils.UnifyAuthSecurityUtil;
import com.jxdinfo.hussar.unify.authentication.core.enums.AuthProtocolType;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jasig.cas.client.Protocol;
import org.jasig.cas.client.authentication.AuthenticationRedirectStrategy;
import org.jasig.cas.client.authentication.ContainsPatternUrlPatternMatcherStrategy;
import org.jasig.cas.client.authentication.DefaultAuthenticationRedirectStrategy;
import org.jasig.cas.client.authentication.DefaultGatewayResolverImpl;
import org.jasig.cas.client.authentication.ExactUrlPatternMatcherStrategy;
import org.jasig.cas.client.authentication.GatewayResolver;
import org.jasig.cas.client.authentication.RegexUrlPatternMatcherStrategy;
import org.jasig.cas.client.authentication.UrlPatternMatcherStrategy;
import org.jasig.cas.client.configuration.ConfigurationKeys;
import org.jasig.cas.client.util.AbstractCasFilter;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.util.ReflectUtils;
import org.jasig.cas.client.validation.Assertion;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class CasClientAuthenticationFilter
extends AbstractCasFilter {
    private UnifyAuthenticationClientProperties properties;
    private RequestMappingHandlerMapping requestMappingHandlerMapping;
    private AbstractServiceUrlProcessor serviceUrlProcessor;
    private TenantProcessor tenantProcessor;
    private CasProperties casProperties;
    private String casServerLoginUrl;
    private boolean renew = false;
    private boolean gateway = false;
    private GatewayResolver gatewayStorage = new DefaultGatewayResolverImpl();
    private AuthenticationRedirectStrategy authenticationRedirectStrategy = new DefaultAuthenticationRedirectStrategy();
    private UrlPatternMatcherStrategy ignoreUrlPatternMatcherStrategyClass = null;
    private static final Map<String, Class<? extends UrlPatternMatcherStrategy>> PATTERN_MATCHER_TYPES = new HashMap<String, Class<? extends UrlPatternMatcherStrategy>>();

    public CasClientAuthenticationFilter() {
        this(Protocol.CAS2);
    }

    public CasClientAuthenticationFilter(UnifyAuthenticationClientProperties properties, RequestMappingHandlerMapping requestMappingHandlerMapping, AbstractServiceUrlProcessor serviceUrlProcessor, TenantProcessor tenantProcessor, CasProperties casProperties) {
        this(Protocol.CAS2);
        this.properties = properties;
        this.requestMappingHandlerMapping = requestMappingHandlerMapping;
        this.serviceUrlProcessor = serviceUrlProcessor;
        this.tenantProcessor = tenantProcessor;
        this.casProperties = casProperties;
    }

    protected CasClientAuthenticationFilter(Protocol protocol) {
        super(protocol);
    }

    protected void initInternal(FilterConfig filterConfig) throws ServletException {
        if (!this.isIgnoreInitConfiguration()) {
            Class authenticationRedirectStrategyClass;
            Class<? extends UrlPatternMatcherStrategy> gatewayStorageClass;
            super.initInternal(filterConfig);
            String loginUrl = this.getString(ConfigurationKeys.CAS_SERVER_LOGIN_URL);
            if (loginUrl != null) {
                this.setCasServerLoginUrl(loginUrl);
            } else {
                this.setCasServerUrlPrefix(this.getString(ConfigurationKeys.CAS_SERVER_URL_PREFIX));
            }
            this.setRenew(this.getBoolean(ConfigurationKeys.RENEW));
            this.setGateway(this.getBoolean(ConfigurationKeys.GATEWAY));
            String ignorePattern = this.getString(ConfigurationKeys.IGNORE_PATTERN);
            String ignoreUrlPatternType = this.getString(ConfigurationKeys.IGNORE_URL_PATTERN_TYPE);
            if (ignorePattern != null) {
                gatewayStorageClass = PATTERN_MATCHER_TYPES.get(ignoreUrlPatternType);
                if (gatewayStorageClass != null) {
                    this.ignoreUrlPatternMatcherStrategyClass = (UrlPatternMatcherStrategy)ReflectUtils.newInstance((String)gatewayStorageClass.getName(), (Object[])new Object[0]);
                } else {
                    try {
                        this.logger.trace("Assuming {} is a qualified class name...", (Object)ignoreUrlPatternType);
                        this.ignoreUrlPatternMatcherStrategyClass = (UrlPatternMatcherStrategy)ReflectUtils.newInstance((String)ignoreUrlPatternType, (Object[])new Object[0]);
                    }
                    catch (IllegalArgumentException var7) {
                        this.logger.error("Could not instantiate class [{}]", (Object)ignoreUrlPatternType, (Object)var7);
                    }
                }
                if (this.ignoreUrlPatternMatcherStrategyClass != null) {
                    this.ignoreUrlPatternMatcherStrategyClass.setPattern(ignorePattern);
                }
            }
            if ((gatewayStorageClass = this.getClass(ConfigurationKeys.GATEWAY_STORAGE_CLASS)) != null) {
                this.setGatewayStorage((GatewayResolver)ReflectUtils.newInstance(gatewayStorageClass, (Object[])new Object[0]));
            }
            if ((authenticationRedirectStrategyClass = this.getClass(ConfigurationKeys.AUTHENTICATION_REDIRECT_STRATEGY_CLASS)) != null) {
                this.authenticationRedirectStrategy = (AuthenticationRedirectStrategy)ReflectUtils.newInstance((Class)authenticationRedirectStrategyClass, (Object[])new Object[0]);
            }
        }
    }

    public void init() {
        super.init();
        String message = String.format("one of %s and %s must not be null.", ConfigurationKeys.CAS_SERVER_LOGIN_URL.getName(), ConfigurationKeys.CAS_SERVER_URL_PREFIX.getName());
        CommonUtils.assertNotNull((Object)this.casServerLoginUrl, (String)message);
    }

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        AuthProtocolType authProtocolType = AuthProtocolType.match((String)request.getHeader("unify-auth-type"));
        if (AuthProtocolType.CAS.equals((Object)authProtocolType)) {
            if (this.isRequestUrlExcluded(request)) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                Assertion assertion;
                HttpSession session = request.getSession(false);
                Assertion assertion2 = assertion = session != null ? (Assertion)session.getAttribute("_const_cas_assertion_") : null;
                if (assertion != null) {
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                } else {
                    boolean wasGatewayed;
                    String serviceUrl = this.constructServiceUrl(request, response);
                    String ticket = this.retrieveTicketFromRequest(request);
                    boolean bl = wasGatewayed = this.gateway && this.gatewayStorage.hasGatewayedAlready(request, serviceUrl);
                    if (!CommonUtils.isNotBlank((String)ticket) && !wasGatewayed) {
                        String modifiedServiceUrl;
                        this.logger.debug("no ticket and no assertion found");
                        if (this.gateway) {
                            this.logger.debug("setting gateway attribute in session");
                            modifiedServiceUrl = this.gatewayStorage.storeGatewayInformation(request, serviceUrl);
                        } else {
                            modifiedServiceUrl = serviceUrl;
                        }
                        String customServiceUrl = this.serviceUrlProcessor.authenticationFilterServiceUrl(request, this.properties);
                        if (HussarUtils.isNotEmpty((Object)customServiceUrl)) {
                            modifiedServiceUrl = customServiceUrl;
                        }
                        this.logger.debug("Constructed service url: {}", (Object)modifiedServiceUrl);
                        String urlToRedirectTo = CommonUtils.constructRedirectUrl((String)this.casServerLoginUrl, (String)this.getProtocol().getServiceParameterName(), (String)modifiedServiceUrl, (boolean)this.renew, (boolean)this.gateway);
                        this.logger.debug("redirecting to \"{}\"", (Object)urlToRedirectTo);
                        String connName = this.tenantProcessor.parseConnName(request);
                        if (HussarUtils.isNotEmpty((Object)connName)) {
                            urlToRedirectTo = urlToRedirectTo + "&" + "tenantConnName" + "=" + connName;
                        }
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("code", (Object)this.casProperties.getAuthFilerCode());
                        jsonObject.put("uasLoginUrl", (Object)urlToRedirectTo);
                        String tenantCode = this.tenantProcessor.parseTenantCode(request);
                        if (HussarUtils.isNotEmpty((Object)tenantCode)) {
                            jsonObject.put("tcode", (Object)tenantCode);
                        }
                        response.getWriter().print(jsonObject);
                    } else {
                        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                    }
                }
            }
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public final void setRenew(boolean renew) {
        this.renew = renew;
    }

    public final void setGateway(boolean gateway) {
        this.gateway = gateway;
    }

    public final void setCasServerUrlPrefix(String casServerUrlPrefix) {
        this.setCasServerLoginUrl(CommonUtils.addTrailingSlash((String)casServerUrlPrefix) + "login");
    }

    public final void setCasServerLoginUrl(String casServerLoginUrl) {
        this.casServerLoginUrl = casServerLoginUrl;
    }

    public final void setGatewayStorage(GatewayResolver gatewayStorage) {
        this.gatewayStorage = gatewayStorage;
    }

    private boolean isRequestUrlExcluded(HttpServletRequest request) {
        try {
            HandlerExecutionChain handlerMappingHandler = this.requestMappingHandlerMapping.getHandler(request);
            Object handler = null;
            if (handlerMappingHandler != null && handlerMappingHandler.getHandler() != null) {
                handler = handlerMappingHandler.getHandler();
            }
            return UnifyAuthSecurityUtil.isRequestUrlExcluded(request, handler, this.properties.getIgnorePatterns());
        }
        catch (Exception e) {
            this.logger.error("\u6821\u9a8c\u8bf7\u6c42\u662f\u5426\u5ffd\u7565\u8ba4\u8bc1\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public final void setIgnoreUrlPatternMatcherStrategyClass(UrlPatternMatcherStrategy ignoreUrlPatternMatcherStrategyClass) {
        this.ignoreUrlPatternMatcherStrategyClass = ignoreUrlPatternMatcherStrategyClass;
    }

    static {
        PATTERN_MATCHER_TYPES.put("CONTAINS", ContainsPatternUrlPatternMatcherStrategy.class);
        PATTERN_MATCHER_TYPES.put("REGEX", RegexUrlPatternMatcherStrategy.class);
        PATTERN_MATCHER_TYPES.put("EXACT", ExactUrlPatternMatcherStrategy.class);
    }
}

