/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.transdict.service.trans.service.impl;

import com.jxdinfo.hussar.support.transdict.core.anno.Trans;
import com.jxdinfo.hussar.support.transdict.core.util.ReflectUtils;
import com.jxdinfo.hussar.support.transdict.core.vo.TransDictVo;
import com.jxdinfo.hussar.support.transdict.service.support.TransFieldSet;
import com.jxdinfo.hussar.support.transdict.service.utils.CheckUtils;
import com.jxdinfo.hussar.support.transdict.service.utils.ConverterUtils;
import io.netty.util.internal.StringUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public interface ITransTypeService {
    public void transOne(TransDictVo var1, List<Field> var2);

    public void transMore(List<? extends TransDictVo> var1, List<Field> var2);

    public void transOne(TransDictVo var1, List<Field> var2, Trans var3);

    public void transMore(List<? extends TransDictVo> var1, List<Field> var2, Trans var3);

    default public void setRef(TransFieldSet transFieldSet, TransDictVo vo, String val) {
        Trans trans = transFieldSet.getTrans();
        if (CheckUtils.isNotEmpty(trans.ref())) {
            ReflectUtils.setValue((Object)vo, (String)trans.ref(), (Object)val);
        }
    }

    default public void setRef(TransFieldSet transFieldSet, TransDictVo vo, Map<String, String> valMap) {
        Trans trans = transFieldSet.getTrans();
        if (CheckUtils.isNotEmpty(trans.ref())) {
            String ref = trans.ref();
            this.setDictVoValue(vo, valMap, ref);
        } else if (trans.refs().length > 0 && Stream.of(trans.refs()).anyMatch(CheckUtils::isNotEmpty)) {
            for (String ref : trans.refs()) {
                if (!CheckUtils.isNotEmpty(ref)) continue;
                this.setDictVoValue(vo, valMap, ref);
            }
        } else {
            Map transMap = vo.getTransMap();
            if (transMap == null) {
                return;
            }
            String alias = transFieldSet.getAlias();
            if (!CheckUtils.isNullOrEmpty(alias)) {
                HashMap<String, String> tempMap = new HashMap<String, String>();
                Set<String> keys = valMap.keySet();
                for (String key : keys) {
                    tempMap.put(alias + key.substring(0, 1).toUpperCase() + key.substring(1), valMap.get(key));
                }
                valMap = tempMap;
            }
            Set<String> keys = valMap.keySet();
            for (String key : keys) {
                if (!CheckUtils.isNullOrEmpty(transMap.get(key))) continue;
                transMap.put(key, valMap.get(key));
            }
        }
    }

    default public void setDictVoValue(TransDictVo vo, Map<String, String> valMap, String ref) {
        String[] refSetting = ref.split("#");
        if (refSetting.length == 1) {
            if (valMap.size() > 0) {
                String key = valMap.keySet().iterator().next();
                ReflectUtils.setValue((Object)vo, (String)refSetting[0], (Object)valMap.get(key));
            }
        } else if (refSetting.length == 2) {
            ReflectUtils.setValue((Object)vo, (String)refSetting[0], (Object)valMap.get(refSetting[1]));
        }
    }

    default public void setRef(TransFieldSet transFieldSet, TransDictVo vo, Map<String, String> valMap, Field tempField) {
        Trans trans = transFieldSet.getTrans();
        if (CheckUtils.isNotEmpty(trans.ref())) {
            String ref = trans.ref();
            this.setDictVoValue(vo, valMap, ref, tempField);
        } else if (trans.refs().length > 0 && Stream.of(trans.refs()).anyMatch(CheckUtils::isNotEmpty)) {
            for (String ref : trans.refs()) {
                if (!CheckUtils.isNotEmpty(ref)) continue;
                this.setDictVoValue(vo, valMap, ref, tempField);
            }
        } else {
            Map transMap = vo.getTransMap();
            if (transMap == null) {
                return;
            }
            String alias = transFieldSet.getAlias();
            if (!CheckUtils.isNullOrEmpty(alias)) {
                HashMap<String, String> tempMap = new HashMap<String, String>();
                Set<String> keys = valMap.keySet();
                for (String key : keys) {
                    tempMap.put(alias + key.substring(0, 1).toUpperCase() + key.substring(1), valMap.get(key));
                }
                valMap = tempMap;
            }
            Set<String> keys = valMap.keySet();
            for (String key : keys) {
                if (!CheckUtils.isNullOrEmpty(transMap.get(key))) continue;
                transMap.put(key, valMap.get(key));
            }
        }
    }

    default public void setDictVoValue(TransDictVo vo, Map<String, String> valMap, String ref, Field tempField) {
        String[] refSetting = ref.split("#");
        String fieldValue = ConverterUtils.toString(ReflectUtils.getValue((Object)vo, (String)tempField.getName()));
        if (refSetting.length == 1) {
            String key;
            if (valMap.size() > 0 && !StringUtil.isNullOrEmpty((String)valMap.get(key = valMap.keySet().iterator().next()))) {
                ReflectUtils.setValue((Object)vo, (String)tempField.getName(), (Object)(fieldValue + "(" + valMap.get(key) + ")"));
            }
        } else if (refSetting.length == 2 && !StringUtil.isNullOrEmpty((String)valMap.get(refSetting[1]))) {
            ReflectUtils.setValue((Object)vo, (String)tempField.getName(), (Object)(fieldValue + "(" + valMap.get(refSetting[1]) + ")"));
        }
    }
}

