/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.transdict.service.trans.manager;

import com.jxdinfo.hussar.support.transdict.core.anno.Trans;
import com.jxdinfo.hussar.support.transdict.core.util.ReflectUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Logger LOGGER = LoggerFactory.getLogger(ClassInfo.class);
    private Class<?> clazz;
    private Field idField;
    String[] transTypes;
    private Map<String, Field> fieldMap = new HashMap<String, Field>();
    private Map<String, List<Field>> transFieldMap = new HashMap<String, List<Field>>();

    public ClassInfo() {
    }

    public <T> ClassInfo(Class<?> clazz) throws InstantiationException, IllegalAccessException {
        this.clazz = clazz;
        this.getClazzFieldMap();
    }

    public <T> ClassInfo(Class<?> clazz, Trans trans) throws InstantiationException, IllegalAccessException {
        this.clazz = clazz;
        this.getClazzFieldMap(trans);
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public void setClazz(Class<?> clazz) {
        this.clazz = clazz;
    }

    public Field getIdField() {
        return this.idField;
    }

    public void setIdField(Field idField) {
        this.idField = idField;
    }

    public Map<String, Field> getFieldMap() {
        return this.fieldMap;
    }

    public void setFieldMap(Map<String, Field> fieldMap) {
        this.fieldMap = fieldMap;
    }

    public String[] getTransTypes() {
        return this.transTypes;
    }

    public List<Field> getTransField(String type) {
        return this.transFieldMap.get(type);
    }

    private void getClazzFieldMap() throws InstantiationException, IllegalAccessException {
        List declaredFields = ReflectUtils.getAllField(this.clazz.newInstance());
        HashSet<String> transTypeSet = new HashSet<String>();
        int mod = 0;
        for (Field field : declaredFields) {
            Trans trans;
            mod = field.getModifiers();
            if (Modifier.isStatic(mod) || Modifier.isFinal(mod) || Modifier.isVolatile(mod) || (trans = field.getAnnotation(Trans.class) != null ? field.getAnnotation(Trans.class) : null) == null) continue;
            if (trans.type() == null) {
                LOGGER.warn("\u7c7b {} \u5c5e\u6027 [{}] type\u4e3a\u7a7a\u3002", (Object)this.clazz.getName(), (Object)field.getName());
                continue;
            }
            transTypeSet.add(trans.type());
            ArrayList<Field> fieldList = this.transFieldMap.get(trans.type());
            fieldList = fieldList != null ? fieldList : new ArrayList<Field>();
            fieldList.add(field);
            this.transFieldMap.put(trans.type(), fieldList);
        }
        this.transTypes = new String[transTypeSet.size()];
        transTypeSet.toArray(this.transTypes);
    }

    private void getClazzFieldMap(Trans trans) throws InstantiationException, IllegalAccessException {
        List declaredFields = ReflectUtils.getAllField(this.clazz.newInstance());
        HashSet<String> transTypeSet = new HashSet<String>();
        int mod = 0;
        for (Field field : declaredFields) {
            mod = field.getModifiers();
            if (Modifier.isStatic(mod) || Modifier.isFinal(mod) || Modifier.isVolatile(mod) || !"beforeValue".equalsIgnoreCase(field.getName()) && !"afterValue".equalsIgnoreCase(field.getName()) || trans == null) continue;
            if (trans.type() == null) {
                LOGGER.warn("\u7c7b {} \u5c5e\u6027 [{}] type\u4e3a\u7a7a\u3002", (Object)this.clazz.getName(), (Object)field.getName());
                continue;
            }
            transTypeSet.add(trans.type());
            ArrayList<Field> fieldList = this.transFieldMap.get(trans.type());
            fieldList = fieldList != null ? fieldList : new ArrayList<Field>();
            fieldList.add(field);
            this.transFieldMap.put(trans.type(), fieldList);
        }
        this.transTypes = new String[transTypeSet.size()];
        transTypeSet.toArray(this.transTypes);
    }

    public Map<String, List<Field>> getTransFieldMap() {
        return this.transFieldMap;
    }

    public void setTransFieldMap(Map<String, List<Field>> transFieldMap) {
        this.transFieldMap = transFieldMap;
    }

    public void setTransTypes(String[] transTypes) {
        this.transTypes = transTypes;
    }
}

