/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.transaction.config;

import com.jxdinfo.hussar.support.transaction.config.AbstractTransactionConfiguration;
import com.jxdinfo.hussar.support.transaction.support.aspect.HussarTransactionInterceptor;
import com.jxdinfo.hussar.support.transaction.support.attributesource.HussarAnnotationTransactionAttributeSource;
import com.jxdinfo.hussar.support.transaction.support.attributesource.parse.AbstractTransactionAnnotationParser;
import com.jxdinfo.hussar.support.transaction.support.attributesource.parse.DSTransactionAnnotationParser;
import com.jxdinfo.hussar.support.transaction.support.attributesource.parse.HussarLocalTransactionAnnotationParser;
import com.jxdinfo.hussar.support.transaction.support.attributesource.parse.HussarTransactionAnnotationParser;
import com.jxdinfo.hussar.support.transaction.support.attributesource.parse.SpringTransactionAnnotationParser;
import com.jxdinfo.hussar.transaction.plugin.datasource.properties.HussarTransactionProperties;
import javax.sql.DataSource;
import org.aopalliance.aop.Advice;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.jdbc.datasource.HussarDataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.BeanFactoryTransactionAttributeSourceAdvisor;
import org.springframework.transaction.interceptor.TransactionAttributeSource;

@Configuration(proxyBeanMethods=false)
@Role(value=2)
@EnableConfigurationProperties(value={HussarTransactionProperties.class})
@EnableAutoConfiguration(excludeName={"org.springframework.boot.autoconfigure.transaction.TransactionAutoConfiguration", "org.springframework.boot.autoconfigure.jdbc.DataSourceTransactionManagerAutoConfiguration", "org.springframework.boot.autoconfigure.data.jdbc.JdbcRepositoriesAutoConfiguration"})
public class HussarTransactionConfiguration
extends AbstractTransactionConfiguration {
    @Bean(value={"hussarTransactionAdvisor"})
    @Role(value=2)
    public BeanFactoryTransactionAttributeSourceAdvisor transactionAdvisor(TransactionAttributeSource transactionAttributeSource, HussarTransactionInterceptor transactionInterceptor) {
        BeanFactoryTransactionAttributeSourceAdvisor advisor = new BeanFactoryTransactionAttributeSourceAdvisor();
        advisor.setTransactionAttributeSource(transactionAttributeSource);
        advisor.setAdvice((Advice)transactionInterceptor);
        if (this.enableTx != null) {
            advisor.setOrder(((Integer)this.enableTx.getNumber("order")).intValue());
        }
        return advisor;
    }

    @Bean
    @Role(value=2)
    public TransactionAttributeSource transactionAttributeSource() {
        HussarAnnotationTransactionAttributeSource hussarAnnotationTransactionAttributeSource = Boolean.FALSE.equals(this.enableSeata) ? new HussarAnnotationTransactionAttributeSource(new HussarTransactionAnnotationParser(), new SpringTransactionAnnotationParser(), new DSTransactionAnnotationParser(), new HussarLocalTransactionAnnotationParser()) : new HussarAnnotationTransactionAttributeSource((AbstractTransactionAnnotationParser)new HussarLocalTransactionAnnotationParser());
        return hussarAnnotationTransactionAttributeSource;
    }

    @Bean
    @Role(value=2)
    public HussarTransactionInterceptor transactionInterceptor(TransactionAttributeSource transactionAttributeSource) {
        HussarTransactionInterceptor interceptor = new HussarTransactionInterceptor();
        interceptor.setTransactionAttributeSource(transactionAttributeSource);
        if (this.txManager != null) {
            interceptor.setTransactionManager(this.txManager);
        }
        return interceptor;
    }

    @Bean
    @ConditionalOnMissingBean(value={PlatformTransactionManager.class})
    public PlatformTransactionManager transactionManager(DataSource dataSource, HussarTransactionProperties properties, ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers) {
        HussarDataSourceTransactionManager transactionManager = new HussarDataSourceTransactionManager(dataSource);
        transactionManager.setHussarTransactionProperties(properties);
        transactionManagerCustomizers.ifAvailable(customizers -> customizers.customize((PlatformTransactionManager)transactionManager));
        return transactionManager;
    }
}

