/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.transaction.support.attributesource.parse;

import java.io.Serializable;
import java.util.ArrayList;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.TransactionAnnotationParser;
import org.springframework.transaction.interceptor.NoRollbackRuleAttribute;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;

public abstract class AbstractTransactionAnnotationParser
implements TransactionAnnotationParser,
Serializable {
    protected TransactionAttribute parseTransactionAnnotation(AnnotationAttributes attributes) {
        RuleBasedTransactionAttribute rbta = new RuleBasedTransactionAttribute();
        Propagation propagation = (Propagation)attributes.getEnum("propagation");
        rbta.setPropagationBehavior(propagation.value());
        Isolation isolation = (Isolation)attributes.getEnum("isolation");
        rbta.setIsolationLevel(isolation.value());
        rbta.setTimeout(attributes.getNumber("timeout").intValue());
        rbta.setReadOnly(attributes.getBoolean("readOnly"));
        rbta.setQualifier(attributes.getString("value"));
        ArrayList<Object> rollbackRules = new ArrayList<Object>();
        for (Class clazz : attributes.getClassArray("rollbackFor")) {
            rollbackRules.add(new RollbackRuleAttribute(clazz));
        }
        for (String string : attributes.getStringArray("rollbackForClassName")) {
            rollbackRules.add(new RollbackRuleAttribute(string));
        }
        for (Class clazz : attributes.getClassArray("noRollbackFor")) {
            rollbackRules.add(new NoRollbackRuleAttribute(clazz));
        }
        for (String string : attributes.getStringArray("noRollbackForClassName")) {
            rollbackRules.add(new NoRollbackRuleAttribute(string));
        }
        rbta.setRollbackRules(rollbackRules);
        return rbta;
    }
}

