/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.transaction.support.attributesource;

import com.jxdinfo.hussar.support.transaction.support.attributesource.AbstractFallbackTransactionAttributeSource;
import com.jxdinfo.hussar.support.transaction.support.attributesource.parse.AbstractTransactionAnnotationParser;
import com.jxdinfo.hussar.support.transaction.support.attributesource.parse.HussarTransactionAnnotationParser;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.springframework.transaction.annotation.TransactionAnnotationParser;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.util.Assert;

public class HussarAnnotationTransactionAttributeSource
extends AbstractFallbackTransactionAttributeSource
implements Serializable {
    private static final long serialVersionUID = -6872368084745884071L;
    private final boolean publicMethodsOnly;
    private final Set<AbstractTransactionAnnotationParser> annotationParsers;

    public HussarAnnotationTransactionAttributeSource(boolean publicMethodsOnly) {
        this.publicMethodsOnly = publicMethodsOnly;
        this.annotationParsers = Collections.singleton(new HussarTransactionAnnotationParser());
    }

    public HussarAnnotationTransactionAttributeSource(AbstractTransactionAnnotationParser annotationParser) {
        this.publicMethodsOnly = true;
        Assert.notNull((Object)annotationParser, (String)"TransactionAnnotationParser must not be null");
        this.annotationParsers = Collections.singleton(annotationParser);
    }

    public HussarAnnotationTransactionAttributeSource(Set<AbstractTransactionAnnotationParser> annotationParsers) {
        this.publicMethodsOnly = true;
        Assert.notEmpty(annotationParsers, (String)"At least one TransactionAnnotationParser needs to be specified");
        this.annotationParsers = annotationParsers;
    }

    public HussarAnnotationTransactionAttributeSource(boolean publicMethodsOnly, Set<AbstractTransactionAnnotationParser> annotationParsers) {
        this.publicMethodsOnly = publicMethodsOnly;
        Assert.notEmpty(annotationParsers, (String)"At least one TransactionAnnotationParser needs to be specified");
        this.annotationParsers = annotationParsers;
    }

    public HussarAnnotationTransactionAttributeSource(AbstractTransactionAnnotationParser ... annotationParsers) {
        this.publicMethodsOnly = true;
        Assert.notEmpty((Object[])annotationParsers, (String)"At least one TransactionAnnotationParser needs to be specified");
        this.annotationParsers = new LinkedHashSet<AbstractTransactionAnnotationParser>(Arrays.asList(annotationParsers));
    }

    public boolean isCandidateClass(Class<?> targetClass) {
        for (TransactionAnnotationParser transactionAnnotationParser : this.annotationParsers) {
            if (!transactionAnnotationParser.isCandidateClass(targetClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected TransactionAttribute findTransactionAttribute(Class<?> clazz) {
        return this.determineTransactionAttribute(clazz);
    }

    @Override
    protected TransactionAttribute findTransactionAttribute(Method method) {
        return this.determineTransactionAttribute(method);
    }

    @Nullable
    protected TransactionAttribute determineTransactionAttribute(AnnotatedElement element) {
        for (TransactionAnnotationParser transactionAnnotationParser : this.annotationParsers) {
            TransactionAttribute attr = transactionAnnotationParser.parseTransactionAnnotation(element);
            if (attr == null) continue;
            return attr;
        }
        return null;
    }

    @Override
    protected boolean allowPublicMethodsOnly() {
        return this.publicMethodsOnly;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HussarAnnotationTransactionAttributeSource)) {
            return false;
        }
        HussarAnnotationTransactionAttributeSource otherTas = (HussarAnnotationTransactionAttributeSource)other;
        return this.annotationParsers.equals(otherTas.annotationParsers) && this.publicMethodsOnly == otherTas.publicMethodsOnly;
    }

    public int hashCode() {
        return this.annotationParsers.hashCode();
    }
}

