/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.datasource.DataSourceUtil;
import com.jxdinfo.hussar.transaction.plugin.datasource.AbstractHussarTransactionManager;
import com.jxdinfo.hussar.transaction.plugin.datasource.DefaultHussarTransactionStatus;
import com.jxdinfo.hussar.transaction.plugin.datasource.properties.HussarTransactionProperties;
import com.jxdinfo.hussar.transaction.plugin.datasource.utils.TransactionUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.JdbcTransactionObjectSupport;
import org.springframework.lang.Nullable;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.ResourceTransactionManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionSynchronizationUtils;
import org.springframework.util.Assert;

public class HussarDataSourceTransactionManager
extends AbstractHussarTransactionManager
implements ResourceTransactionManager,
InitializingBean {
    private HussarTransactionProperties hussarTransactionProperties;
    @Nullable
    private DataSource dataSource;
    private boolean enforceReadOnly = false;

    public HussarDataSourceTransactionManager() {
        this.setNestedTransactionAllowed(true);
    }

    public HussarDataSourceTransactionManager(@Nullable DataSource dataSource) {
        this();
        this.setDataSource(dataSource);
        this.afterPropertiesSet();
    }

    protected DataSource obtainDataSource() {
        DataSource dataSource = this.getDataSource();
        Assert.state((dataSource != null ? 1 : 0) != 0, (String)"No DataSource set");
        return dataSource;
    }

    @Override
    protected boolean isExistingTransaction(Object transaction) {
        DataSourceTransactionObject txObject = (DataSourceTransactionObject)((Object)transaction);
        return txObject.hasConnectionHolder() && txObject.getConnectionHolder().isTransactionActive();
    }

    @Override
    protected Object doGetTransaction() {
        DataSourceTransactionObject txObject = new DataSourceTransactionObject(this.obtainDataSource());
        txObject.setSavepointAllowed(this.isNestedTransactionAllowed());
        ConnectionHolder conHolder = (ConnectionHolder)TransactionSynchronizationManager.getResource((Object)this.obtainDataSource());
        txObject.setConnectionHolder(conHolder, false);
        return txObject;
    }

    @Override
    protected Object doGetTransaction(TransactionDefinition definition) throws TransactionException {
        DataSourceTransactionObject transaction = (DataSourceTransactionObject)((Object)this.doGetTransaction());
        Map resourceMap = TransactionSynchronizationManager.getResourceMap();
        boolean hasConnectionHolder = transaction.hasConnectionHolder();
        if (HussarUtils.isNotEmpty((Object)resourceMap) && !hasConnectionHolder) {
            boolean newSynchronization = this.getTransactionSynchronization() != 2;
            boolean debugEnabled = this.logger.isDebugEnabled();
            DefaultHussarTransactionStatus status = this.newTransactionStatus(definition, (Object)transaction, false, newSynchronization, debugEnabled, null);
            this.doBegin((Object)transaction, definition);
            this.prepareSynchronization(status, definition);
            return transaction;
        }
        return transaction;
    }

    @Override
    protected void doBegin(Object transaction, TransactionDefinition definition) {
        DataSourceTransactionObject txObject = (DataSourceTransactionObject)((Object)transaction);
        Connection con = null;
        try {
            if (!txObject.hasConnectionHolder() || txObject.getConnectionHolder().isSynchronizedWithTransaction()) {
                Connection newCon = this.obtainDataSource().getConnection();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Acquired Connection [" + newCon + "] for JDBC transaction"));
                }
                txObject.setConnectionHolder(new ConnectionHolder(newCon), true);
            }
            txObject.getConnectionHolder().setSynchronizedWithTransaction(true);
            con = txObject.getConnectionHolder().getConnection();
            Integer previousIsolationLevel = HussarUtils.isNotEmpty((Object)this.hussarTransactionProperties) && this.hussarTransactionProperties.isSqlserverIsolation() ? TransactionUtils.prepareConnectionForTransaction(txObject.getDataSource(), con, definition) : DataSourceUtils.prepareConnectionForTransaction((Connection)con, (TransactionDefinition)definition);
            txObject.setPreviousIsolationLevel(previousIsolationLevel);
            txObject.setReadOnly(definition.isReadOnly());
            if (con.getAutoCommit()) {
                txObject.setMustRestoreAutoCommit(true);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Switching JDBC Connection [" + con + "] to manual commit"));
                }
                con.setAutoCommit(false);
            }
            this.prepareTransactionalConnection(con, definition);
            txObject.getConnectionHolder().setTransactionActive(true);
            int timeout = this.determineTimeout(definition);
            if (timeout != -1) {
                txObject.getConnectionHolder().setTimeoutInSeconds(timeout);
            }
            if (txObject.isNewConnectionHolder()) {
                TransactionSynchronizationManager.bindResource((Object)this.obtainDataSource(), (Object)txObject.getConnectionHolder());
            }
        }
        catch (Throwable ex) {
            if (txObject.isNewConnectionHolder()) {
                DataSourceUtils.releaseConnection(con, (DataSource)this.obtainDataSource());
                txObject.setConnectionHolder(null, false);
            }
            throw new CannotCreateTransactionException("Could not open JDBC Connection for transaction", ex);
        }
    }

    @Override
    protected Object doSuspend(Object transaction) {
        DataSourceTransactionObject txObject = (DataSourceTransactionObject)((Object)transaction);
        txObject.setConnectionHolder(null);
        return TransactionSynchronizationManager.unbindResource((Object)this.obtainDataSource());
    }

    @Override
    protected void doResume(@Nullable Object transaction, Object suspendedResources) {
        TransactionSynchronizationManager.bindResource((Object)this.obtainDataSource(), (Object)suspendedResources);
    }

    @Override
    protected void doCommit(DefaultHussarTransactionStatus status) {
        DataSourceTransactionObject txObject = (DataSourceTransactionObject)((Object)status.getTransaction());
        if (txObject.isNewConnectionHolder()) {
            Connection con = txObject.getConnectionHolder().getConnection();
            if (status.isDebug()) {
                this.logger.debug((Object)("Committing JDBC transaction on Connection [" + con + "]"));
            }
            try {
                con.commit();
            }
            catch (SQLException ex) {
                throw new TransactionSystemException("Could not commit JDBC transaction", (Throwable)ex);
            }
        }
    }

    @Override
    protected void doRollback(DefaultHussarTransactionStatus status) {
        DataSourceTransactionObject txObject = (DataSourceTransactionObject)((Object)status.getTransaction());
        if (txObject.isNewConnectionHolder()) {
            Connection con = txObject.getConnectionHolder().getConnection();
            if (status.isDebug()) {
                this.logger.debug((Object)("Rolling back JDBC transaction on Connection [" + con + "]"));
            }
            try {
                con.rollback();
            }
            catch (SQLException ex) {
                throw new TransactionSystemException("Could not roll back JDBC transaction", (Throwable)ex);
            }
        }
    }

    @Override
    protected void doSetRollbackOnly(DefaultHussarTransactionStatus status) {
        DataSourceTransactionObject txObject = (DataSourceTransactionObject)((Object)status.getTransaction());
        if (status.isDebug()) {
            this.logger.debug((Object)("Setting JDBC transaction [" + txObject.getConnectionHolder().getConnection() + "] rollback-only"));
        }
        txObject.setRollbackOnly();
    }

    private void doCleanTransaction(Object transaction) {
    }

    @Override
    protected void doCleanupAfterCompletion(Object transaction) {
        DataSourceTransactionObject txObject = (DataSourceTransactionObject)((Object)transaction);
        if (txObject.isNewConnectionHolder()) {
            TransactionSynchronizationManager.unbindResource((Object)txObject.getDataSource());
        }
        Connection con = txObject.getConnectionHolder().getConnection();
        try {
            if (txObject.isMustRestoreAutoCommit()) {
                con.setAutoCommit(true);
            }
            DataSourceUtils.resetConnectionAfterTransaction((Connection)con, (Integer)txObject.getPreviousIsolationLevel(), (boolean)txObject.isReadOnly());
        }
        catch (Throwable ex) {
            this.logger.debug((Object)"Could not reset JDBC Connection after transaction", ex);
        }
        if (txObject.isNewConnectionHolder()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Releasing JDBC Connection [" + con + "] after transaction"));
            }
            if (txObject.isNewConnectionHolder()) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)txObject.getDataSource());
            }
        }
        txObject.getConnectionHolder().clear();
    }

    protected void prepareTransactionalConnection(Connection con, TransactionDefinition definition) throws SQLException {
        if (this.isEnforceReadOnly() && definition.isReadOnly()) {
            try (Statement stmt = con.createStatement();){
                stmt.executeUpdate("SET TRANSACTION READ ONLY");
            }
        }
    }

    public Object getResourceFactory() {
        return this.obtainDataSource();
    }

    public void afterPropertiesSet() {
        if (this.getDataSource() == null) {
            throw new IllegalArgumentException("Property 'dataSource' is required");
        }
    }

    @Nullable
    public DataSource getDataSource() {
        return DataSourceUtil.getRealDataSource((DataSource)this.dataSource);
    }

    public void setDataSource(@Nullable DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public boolean isEnforceReadOnly() {
        return this.enforceReadOnly;
    }

    public void setEnforceReadOnly(boolean enforceReadOnly) {
        this.enforceReadOnly = enforceReadOnly;
    }

    public HussarTransactionProperties getHussarTransactionProperties() {
        return this.hussarTransactionProperties;
    }

    public void setHussarTransactionProperties(HussarTransactionProperties hussarTransactionProperties) {
        this.hussarTransactionProperties = hussarTransactionProperties;
    }

    private static class DataSourceTransactionObject
    extends JdbcTransactionObjectSupport {
        private boolean newConnectionHolder;
        private boolean mustRestoreAutoCommit;
        private DataSource dataSource;

        public DataSourceTransactionObject(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        public void setConnectionHolder(@Nullable ConnectionHolder connectionHolder, boolean newConnectionHolder) {
            super.setConnectionHolder(connectionHolder);
            this.newConnectionHolder = newConnectionHolder;
        }

        public boolean isNewConnectionHolder() {
            return this.newConnectionHolder;
        }

        public void setMustRestoreAutoCommit(boolean mustRestoreAutoCommit) {
            this.mustRestoreAutoCommit = mustRestoreAutoCommit;
        }

        public boolean isMustRestoreAutoCommit() {
            return this.mustRestoreAutoCommit;
        }

        public void setRollbackOnly() {
            this.getConnectionHolder().setRollbackOnly();
        }

        public DataSource getDataSource() {
            return this.dataSource;
        }

        public void setDataSource(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        public boolean isRollbackOnly() {
            return this.getConnectionHolder().isRollbackOnly();
        }

        public void flush() {
            if (TransactionSynchronizationManager.isSynchronizationActive()) {
                TransactionSynchronizationUtils.triggerFlush();
            }
        }
    }
}

