/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.transaction.plugin.datasource.utils;

import com.alibaba.druid.DbType;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.util.JdbcUtils;
import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.lang.Nullable;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.util.Assert;

public class TransactionUtils {
    private static final Log logger = LogFactory.getLog(TransactionUtils.class);

    public static Integer prepareConnectionForTransaction(DataSource dataSource, Connection con, @Nullable TransactionDefinition definition) throws SQLException {
        Assert.notNull((Object)con, (String)"No Connection specified");
        boolean debugEnabled = logger.isDebugEnabled();
        if (definition != null && definition.isReadOnly()) {
            try {
                if (debugEnabled) {
                    logger.debug((Object)("Setting JDBC Connection [" + con + "] read-only"));
                }
                con.setReadOnly(true);
            }
            catch (RuntimeException | SQLException ex) {
                for (Throwable exToCheck = ex; exToCheck != null; exToCheck = exToCheck.getCause()) {
                    if (!exToCheck.getClass().getSimpleName().contains("Timeout")) continue;
                    throw ex;
                }
                logger.debug((Object)"Could not set JDBC Connection read-only", (Throwable)ex);
            }
        }
        Integer previousIsolationLevel = null;
        if (HussarUtils.isEmpty((Object)definition)) {
            return previousIsolationLevel;
        }
        boolean sqlserver = TransactionUtils.isSqlserver(dataSource);
        int adapterIsolation = definition.getIsolationLevel();
        if (sqlserver && definition.getIsolationLevel() == -1) {
            adapterIsolation = 1;
        }
        if (adapterIsolation != -1) {
            int currentIsolation;
            if (debugEnabled) {
                logger.debug((Object)("Changing isolation level of JDBC Connection [" + con + "] to " + definition.getIsolationLevel()));
            }
            if ((currentIsolation = con.getTransactionIsolation()) != adapterIsolation) {
                previousIsolationLevel = currentIsolation;
                con.setTransactionIsolation(adapterIsolation);
            }
        }
        return previousIsolationLevel;
    }

    public static String getUrlByDatasource(DataSource dataSource) {
        if (HussarUtils.isEmpty((Object)dataSource)) {
            return null;
        }
        if (dataSource instanceof ItemDataSource) {
            ItemDataSource itemDataSource = (ItemDataSource)dataSource;
            return itemDataSource.getUrl();
        }
        if (dataSource instanceof DruidDataSource) {
            DruidDataSource druidDataSource = (DruidDataSource)dataSource;
            return druidDataSource.getUrl();
        }
        return null;
    }

    public static String getDriverNameByDatasource(DataSource dataSource) {
        if (HussarUtils.isEmpty((Object)dataSource)) {
            return null;
        }
        if (dataSource instanceof ItemDataSource) {
            ItemDataSource itemDataSource = (ItemDataSource)dataSource;
            return itemDataSource.getDriverClassName();
        }
        if (dataSource instanceof DruidDataSource) {
            DruidDataSource druidDataSource = (DruidDataSource)dataSource;
            return druidDataSource.getDriverClassName();
        }
        return null;
    }

    public static boolean isSqlserver(DataSource dataSource) {
        if (HussarUtils.isEmpty((Object)dataSource)) {
            return false;
        }
        String driverNameByDatasource = TransactionUtils.getDriverNameByDatasource(dataSource);
        String urlByDatasource = TransactionUtils.getUrlByDatasource(dataSource);
        DbType dbTypeRaw = JdbcUtils.getDbTypeRaw((String)urlByDatasource, (String)driverNameByDatasource);
        return !HussarUtils.isEmpty((Object)dbTypeRaw) && dbTypeRaw.equals((Object)DbType.sqlserver);
    }
}

