/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.plugin.jwt;

import com.jxdinfo.hussar.support.security.core.SecurityManager;
import com.jxdinfo.hussar.support.security.core.exception.SecurityTokenException;
import com.jxdinfo.hussar.support.security.core.temp.SecurityTempInterface;
import com.jxdinfo.hussar.support.security.core.util.SecurityFoxUtil;
import com.jxdinfo.hussar.support.security.plugin.jwt.SecurityJwtUtil;

public class SecurityTempForJwt
implements SecurityTempInterface {
    public String createToken(Object value, long timeout) {
        String token = SecurityJwtUtil.createToken(value, timeout, this.getJwtSecretKey());
        return token;
    }

    public Object parseToken(String token) {
        Object value = SecurityJwtUtil.getValue(token, this.getJwtSecretKey());
        return value;
    }

    public long getTimeout(String token) {
        long timeout = SecurityJwtUtil.getTimeout(token, this.getJwtSecretKey());
        return timeout;
    }

    public void deleteToken(String token) {
        throw new SecurityTokenException("jwt cannot delete token");
    }

    public String getJwtSecretKey() {
        String jwtSecretKey = SecurityManager.getConfig().getJwtSecretKey();
        if (SecurityFoxUtil.isEmpty((Object)jwtSecretKey)) {
            throw new SecurityTokenException("\u8bf7\u914d\u7f6e\uff1ajwtSecretKey");
        }
        return jwtSecretKey;
    }
}

