/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.service.impl;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.IResultCode;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.crypto.properties.HussarEncryptProperties;
import com.jxdinfo.hussar.platform.core.support.service.AuthSecurityUserDetailService;
import com.jxdinfo.hussar.platform.core.support.service.dto.OpenSafeDTO;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.security.core.properties.HussarCheckSafeProperties;
import com.jxdinfo.hussar.support.security.core.stp.SecurityUtil;
import com.jxdinfo.hussar.support.security.service.CheckSafeService;
import com.jxdinfo.hussar.support.security.service.PasswordEncryptService;
import javax.annotation.Resource;

public class CheckSafeServiceImpl
implements CheckSafeService {
    @Resource
    private HussarEncryptProperties hussarEncryptProperties;
    @Resource
    private HussarCheckSafeProperties hussarCheckSafeProperties;
    @Resource
    private AuthSecurityUserDetailService authSecurityUserDetailService;
    @Resource
    private PasswordEncryptService passwordEncryptService;

    @Override
    public ApiResponse<?> openSafe(OpenSafeDTO openSafeDTO, String clientId) {
        Boolean isValid;
        if (HussarUtils.isEmpty((Object)openSafeDTO) || HussarUtils.isEmpty((Object)openSafeDTO.getPassword())) {
            throw new HussarException("\u8fdb\u884c\u4e8c\u6b21\u8ba4\u8bc1\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String password = openSafeDTO.getPassword();
        if (this.hussarEncryptProperties.isEnablePwEncryption()) {
            password = this.passwordEncryptService.decrypt(password);
        }
        if (!(isValid = this.authSecurityUserDetailService.checkUserPassword(password)).booleanValue()) {
            throw new HussarException("\u5bc6\u7801\u9519\u8bef\uff0c\u4e8c\u6b21\u8ba4\u8bc1\u5931\u8d25");
        }
        SecurityUtil.openSafe((long)this.hussarCheckSafeProperties.getTimeOut());
        return ApiResponse.success((IResultCode)ResultCode.SUCCESS, (String)ResultCode.SUCCESS.getMessage());
    }
}

