/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.secure.riskprotect.filter;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class ReferCorsFilter
implements Filter {
    private final Logger logger = LoggerFactory.getLogger(ReferCorsFilter.class);
    private List<String> allowedOrigins;
    private List<String> allowedMethods;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String refer = request.getHeader("Referer");
        Boolean isCors = false;
        if (HussarUtils.isNotEmpty((Object)refer)) {
            try {
                String method = request.getMethod();
                if (HussarUtils.isNotEmpty(this.allowedMethods) && HussarUtils.isNotEmpty((Object)method) && !this.allowedMethods.contains("*")) {
                    Optional<String> optional = this.allowedMethods.stream().filter(allowedMethod -> allowedMethod.equalsIgnoreCase(method)).findFirst();
                    isCors = !optional.isPresent();
                }
                if (!isCors.booleanValue() && HussarUtils.isNotEmpty(this.allowedOrigins)) {
                    String referBaseUrl;
                    UriComponents uriComponents = UriComponentsBuilder.fromOriginHeader((String)refer).build();
                    String string = referBaseUrl = HussarUtils.isNotBlank((CharSequence)uriComponents.toUriString()) ? uriComponents.toUriString() : refer;
                    if (!this.allowedOrigins.contains("*")) {
                        Optional<String> optional = this.allowedOrigins.stream().filter(allowedOrigin -> allowedOrigin.equals(referBaseUrl)).findFirst();
                        isCors = !optional.isPresent();
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("\u901a\u8fc7\u8bf7\u6c42\u5934refer\u5224\u65ad\u662f\u5426\u8de8\u57df\u5931\u8d25, refer = {}", (Object)refer, (Object)e);
            }
        }
        if (isCors.booleanValue()) {
            response.setStatus(403);
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.write("Request header refer not valid, Invalid CORS request".getBytes(StandardCharsets.UTF_8));
        } else {
            chain.doFilter(servletRequest, servletResponse);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public List<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public void setAllowedOrigins(List<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    public List<String> getAllowedMethods() {
        return this.allowedMethods;
    }

    public void setAllowedMethods(List<String> allowedMethods) {
        this.allowedMethods = allowedMethods;
    }
}

