/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.secure.riskprotect.config;

import com.jxdinfo.hussar.support.secure.riskprotect.filter.ReferCorsFilter;
import com.jxdinfo.hussar.support.secure.riskprotect.properties.CorsProperties;
import java.util.Arrays;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.CorsRegistration;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnProperty(prefix="hussar.cors", name={"enabled"}, havingValue="true")
public class CorsAutoConfiguration
implements WebMvcConfigurer {
    @Autowired
    private CorsProperties properties;

    public void addCorsMappings(CorsRegistry registry) {
        CorsRegistration corsRegistration = registry.addMapping(this.properties.getPathPattern());
        corsRegistration.allowedOrigins(this.properties.getAllowedOrigins()).allowedHeaders(this.properties.getAllowedHeaders()).maxAge(this.properties.getMaxAge().longValue()).allowCredentials(this.properties.getAllowCredentials().booleanValue());
        if (this.properties.getAllowedMethods() != null) {
            corsRegistration.allowedMethods(this.properties.getAllowedMethods());
        }
        if (this.properties.getExposedHeaders() != null) {
            corsRegistration.exposedHeaders(this.properties.getExposedHeaders());
        }
    }

    @Bean
    @ConditionalOnProperty(prefix="hussar.cors", name={"refer-cors-enabled"}, havingValue="true", matchIfMissing=true)
    public FilterRegistrationBean<ReferCorsFilter> referCorsFilterRegistration() {
        ReferCorsFilter referCorsFilter = new ReferCorsFilter();
        referCorsFilter.setAllowedOrigins(Arrays.asList(this.properties.getAllowedOrigins()));
        referCorsFilter.setAllowedMethods(Arrays.asList(this.properties.getAllowedMethods()));
        FilterRegistrationBean registration = new FilterRegistrationBean((Filter)referCorsFilter, new ServletRegistrationBean[0]);
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setOrder(-2147483647);
        return registration;
    }
}

