/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.secure.riskprotect.filter;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IpUtils;
import com.jxdinfo.hussar.platform.core.utils.LocaleMessageUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.secure.riskprotect.properties.SecureRiskProtectProperties;
import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class ActuatorFilter
implements Filter {
    private SecureRiskProtectProperties secureRiskProtectProperties;

    public ActuatorFilter(SecureRiskProtectProperties secureRiskProtectProperties) {
        this.secureRiskProtectProperties = secureRiskProtectProperties;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String path = httpServletRequest.getRequestURI();
        if (path.startsWith("/actuator") && this.secureRiskProtectProperties.getActuatorAccessCheck().booleanValue()) {
            List<SecureRiskProtectProperties.IpSegment> ipSegments;
            String requestIp = IpUtils.getIp((HttpServletRequest)httpServletRequest);
            if (HussarUtils.isBlank((CharSequence)requestIp)) {
                throw new HussarException(LocaleMessageUtils.getMessage((String)"ACTUATOR_OBTAIN_REQUEST_IP_ERROR"));
            }
            List<String> ips = this.secureRiskProtectProperties.getActuatorAccessIps();
            if (HussarUtils.isAllEmpty((Object[])new Object[]{ips, ipSegments = this.secureRiskProtectProperties.getActuatorAccessIpSegments()})) {
                throw new HussarException(LocaleMessageUtils.getMessage((String)"ACTUATOR_NOT_CONFIGURED"));
            }
            Boolean valid = false;
            if (ips.contains(requestIp)) {
                valid = true;
            }
            if (!valid.booleanValue() && HussarUtils.isNotEmpty(ipSegments)) {
                Long ipValue = IpUtils.convertStrIpToLong((String)requestIp);
                valid = ipSegments.stream().anyMatch(ipSegment -> {
                    try {
                        Long start = IpUtils.convertStrIpToLong((String)ipSegment.getStartIp());
                        Long end = IpUtils.convertStrIpToLong((String)ipSegment.getEndIp());
                        return ipValue >= start && ipValue <= end;
                    }
                    catch (Exception e) {
                        throw new HussarException(LocaleMessageUtils.getMessage((String)"ACTUATOR_CONFIGURED_IP_TYPE_CONVERSION_FAILED"));
                    }
                });
            }
            if (!valid.booleanValue()) {
                throw new HussarException(LocaleMessageUtils.getMessage((String)"ACTUATOR_REQUEST_IP_NOT_IN_WHITELIST"));
            }
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

