/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.secure.riskprotect.interceptor;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.secure.riskprotect.properties.SecureRiskProtectProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.scripting.xmltags.DynamicContext;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class QueryUseLikeHandleInterceptor
implements Interceptor {
    private static final ObjectFactory DEFAULT_OBJECT_FACTORY = new DefaultObjectFactory();
    private static final ObjectWrapperFactory DEFAULT_OBJECT_WRAPPER_FACTORY = new DefaultObjectWrapperFactory();
    private static final ReflectorFactory DEFAULT_OBJECT_REFLECTOR_FACTORY = new DefaultReflectorFactory();
    private static final String ROOT_SQL_NODE = "sqlSource.rootSqlNode";
    private static final String KEYWORD_LIKE = "like";
    private static final String ESCAPE_STATEMENT = "escape '|'";
    private static final Character ESCAPE_SYMBOL = Character.valueOf('|');
    private static final Pattern REGEX_LIKE_PATTERN = Pattern.compile("[^\\s]+[\\s]+\\bLIKE\\b[^#]*#\\{[^}]*}", 2);
    private static final Pattern SPECIAL_WORD_PATTERN = Pattern.compile("[%_]", 2);
    private List<Character> symbols = CollectionUtil.ofImmutableList((Object[])new Character[]{Character.valueOf('%'), Character.valueOf('_')});
    private SecureRiskProtectProperties secureRiskProtectProperties;

    public QueryUseLikeHandleInterceptor(SecureRiskProtectProperties secureRiskProtectProperties) {
        this.secureRiskProtectProperties = secureRiskProtectProperties;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        BoundSql boundSql;
        if (!this.secureRiskProtectProperties.isEnableEscape()) {
            return invocation.proceed();
        }
        MappedStatement statement = (MappedStatement)invocation.getArgs()[0];
        MetaObject metaMappedStatement = MetaObject.forObject((Object)statement, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)DEFAULT_OBJECT_REFLECTOR_FACTORY);
        if (invocation.getArgs().length == 6) {
            boundSql = (BoundSql)invocation.getArgs()[5];
        } else {
            Object parameter = invocation.getArgs()[1];
            boundSql = statement.getBoundSql(parameter);
        }
        if (SqlCommandType.SELECT.equals((Object)statement.getSqlCommandType()) && metaMappedStatement.hasGetter(ROOT_SQL_NODE) && boundSql.getSql().toLowerCase().contains(KEYWORD_LIKE)) {
            SqlNode sqlNode = (SqlNode)metaMappedStatement.getValue(ROOT_SQL_NODE);
            String newSql = this.modifyBoundSql(statement.getConfiguration(), boundSql.getSql(), boundSql.getParameterObject(), sqlNode);
            if (HussarUtils.isNotEmpty((Object)newSql)) {
                BoundSql newBoundSql = new BoundSql(statement.getConfiguration(), newSql, boundSql.getParameterMappings(), boundSql.getParameterObject());
                MappedStatement newMappedStatement = this.buildNewMappedStatement(statement, new InnerSqlSource(newBoundSql));
                for (ParameterMapping mapping : boundSql.getParameterMappings()) {
                    String prop = mapping.getProperty();
                    if (!boundSql.hasAdditionalParameter(prop)) continue;
                    newBoundSql.setAdditionalParameter(prop, boundSql.getAdditionalParameter(prop));
                }
                Object[] queryArgs = invocation.getArgs();
                queryArgs[0] = newMappedStatement;
                if (queryArgs.length == 6) {
                    queryArgs[5] = newBoundSql;
                }
            }
        }
        return invocation.proceed();
    }

    private String modifyBoundSql(Configuration configuration, String originalSql, Object parameterObject, SqlNode sqlNode) {
        DynamicContext context = new DynamicContext(configuration, parameterObject);
        sqlNode.apply(context);
        String contextSql = context.getSql();
        return this.modifyLikeSql(originalSql, contextSql, parameterObject);
    }

    private String modifyLikeSql(String originalSql, String boundParamSql, Object parameterObject) {
        LambdaQueryWrapper obj;
        if (!(parameterObject instanceof Map)) {
            return "";
        }
        if (boundParamSql.toLowerCase().contains(ESCAPE_STATEMENT)) {
            return "";
        }
        Matcher matcher = REGEX_LIKE_PATTERN.matcher(boundParamSql);
        HashMap<String, String> replaceFiled = new HashMap<String, String>();
        while (matcher.find()) {
            String key;
            String regexMatcher = matcher.group();
            if (HussarUtils.isEmpty((Object)regexMatcher) || !HussarUtils.isNotEmpty((Object)(key = this.getParameterKey(regexMatcher)))) continue;
            replaceFiled.put(key, regexMatcher);
        }
        Map paramMab = (Map)parameterObject;
        if (HussarUtils.isNotEmpty((Object)paramMab) && (obj = (LambdaQueryWrapper)paramMab.get("ew")) != null) {
            for (Map.Entry entry : replaceFiled.entrySet()) {
                Object val = obj.getParamNameValuePairs().get(entry.getKey());
                if (!(val instanceof String)) continue;
                String parameter = val.toString();
                if (parameter.length() > 2 && parameter.startsWith("%") && parameter.endsWith("%") && SPECIAL_WORD_PATTERN.matcher(parameter = parameter.substring(1, parameter.length() - 1)).find()) {
                    parameter = this.resolveParameter(parameter);
                    originalSql = this.resolveSql(originalSql, (String)entry.getValue());
                }
                obj.getParamNameValuePairs().put(entry.getKey(), "%" + parameter + "%");
            }
        }
        return originalSql;
    }

    private String resolveParameter(String param) {
        StringBuffer sb = new StringBuffer();
        Character pre = Character.valueOf(' ');
        char[] cArray = param.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character cur = Character.valueOf(cArray[i]);
            if (this.symbols.contains(cur) && pre != ESCAPE_SYMBOL) {
                sb.append(ESCAPE_SYMBOL);
            }
            pre = cur;
            sb.append(cur);
        }
        return sb.toString();
    }

    private String resolveSql(String originalSql, String regexMatcher) {
        String paramLikeStr = regexMatcher.split("#")[0];
        int paramLikeIndex = originalSql.indexOf(paramLikeStr);
        int index = paramLikeIndex + paramLikeStr.length();
        while (originalSql.charAt(index) != '?') {
            ++index;
        }
        if (index < originalSql.length() && originalSql.charAt(index) == '?') {
            String pre = originalSql.substring(0, index);
            String back = originalSql.substring(index + 1);
            originalSql = pre + "? " + ESCAPE_STATEMENT + back;
        }
        return originalSql;
    }

    private String getParameterKey(String regexMatcher) {
        String[] strs;
        String key = "";
        String[] temp = regexMatcher.split("#");
        if (temp.length > 1 && (strs = (key = temp[1]).replace("{", "").replace("}", "").split("\\.")).length > 0) {
            key = strs[strs.length - 1];
        }
        return key.trim();
    }

    private MappedStatement buildNewMappedStatement(MappedStatement ms, SqlSource sqlSource) {
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), ms.getId(), sqlSource, ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        if (ms.getKeyProperties() != null && ms.getKeyProperties().length > 0) {
            builder.keyProperty(ms.getKeyProperties()[0]);
        }
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        builder.resultMaps(ms.getResultMaps());
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }

    class InnerSqlSource
    implements SqlSource {
        private BoundSql boundSql;

        public InnerSqlSource(BoundSql boundSql) {
            this.boundSql = boundSql;
        }

        public BoundSql getBoundSql(Object parameterObject) {
            return this.boundSql;
        }
    }
}

