/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.secure.encrypt.support.http;

import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class HussarHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private final Map<String, String[]> parameters = new HashMap<String, String[]>();
    private final Map<String, String> header = new HashMap<String, String>();

    public HussarHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    private HttpServletRequest _getHttpServletRequest() {
        return (HttpServletRequest)super.getRequest();
    }

    public String getHeader(String name) {
        if (HussarUtils.isEmpty(this.header) || !this.header.containsKey(name)) {
            return this._getHttpServletRequest().getHeader(name);
        }
        return this.header.get(name);
    }

    public Enumeration<String> getHeaderNames() {
        ArrayList<String> headerList = new ArrayList<String>();
        Enumeration headerNames = this._getHttpServletRequest().getHeaderNames();
        CollectionUtil.addAll(headerList, (Enumeration)headerNames);
        if (HussarUtils.isNotEmpty(this.header)) {
            headerList.addAll(this.header.keySet());
        }
        return Collections.enumeration(headerList);
    }

    public int getIntHeader(String name) {
        String header = this.getHeader(name);
        return header == null ? -1 : Integer.parseInt(header);
    }

    public void addParameters(Map<String, Object> map) {
        if (HussarUtils.isNotEmpty(map)) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                Object value = entry.getValue();
                if (HussarUtils.isEmpty((Object)value)) {
                    this.parameters.put(entry.getKey(), new String[0]);
                }
                String[] parameters = value instanceof String ? new String[]{entry.getValue().toString()} : new String[]{JsonUtil.toJson((Object)entry.getValue())};
                this.parameters.put(entry.getKey(), parameters);
            }
        }
    }

    public String getParameter(String name) {
        if (HussarUtils.isEmpty(this.parameters) || !this.parameters.containsKey(name)) {
            return this._getHttpServletRequest().getParameter(name);
        }
        Object[] parameterArr = this.parameters.get(name);
        if (HussarUtils.isNotEmpty((Object[])parameterArr) && parameterArr.length == 1) {
            return parameterArr[0];
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        Map parameterMap = this._getHttpServletRequest().getParameterMap();
        if (HussarUtils.isNotEmpty(this.parameters)) {
            this.parameters.putAll(parameterMap);
        }
        return this.parameters;
    }

    public Enumeration<String> getParameterNames() {
        ArrayList<String> parameterList = new ArrayList<String>();
        Enumeration parameterNames = this._getHttpServletRequest().getParameterNames();
        CollectionUtil.addAll(parameterList, (Enumeration)parameterNames);
        if (HussarUtils.isNotEmpty(this.parameters)) {
            parameterList.addAll(this.parameters.keySet());
        }
        return Collections.enumeration(parameterList);
    }

    public String[] getParameterValues(String name) {
        if (HussarUtils.isEmpty(this.parameters) || !this.parameters.containsKey(name)) {
            return this._getHttpServletRequest().getParameterValues(name);
        }
        Object[] parameterArr = this.parameters.get(name);
        if (HussarUtils.isNotEmpty((Object[])parameterArr) && parameterArr.length > 0) {
            return parameterArr;
        }
        return null;
    }
}

