/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.secure.encrypt.support.filter;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.exception.exceptionenum.ExceptionCodeEnum;
import com.jxdinfo.hussar.support.secure.encrypt.core.dto.SecurityEncryptDTO;
import com.jxdinfo.hussar.support.secure.encrypt.core.enums.EncryptExceptionEnum;
import com.jxdinfo.hussar.support.secure.encrypt.core.exception.HussarEncryptExecption;
import com.jxdinfo.hussar.support.secure.encrypt.properties.SecureEncryptProperties;
import com.jxdinfo.hussar.support.secure.encrypt.support.http.HussarHttpServletRequestWrapper;
import com.jxdinfo.hussar.support.secure.encrypt.utils.EncryptUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.web.servlet.filter.OrderedCharacterEncodingFilter;

public class HussarEncryptResolverFilter
extends OrderedCharacterEncodingFilter {
    private SecureEncryptProperties secureEncryptProperties;

    protected boolean shouldNotFilter(HttpServletRequest request) throws ServletException {
        return !EncryptUtils.enableEncrypt(request, this.secureEncryptProperties);
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            SecurityEncryptDTO securityEncryptDTO;
            String encoding = this.getEncoding();
            if (encoding != null) {
                if (this.isForceRequestEncoding() || request.getCharacterEncoding() == null) {
                    request.setCharacterEncoding(encoding);
                }
                if (this.isForceResponseEncoding()) {
                    response.setCharacterEncoding(encoding);
                }
            }
            if (HussarUtils.isEmpty((Object)(securityEncryptDTO = EncryptUtils.getSecurityEncryptDTOByRequest(request, this.secureEncryptProperties)))) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            byte[] bytes = EncryptUtils.doDecryptService(securityEncryptDTO, this.secureEncryptProperties);
            if (HussarUtils.isEmpty((Object)bytes)) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            String getData = new String(bytes, StandardCharsets.UTF_8);
            Map map = JsonUtil.toMap((String)getData);
            HussarHttpServletRequestWrapper requestWrapper = new HussarHttpServletRequestWrapper(request);
            requestWrapper.addParameters(map);
            filterChain.doFilter((ServletRequest)requestWrapper, (ServletResponse)response);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            if (e instanceof HussarEncryptExecption && "\u89e3\u5bc6\u7ec4\u4ef6\uff0c\u89e3\u5bc6\u53c2\u6570\u51fa\u73b0\u9519\u8bef".equals(e.getMessage())) {
                HussarException.throwBy((boolean)true, (Integer)ExceptionCodeEnum.ENCRYPT_DECRYPT_EXCEPTION.getCode(), (String)ExceptionCodeEnum.ENCRYPT_DECRYPT_EXCEPTION.getMessage());
            }
            HussarEncryptExecption.throwBy((boolean)true, (Integer)EncryptExceptionEnum.ENCRYPT_EXCEPTION.getExceptionCode(), (String)EncryptExceptionEnum.ENCRYPT_EXCEPTION.getMessage());
        }
    }

    public HussarEncryptResolverFilter(SecureEncryptProperties secureEncryptProperties) {
        this.secureEncryptProperties = secureEncryptProperties;
    }

    public SecureEncryptProperties getSecureEncryptProperties() {
        return this.secureEncryptProperties;
    }

    public void setSecureEncryptProperties(SecureEncryptProperties secureEncryptProperties) {
        this.secureEncryptProperties = secureEncryptProperties;
    }
}

