/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.secure.encrypt.support;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.secure.encrypt.core.dto.SecurityEncryptDTO;
import com.jxdinfo.hussar.support.secure.encrypt.core.enums.EncryptExceptionEnum;
import com.jxdinfo.hussar.support.secure.encrypt.properties.SecureEncryptProperties;
import com.jxdinfo.hussar.support.secure.encrypt.support.AbstractEncryptResolverAdvice;
import com.jxdinfo.hussar.support.secure.encrypt.utils.EncryptUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.lang.NonNull;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice;

@Order(value=1)
@ControllerAdvice
public class SecureDecryptRequestBodyAdvice
extends AbstractEncryptResolverAdvice
implements RequestBodyAdvice {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    protected SecureDecryptRequestBodyAdvice(SecureEncryptProperties properties) {
        super(properties);
    }

    public boolean supports(MethodParameter methodParameter, @NonNull Type targetType, @NonNull Class<? extends HttpMessageConverter<?>> converterType) {
        return this.getProperties().getPostEnabled() != false && this.isEncrypted();
    }

    public Object handleEmptyBody(Object body, @NonNull HttpInputMessage inputMessage, @NonNull MethodParameter parameter, @NonNull Type targetType, @NonNull Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    @NonNull
    public HttpInputMessage beforeBodyRead(HttpInputMessage inputMessage, @NonNull MethodParameter parameter, @NonNull Type targetType, @NonNull Class<? extends HttpMessageConverter<?>> converterType) throws IOException {
        HttpHeaders headers = inputMessage.getHeaders();
        if (!EncryptUtils.enableEncrypt(headers, this.getProperties())) {
            return inputMessage;
        }
        InputStream messageBody = inputMessage.getBody();
        if (messageBody.available() <= 0) {
            return inputMessage;
        }
        String requestBody = null;
        try {
            requestBody = StreamUtils.copyToString((InputStream)inputMessage.getBody(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
            HussarException.throwBy((boolean)true, (Integer)EncryptExceptionEnum.ENCRYPT_IOEXCEPTION.getExceptionCode(), (String)EncryptExceptionEnum.ENCRYPT_IOEXCEPTION.getMessage());
        }
        JSONObject json = JSONObject.parseObject((String)requestBody);
        String data = json.getString(this.getProperties().getData());
        String sign = json.getString(this.getProperties().getSign());
        String key = json.getString(this.getProperties().getKey());
        String iv = json.getString(this.getProperties().getIv());
        SecurityEncryptDTO securityEncryptDTO = new SecurityEncryptDTO();
        securityEncryptDTO.setSign(sign);
        securityEncryptDTO.setData(data);
        securityEncryptDTO.setKey(key);
        securityEncryptDTO.setIv(iv);
        securityEncryptDTO.setClientId(headers.getFirst("client-id"));
        return EncryptUtils.decryptPostData(securityEncryptDTO, this.getProperties(), inputMessage);
    }

    @NonNull
    public Object afterBodyRead(@NonNull Object body, @NonNull HttpInputMessage inputMessage, @NonNull MethodParameter parameter, @NonNull Type targetType, @NonNull Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }
}

