/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.secure.encrypt.support;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.secure.encrypt.properties.SecureEncryptProperties;
import com.jxdinfo.hussar.support.secure.encrypt.support.AbstractEncryptResolverAdvice;
import com.jxdinfo.hussar.support.secure.encrypt.utils.EncryptUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@Order(value=1)
@ControllerAdvice
public class SecureEncryptResponseBodyAdvice
extends AbstractEncryptResolverAdvice
implements ResponseBodyAdvice<Object> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    protected SecureEncryptResponseBodyAdvice(SecureEncryptProperties properties) {
        super(properties);
    }

    public boolean supports(MethodParameter returnType, @NonNull Class converterType) {
        return this.getProperties().getEnabled() != false && this.isEncrypted();
    }

    @Nullable
    public Object beforeBodyWrite(Object body, @NonNull MethodParameter returnType, @NonNull MediaType selectedContentType, @NonNull Class selectedConverterType, @NonNull ServerHttpRequest request, @NonNull ServerHttpResponse response) {
        HttpHeaders headers = request.getHeaders();
        if (HussarUtils.isEmpty((Object)body) || !EncryptUtils.enableEncrypt(headers, this.getProperties())) {
            return body;
        }
        response.getHeaders().set(this.getProperties().getHeaderEncrypt(), "1");
        return EncryptUtils.encryptData(headers.getFirst("client-id"), body, this.getProperties());
    }
}

