/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.secure.encrypt.utils;

import com.jxdinfo.hussar.encrypt.util.SM2Util;
import com.jxdinfo.hussar.encrypt.util.SM3Util;
import com.jxdinfo.hussar.encrypt.util.SM4Util;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.secure.encrypt.core.dto.SecurityEncryptDTO;
import com.jxdinfo.hussar.support.secure.encrypt.core.enums.EncryptExceptionEnum;
import com.jxdinfo.hussar.support.secure.encrypt.core.exception.HussarEncryptExecption;
import com.jxdinfo.hussar.support.secure.encrypt.properties.SecureEncryptProperties;
import com.jxdinfo.hussar.support.secure.encrypt.support.message.DecryptHttpInputMessage;
import com.jxdinfo.hussar.support.secure.encrypt.utils.SM4CbcUtil;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.ServletWebRequest;

public class EncryptUtils {
    public static void initSMKey() {
        String backedPriKey = (String)HussarFixedCacheUtil.get((String)"encrypt_cache", (Object)"encrypt_back_pri", String.class);
        String backedPubKey = (String)HussarFixedCacheUtil.get((String)"encrypt_cache", (Object)"encrypt_back_pub", String.class);
        String frontPriKey = (String)HussarFixedCacheUtil.get((String)"encrypt_cache", (Object)"encrypt_front_pri", String.class);
        String frontPubKey = (String)HussarFixedCacheUtil.get((String)"encrypt_cache", (Object)"encrypt_front_pub", String.class);
        if (HussarUtils.isNotBlank((CharSequence)backedPriKey) && HussarUtils.isNotBlank((CharSequence)backedPubKey) && HussarUtils.isNotBlank((CharSequence)frontPriKey) && HussarUtils.isNotBlank((CharSequence)frontPubKey)) {
            return;
        }
        Map keyMapBackEnd = SM2Util.generateKeyPair();
        Map keyMapFronEnd = SM2Util.generateKeyPair();
        frontPubKey = (String)keyMapFronEnd.get("pubKey");
        backedPriKey = (String)keyMapBackEnd.get("priKey");
        backedPubKey = (String)keyMapBackEnd.get("pubKey");
        frontPriKey = (String)keyMapFronEnd.get("priKey");
        HussarFixedCacheUtil.put((String)"encrypt_cache", (Object)"encrypt_back_pri", (Object)backedPriKey);
        HussarFixedCacheUtil.put((String)"encrypt_cache", (Object)"encrypt_back_pub", (Object)backedPubKey);
        HussarFixedCacheUtil.put((String)"encrypt_cache", (Object)"encrypt_front_pri", (Object)frontPriKey);
        HussarFixedCacheUtil.put((String)"encrypt_cache", (Object)"encrypt_front_pub", (Object)frontPubKey);
    }

    public static Object encryptData(String clientId, Object body, SecureEncryptProperties secureEncryptProperties) {
        try {
            String frontPubKey = (String)HussarFixedCacheUtil.get((String)"encrypt_cache", (Object)"encrypt_front_pub", String.class);
            String backPriKey = (String)HussarFixedCacheUtil.get((String)"encrypt_cache", (Object)"encrypt_back_pri", String.class);
            HussarException.throwBy((boolean)HussarUtils.isAnyBlank((CharSequence[])new CharSequence[]{frontPubKey, backPriKey}), (Integer)EncryptExceptionEnum.ENCRYPT_KEY_NULL.getExceptionCode(), (String)EncryptExceptionEnum.ENCRYPT_KEY_NULL.getMessage());
            String sm4Key = SM4Util.getRandomKey();
            Boolean sm4UseCbc = secureEncryptProperties.getEnableEncryptCbcMode();
            String sm4Iv = sm4UseCbc != false ? SM4Util.getRandomKey() : "";
            String data = JsonUtil.toJson((Object)body);
            String encryptedData = sm4UseCbc != false ? SM4CbcUtil.encrypt(data, sm4Key, sm4Iv) : SM4Util.encrypt((String)data, (String)sm4Key);
            String key = SM2Util.encrypt((String)sm4Key, (String)frontPubKey);
            String iv = sm4UseCbc != false ? SM2Util.encrypt((String)sm4Iv, (String)frontPubKey) : "";
            String sign = "";
            if (secureEncryptProperties.getEnabledEncryptSign().booleanValue()) {
                String summary = SM3Util.digest((String)(sm4UseCbc != false ? encryptedData + key + iv : encryptedData + key));
                sign = SM2Util.sign((String)clientId, (String)backPriKey, (String)summary);
                HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)sign), (Integer)EncryptExceptionEnum.ENCRYPT_SIGN_EXCEPTION.getExceptionCode(), (String)EncryptExceptionEnum.ENCRYPT_SIGN_EXCEPTION.getMessage());
            }
            HashMap<String, String> json = new HashMap<String, String>(3);
            json.put(secureEncryptProperties.getData(), encryptedData);
            json.put(secureEncryptProperties.getSign(), sign);
            json.put(secureEncryptProperties.getKey(), key);
            if (sm4UseCbc.booleanValue()) {
                json.put(secureEncryptProperties.getIv(), iv);
            }
            return json;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HussarEncryptExecption("\u52a0\u5bc6\u7ec4\u4ef6\uff1a\u89e3\u5bc6\u65f6\u51fa\u73b0\u9519\u8bef");
        }
    }

    public static byte[] doDecryptService(SecurityEncryptDTO securityEncryptDTO, SecureEncryptProperties secureEncryptProperties) {
        byte[] realBodyBytes;
        if (HussarUtils.isEmpty((Object)securityEncryptDTO) || HussarUtils.isEmpty((Object)securityEncryptDTO.getData()) || HussarUtils.isEmpty((Object)securityEncryptDTO.getSign()) || HussarUtils.isEmpty((Object)securityEncryptDTO.getKey())) {
            return null;
        }
        try {
            String realBody;
            String data = securityEncryptDTO.getData();
            String sign = securityEncryptDTO.getSign();
            String key = securityEncryptDTO.getKey();
            String iv = securityEncryptDTO.getIv();
            String frontPubKey = (String)HussarFixedCacheUtil.get((String)"encrypt_cache", (Object)"encrypt_front_pub", String.class);
            String privateKeyBackend = (String)HussarFixedCacheUtil.get((String)"encrypt_cache", (Object)"encrypt_back_pri", String.class);
            HussarException.throwBy((boolean)HussarUtils.isAnyBlank((CharSequence[])new CharSequence[]{frontPubKey, privateKeyBackend}), (Integer)EncryptExceptionEnum.ENCRYPT_KEY_NULL.getExceptionCode(), (String)EncryptExceptionEnum.ENCRYPT_KEY_NULL.getMessage());
            Boolean sm4UseCbc = secureEncryptProperties.getEnableEncryptCbcMode();
            if (secureEncryptProperties.getEnabledEncryptSign().booleanValue()) {
                String summary = SM3Util.digest((String)(sm4UseCbc != false ? data + key + iv : data + key));
                boolean result = SM2Util.verifySign((String)securityEncryptDTO.getClientId(), (String)frontPubKey, (String)summary, (String)sign);
                HussarException.throwBy((!result ? 1 : 0) != 0, (Integer)EncryptExceptionEnum.ENCRYPT_SIGN_EXCEPTION.getExceptionCode(), (String)"\u6570\u636e\u5b8c\u6574\u6027\u88ab\u7834\u574f");
            }
            String realKey = SM2Util.decrypt((String)key, (String)privateKeyBackend);
            if (sm4UseCbc.booleanValue()) {
                String realIv = SM2Util.decrypt((String)iv, (String)privateKeyBackend);
                realBody = SM4CbcUtil.decrypt(data, realKey, realIv);
            } else {
                realBody = SM4Util.decrypt((String)data, (String)realKey);
            }
            if (realBody.startsWith("\"") && realBody.endsWith("\"")) {
                realBody = realBody.substring(1, realBody.length() - 1);
            }
            realBodyBytes = realBody.getBytes(StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HussarEncryptExecption("\u89e3\u5bc6\u7ec4\u4ef6\uff0c\u89e3\u5bc6\u53c2\u6570\u51fa\u73b0\u9519\u8bef");
        }
        return realBodyBytes;
    }

    public static <T> T decryptGetData(SecurityEncryptDTO securityEncryptDTO, SecureEncryptProperties secureEncryptProperties, Class<T> clz) {
        byte[] bytes = EncryptUtils.doDecryptService(securityEncryptDTO, secureEncryptProperties);
        if (HussarUtils.isEmpty((Object)bytes)) {
            return null;
        }
        return (T)JsonUtil.readValue((byte[])bytes, clz);
    }

    public static SecurityEncryptDTO getSecurityEncryptDTOByRequest(HttpServletRequest httpServletRequest, SecureEncryptProperties secureEncryptProperties) {
        SecurityEncryptDTO encryptDTO = new SecurityEncryptDTO();
        String dataParameter = httpServletRequest.getParameter(secureEncryptProperties.getData());
        String signParameter = httpServletRequest.getParameter(secureEncryptProperties.getSign());
        String ivParameter = httpServletRequest.getParameter(secureEncryptProperties.getIv());
        String keyParameter = httpServletRequest.getParameter(secureEncryptProperties.getKey());
        if (HussarUtils.isEmpty((Object)dataParameter) || HussarUtils.isEmpty((Object)ivParameter) || HussarUtils.isEmpty((Object)keyParameter)) {
            return null;
        }
        encryptDTO.setData(dataParameter);
        encryptDTO.setIv(ivParameter);
        encryptDTO.setSign(signParameter);
        encryptDTO.setKey(keyParameter);
        encryptDTO.setClientId(httpServletRequest.getHeader("client-id"));
        return encryptDTO;
    }

    public static <T> T decryptGetData(NativeWebRequest webRequest, SecureEncryptProperties secureEncryptProperties, Class<T> clz) {
        T t;
        try {
            String dataParameter = webRequest.getParameter(secureEncryptProperties.getData());
            String signParameter = webRequest.getParameter(secureEncryptProperties.getSign());
            String ivParameter = webRequest.getParameter(secureEncryptProperties.getIv());
            String keyParameter = webRequest.getParameter(secureEncryptProperties.getKey());
            if (HussarUtils.isEmpty((Object)dataParameter) || HussarUtils.isEmpty((Object)ivParameter) || HussarUtils.isEmpty((Object)keyParameter)) {
                return null;
            }
            SecurityEncryptDTO encryptDTO = new SecurityEncryptDTO();
            encryptDTO.setData(dataParameter);
            encryptDTO.setIv(ivParameter);
            encryptDTO.setSign(signParameter);
            encryptDTO.setKey(keyParameter);
            encryptDTO.setClientId(webRequest.getHeader("client-id"));
            t = EncryptUtils.decryptGetData(encryptDTO, secureEncryptProperties, clz);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HussarEncryptExecption("\u52a0\u5bc6\u7ec4\u4ef6\uff1aget\u8bf7\u6c42\u8fdb\u884c\u89e3\u5bc6\u51fa\u73b0\u9519\u8bef");
        }
        return t;
    }

    public static DecryptHttpInputMessage decryptPostData(SecurityEncryptDTO securityEncryptDTO, SecureEncryptProperties secureEncryptProperties, HttpInputMessage inputMessage) {
        byte[] bytes = EncryptUtils.doDecryptService(securityEncryptDTO, secureEncryptProperties);
        if (HussarUtils.isEmpty((Object)bytes)) {
            return null;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        return new DecryptHttpInputMessage(inputStream, inputMessage.getHeaders());
    }

    public static boolean enableEncrypt(HttpHeaders headers, SecureEncryptProperties properties) {
        if (HussarUtils.isEmpty((Object)headers)) {
            return false;
        }
        if (!headers.containsKey((Object)properties.getHeaderEncrypt())) {
            return false;
        }
        String headersFirst = headers.getFirst(properties.getHeaderEncrypt());
        if (HussarUtils.isEmpty((Object)headersFirst) || HussarUtils.equals((Object)headersFirst, (Object)"0")) {
            return false;
        }
        return HussarUtils.equals((Object)headersFirst, (Object)"1");
    }

    public static boolean validateEncryptByHeader(String headers) {
        if (HussarUtils.isEmpty((Object)headers) || HussarUtils.equals((Object)headers, (Object)"0")) {
            return false;
        }
        return HussarUtils.equals((Object)headers, (Object)"1");
    }

    public static NativeWebRequest getWebRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        Assert.state((boolean)(requestAttributes instanceof ServletRequestAttributes), (String)"No ServletRequestAttributes");
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)requestAttributes;
        return new ServletWebRequest(servletRequestAttributes.getRequest());
    }

    protected static boolean matchPath(String path, SecureEncryptProperties properties) {
        List<String> ignoreEncryptUrls = properties.getIgnoreEncryptUrls();
        if (HussarUtils.isEmpty(ignoreEncryptUrls)) {
            return true;
        }
        boolean flag = true;
        AntPathMatcher antPathMatcher = new AntPathMatcher();
        for (String ignoreEncryptUrl : ignoreEncryptUrls) {
            boolean match = antPathMatcher.match(ignoreEncryptUrl, path);
            if (!match) continue;
            flag = false;
            break;
        }
        return flag;
    }

    public static boolean enableEncrypt(NativeWebRequest webRequest, SecureEncryptProperties properties) {
        HttpServletRequest servletRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        return EncryptUtils.enableEncrypt(servletRequest, properties);
    }

    public static boolean enableEncrypt(HttpServletRequest servletRequest, SecureEncryptProperties properties) {
        String header = servletRequest.getHeader(properties.getHeaderEncrypt());
        boolean b = EncryptUtils.validateEncryptByHeader(header);
        return b && EncryptUtils.matchPath(servletRequest.getRequestURI(), properties);
    }

    public static void main(String[] args) {
        String sm4Key = SM4Util.getRandomKey();
        System.out.println("SM4Key= " + sm4Key);
        Map keyMapBackEnd = SM2Util.generateKeyPair();
        Map keyMapFronEnd = SM2Util.generateKeyPair();
        String frontPubKey = (String)keyMapFronEnd.get("pubKey");
        String backedPriKey = (String)keyMapBackEnd.get("priKey");
        String backedPubKey = (String)keyMapBackEnd.get("pubKey");
        String frontPriKey = (String)keyMapFronEnd.get("priKey");
        System.out.println("frontPubKey=" + frontPubKey);
        System.out.println("backedPriKey=" + backedPriKey);
        System.out.println("backedPubKey=" + backedPubKey);
        System.out.println("frontPriKey=" + frontPriKey);
    }
}

