/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.secure.encrypt.utils;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.encrypt.util.SM2Util;
import com.jxdinfo.hussar.encrypt.util.SM3Util;
import com.jxdinfo.hussar.encrypt.util.SM4Util;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.secure.encrypt.core.enums.EncryptExceptionEnum;
import com.jxdinfo.hussar.support.secure.encrypt.properties.SecureEncryptProperties;
import com.jxdinfo.hussar.support.secure.encrypt.support.message.DecryptHttpInputMessage;
import com.jxdinfo.hussar.support.secure.encrypt.utils.SM4CbcUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.util.StreamUtils;

public class EncryptUtils {
    public static void initSMKey() {
        String backedPriKey = (String)HussarCacheUtil.get((String)"encrypt_cache", (Object)"encrypt_back_pri", String.class);
        String backedPubKey = (String)HussarCacheUtil.get((String)"encrypt_cache", (Object)"encrypt_back_pub", String.class);
        String frontPriKey = (String)HussarCacheUtil.get((String)"encrypt_cache", (Object)"encrypt_front_pri", String.class);
        String frontPubKey = (String)HussarCacheUtil.get((String)"encrypt_cache", (Object)"encrypt_front_pub", String.class);
        if (HussarUtils.isNotBlank((CharSequence)backedPriKey) && HussarUtils.isNotBlank((CharSequence)backedPubKey) && HussarUtils.isNotBlank((CharSequence)frontPriKey) && HussarUtils.isNotBlank((CharSequence)frontPubKey)) {
            return;
        }
        Map keyMapBackEnd = SM2Util.generateKeyPair();
        Map keyMapFronEnd = SM2Util.generateKeyPair();
        frontPubKey = (String)keyMapFronEnd.get("pubKey");
        backedPriKey = (String)keyMapBackEnd.get("priKey");
        backedPubKey = (String)keyMapBackEnd.get("pubKey");
        frontPriKey = (String)keyMapFronEnd.get("priKey");
        HussarCacheUtil.put((String)"encrypt_cache", (Object)"encrypt_back_pri", (Object)backedPriKey);
        HussarCacheUtil.put((String)"encrypt_cache", (Object)"encrypt_back_pub", (Object)backedPubKey);
        HussarCacheUtil.put((String)"encrypt_cache", (Object)"encrypt_front_pri", (Object)frontPriKey);
        HussarCacheUtil.put((String)"encrypt_cache", (Object)"encrypt_front_pub", (Object)frontPubKey);
    }

    public static Object encryptData(String clientId, Object body, SecureEncryptProperties secureEncryptProperties) {
        String frontPubKey = (String)HussarCacheUtil.get((String)"encrypt_cache", (Object)"encrypt_front_pub", String.class);
        String backPriKey = (String)HussarCacheUtil.get((String)"encrypt_cache", (Object)"encrypt_back_pri", String.class);
        HussarException.throwBy((boolean)HussarUtils.isAnyBlank((CharSequence[])new CharSequence[]{frontPubKey, backPriKey}), (Integer)EncryptExceptionEnum.ENCRYPT_KEY_NULL.getExceptionCode(), (String)EncryptExceptionEnum.ENCRYPT_KEY_NULL.getMessage());
        String sm4Key = SM4Util.getRandomKey();
        Boolean sm4UseCbc = secureEncryptProperties.getEnableEncryptCbcMode();
        String sm4Iv = sm4UseCbc != false ? SM4Util.getRandomKey() : "";
        String data = JsonUtil.toJson((Object)body);
        String encryptedData = sm4UseCbc != false ? SM4CbcUtil.encrypt(data, sm4Key, sm4Iv) : SM4Util.encrypt((String)data, (String)sm4Key);
        String key = SM2Util.encrypt((String)sm4Key, (String)frontPubKey);
        String iv = sm4UseCbc != false ? SM2Util.encrypt((String)sm4Iv, (String)frontPubKey) : "";
        String sign = "";
        if (secureEncryptProperties.getEnabledEncryptSign().booleanValue()) {
            String summary = SM3Util.digest((String)(sm4UseCbc != false ? encryptedData + key + iv : encryptedData + key));
            sign = SM2Util.sign((String)clientId, (String)backPriKey, (String)summary);
            HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)sign), (Integer)EncryptExceptionEnum.ENCRYPT_SIGN_EXCEPTION.getExceptionCode(), (String)EncryptExceptionEnum.ENCRYPT_SIGN_EXCEPTION.getMessage());
        }
        HashMap<String, String> json = new HashMap<String, String>(3);
        json.put(secureEncryptProperties.getData(), encryptedData);
        json.put(secureEncryptProperties.getSign(), sign);
        json.put(secureEncryptProperties.getKey(), key);
        if (sm4UseCbc.booleanValue()) {
            json.put(secureEncryptProperties.getIv(), iv);
        }
        return json;
    }

    public static DecryptHttpInputMessage decryptData(String clientId, HttpInputMessage inputMessage, SecureEncryptProperties secureEncryptProperties) {
        String realBody;
        String requestBody = null;
        try {
            requestBody = StreamUtils.copyToString((InputStream)inputMessage.getBody(), (Charset)Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
            HussarException.throwBy((boolean)true, (Integer)EncryptExceptionEnum.ENCRYPT_IOEXCEPTION.getExceptionCode(), (String)EncryptExceptionEnum.ENCRYPT_IOEXCEPTION.getMessage());
        }
        JSONObject json = JSONObject.parseObject((String)requestBody);
        String data = json.getString(secureEncryptProperties.getData());
        String sign = json.getString(secureEncryptProperties.getSign());
        String key = json.getString(secureEncryptProperties.getKey());
        String iv = json.getString(secureEncryptProperties.getIv());
        String frontPubKey = (String)HussarCacheUtil.get((String)"encrypt_cache", (Object)"encrypt_front_pub", String.class);
        String privateKeyBackend = (String)HussarCacheUtil.get((String)"encrypt_cache", (Object)"encrypt_back_pri", String.class);
        HussarException.throwBy((boolean)HussarUtils.isAnyBlank((CharSequence[])new CharSequence[]{frontPubKey, privateKeyBackend}), (Integer)EncryptExceptionEnum.ENCRYPT_KEY_NULL.getExceptionCode(), (String)EncryptExceptionEnum.ENCRYPT_KEY_NULL.getMessage());
        Boolean sm4UseCbc = secureEncryptProperties.getEnableEncryptCbcMode();
        if (secureEncryptProperties.getEnabledEncryptSign().booleanValue()) {
            String summary = SM3Util.digest((String)(sm4UseCbc != false ? data + key + iv : data + key));
            boolean result = SM2Util.verifySign((String)clientId, (String)frontPubKey, (String)summary, (String)sign);
            HussarException.throwBy((!result ? 1 : 0) != 0, (Integer)EncryptExceptionEnum.ENCRYPT_SIGN_EXCEPTION.getExceptionCode(), (String)EncryptExceptionEnum.ENCRYPT_SIGN_EXCEPTION.getMessage());
        }
        String realKey = SM2Util.decrypt((String)key, (String)privateKeyBackend);
        if (sm4UseCbc.booleanValue()) {
            String realIv = SM2Util.decrypt((String)iv, (String)privateKeyBackend);
            realBody = SM4CbcUtil.decrypt(data, realKey, realIv);
        } else {
            realBody = SM4Util.decrypt((String)data, (String)realKey);
        }
        if (realBody.startsWith("\"") && realBody.endsWith("\"")) {
            realBody = realBody.substring(1, realBody.length() - 1);
        }
        byte[] realBodyBytes = realBody.getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(realBodyBytes);
        return new DecryptHttpInputMessage(inputStream, inputMessage.getHeaders());
    }

    public static boolean enableEncrypt(HttpHeaders headers, SecureEncryptProperties properties) {
        if (HussarUtils.isEmpty((Object)headers)) {
            return false;
        }
        if (!headers.containsKey((Object)properties.getHeaderEncrypt())) {
            return false;
        }
        String headersFirst = headers.getFirst(properties.getHeaderEncrypt());
        if (HussarUtils.isEmpty((Object)headersFirst) || HussarUtils.equals((Object)headersFirst, (Object)"0")) {
            return false;
        }
        return HussarUtils.equals((Object)headersFirst, (Object)"1");
    }

    public static void main(String[] args) {
        String sm4Key = SM4Util.getRandomKey();
        System.out.println("SM4Key= " + sm4Key);
        Map keyMapBackEnd = SM2Util.generateKeyPair();
        Map keyMapFronEnd = SM2Util.generateKeyPair();
        String frontPubKey = (String)keyMapFronEnd.get("pubKey");
        String backedPriKey = (String)keyMapBackEnd.get("priKey");
        String backedPubKey = (String)keyMapBackEnd.get("pubKey");
        String frontPriKey = (String)keyMapFronEnd.get("priKey");
        System.out.println("frontPubKey=" + frontPubKey);
        System.out.println("backedPriKey=" + backedPriKey);
        System.out.println("backedPubKey=" + backedPubKey);
        System.out.println("frontPriKey=" + frontPriKey);
    }
}

