/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.secure.encrypt.config;

import com.jxdinfo.hussar.platform.core.support.service.EncryptSupportService;
import com.jxdinfo.hussar.support.secure.encrypt.init.SecureApplicationRunner;
import com.jxdinfo.hussar.support.secure.encrypt.properties.SecureEncryptProperties;
import com.jxdinfo.hussar.support.secure.encrypt.support.SecureDecryptRequestBodyAdvice;
import com.jxdinfo.hussar.support.secure.encrypt.support.SecureEncryptResponseBodyAdvice;
import com.jxdinfo.hussar.support.secure.encrypt.support.service.impl.DefaultEncryptSupportService;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={SecureEncryptProperties.class})
@Import(value={SecureDecryptRequestBodyAdvice.class, SecureEncryptResponseBodyAdvice.class})
@ConditionalOnProperty(value={"hussar.secure.encrypt.enabled"}, havingValue="true", matchIfMissing=true)
public class SecureEncryptConfiguration {
    private final SecureEncryptProperties secureEncryptProperties;

    public SecureEncryptConfiguration(SecureEncryptProperties secureEncryptProperties) {
        this.secureEncryptProperties = secureEncryptProperties;
    }

    @Bean
    public ApplicationRunner secureApplicationRunner(SecureEncryptProperties secureEncryptProperties) {
        return new SecureApplicationRunner(secureEncryptProperties);
    }

    @Bean
    public EncryptSupportService defaultEncryptSupportService(SecureEncryptProperties secureEncryptProperties) {
        return new DefaultEncryptSupportService(secureEncryptProperties);
    }
}

