/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.secure.encrypt.support;

import com.jxdinfo.hussar.support.secure.encrypt.properties.SecureEncryptProperties;
import com.jxdinfo.hussar.support.secure.encrypt.utils.EncryptUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice;

@Order(value=1)
@ControllerAdvice
public class SecureDecryptRequestBodyAdvice
implements RequestBodyAdvice {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SecureEncryptProperties properties;

    public SecureDecryptRequestBodyAdvice(SecureEncryptProperties properties) {
        this.properties = properties;
    }

    public boolean supports(MethodParameter methodParameter, @NonNull Type targetType, @NonNull Class<? extends HttpMessageConverter<?>> converterType) {
        return this.properties.getEnabled();
    }

    public Object handleEmptyBody(Object body, @NonNull HttpInputMessage inputMessage, @NonNull MethodParameter parameter, @NonNull Type targetType, @NonNull Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    @NonNull
    public HttpInputMessage beforeBodyRead(HttpInputMessage inputMessage, @NonNull MethodParameter parameter, @NonNull Type targetType, @NonNull Class<? extends HttpMessageConverter<?>> converterType) throws IOException {
        HttpHeaders headers = inputMessage.getHeaders();
        if (!EncryptUtils.enableEncrypt(headers, this.properties)) {
            return inputMessage;
        }
        InputStream messageBody = inputMessage.getBody();
        if (messageBody.available() <= 0) {
            return inputMessage;
        }
        return EncryptUtils.decryptData(headers.getFirst("client-id"), inputMessage, this.properties);
    }

    @NonNull
    public Object afterBodyRead(@NonNull Object body, @NonNull HttpInputMessage inputMessage, @NonNull MethodParameter parameter, @NonNull Type targetType, @NonNull Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }
}

