/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.secure.encrypt.support.service.impl;

import com.jxdinfo.hussar.platform.core.support.service.EncryptSupportService;
import com.jxdinfo.hussar.platform.core.support.service.dto.EncryptDto;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.secure.encrypt.properties.SecureEncryptProperties;
import com.jxdinfo.hussar.support.secure.encrypt.utils.EncryptUtils;

public class DefaultEncryptSupportService
implements EncryptSupportService {
    private final SecureEncryptProperties secureEncryptProperties;

    public DefaultEncryptSupportService(SecureEncryptProperties secureEncryptProperties) {
        this.secureEncryptProperties = secureEncryptProperties;
    }

    public EncryptDto getInitEncryptInfo() {
        EncryptDto encryptDto = new EncryptDto();
        encryptDto.setHeaderEncrypt(HussarUtils.isEmpty((Object)this.secureEncryptProperties.getHeaderEncrypt()) ? "encrypt-header" : this.secureEncryptProperties.getHeaderEncrypt());
        encryptDto.setEnabledEncryptSign(this.secureEncryptProperties.getEnabledEncryptSign().booleanValue());
        String backPubKey = (String)HussarFixedCacheUtil.get((String)"encrypt_cache", (Object)"encrypt_back_pub", String.class);
        encryptDto.setBackendPubKey(backPubKey);
        String fontPriKey = (String)HussarFixedCacheUtil.get((String)"encrypt_cache", (Object)"encrypt_front_pri", String.class);
        encryptDto.setFrontPriKey(fontPriKey);
        encryptDto.setEnableEncryptCbcMode(this.secureEncryptProperties.getEnableEncryptCbcMode());
        return encryptDto;
    }

    public EncryptDto initEncryptInfo() {
        EncryptUtils.initSMKey();
        return this.getInitEncryptInfo();
    }
}

